/*     */ package org.jboss.reflect.plugins.introspection;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.lang.reflect.Field;
/*     */ import org.jboss.reflect.plugins.FieldInfoImpl;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public class ReflectFieldInfoImpl extends FieldInfoImpl
/*     */ {
/*     */   private static final long serialVersionUID = 2L;
/*     */   protected transient Field field;
/*     */ 
/*     */   public ReflectFieldInfoImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ReflectFieldInfoImpl(AnnotationValue[] annotations, String name, TypeInfo type, int modifiers, ClassInfo declaring)
/*     */   {
/*  65 */     super(annotations, name, type, modifiers, declaring);
/*     */   }
/*     */ 
/*     */   public void setField(Field field)
/*     */   {
/*  75 */     this.field = field;
/*     */   }
/*     */ 
/*     */   public Field getField()
/*     */   {
/*  85 */     return this.field;
/*     */   }
/*     */ 
/*     */   public Object get(Object target) throws Throwable
/*     */   {
/*  90 */     return ReflectionUtils.getField(this.field, target);
/*     */   }
/*     */ 
/*     */   public Object set(Object target, Object value) throws Throwable
/*     */   {
/*  95 */     return ReflectionUtils.setField(this.field, target, value);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream oistream)
/*     */     throws IOException, ClassNotFoundException, NoSuchFieldException
/*     */   {
/* 109 */     oistream.defaultReadObject();
/* 110 */     this.field = ReflectionUtils.findExactField(getDeclaringClass().getType(), this.name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.introspection.ReflectFieldInfoImpl
 * JD-Core Version:    0.6.0
 */