/*     */ package org.jboss.reflect.plugins.introspection;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.reflect.plugins.MethodInfoImpl;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.ParameterInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public class ReflectMethodInfoImpl extends MethodInfoImpl
/*     */ {
/*     */   private static final long serialVersionUID = 2L;
/*     */   protected transient Method method;
/*     */ 
/*     */   public ReflectMethodInfoImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ReflectMethodInfoImpl(AnnotationValue[] annotations, String name, TypeInfo returnType, TypeInfo[] parameterTypes, AnnotationValue[][] parameterAnnotations, ClassInfo[] exceptionTypes, int modifiers, ClassInfo declaring)
/*     */   {
/*  69 */     super(annotations, name, returnType, parameterTypes, parameterAnnotations, exceptionTypes, modifiers, declaring);
/*     */   }
/*     */ 
/*     */   public ReflectMethodInfoImpl(AnnotationValue[] annotations, String name, TypeInfo returnType, ParameterInfo[] parameters, ClassInfo[] exceptionTypes, int modifiers, ClassInfo declaring)
/*     */   {
/*  85 */     super(annotations, name, returnType, parameters, exceptionTypes, modifiers, declaring);
/*     */   }
/*     */ 
/*     */   public void setMethod(Method method)
/*     */   {
/*  95 */     this.method = method;
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/* 105 */     return this.method;
/*     */   }
/*     */ 
/*     */   public Object invoke(Object target, Object[] args) throws Throwable
/*     */   {
/* 110 */     return ReflectionUtils.invoke(this.method, target, args);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream oistream)
/*     */     throws IOException, ClassNotFoundException, NoSuchMethodException
/*     */   {
/* 124 */     oistream.defaultReadObject();
/* 125 */     int length = this.parameterTypes != null ? this.parameterTypes.length : 0;
/* 126 */     Class[] classes = new Class[length];
/* 127 */     for (int i = 0; i < length; i++)
/* 128 */       classes[i] = this.parameterTypes[i].getType();
/* 129 */     this.method = ReflectionUtils.findExactMethod(getDeclaringClass().getType(), this.name, classes);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.introspection.ReflectMethodInfoImpl
 * JD-Core Version:    0.6.0
 */