/*    */ package org.jboss.reflect.plugins.javassist;
/*    */ 
/*    */ import java.util.HashMap;
/*    */ import org.jboss.reflect.plugins.AbstractAnnotatedInfo;
/*    */ import org.jboss.reflect.plugins.AnnotationHelper;
/*    */ import org.jboss.reflect.spi.AnnotationInfo;
/*    */ import org.jboss.reflect.spi.AnnotationValue;
/*    */ 
/*    */ public abstract class JavassistAnnotatedInfo extends AbstractAnnotatedInfo
/*    */ {
/* 39 */   static final AnnotationValue[] NOT_CONFIGURED = new AnnotationValue[0];
/*    */ 
/* 42 */   protected AnnotationValue[] annotationsArray = NOT_CONFIGURED;
/*    */   protected HashMap<String, AnnotationValue> annotationMap;
/*    */   protected AnnotationHelper annotationHelper;
/*    */ 
/*    */   public JavassistAnnotatedInfo(AnnotationHelper annotationHelper)
/*    */   {
/* 51 */     this.annotationHelper = annotationHelper;
/*    */   }
/*    */ 
/*    */   protected AnnotationValue[] getAnnotations(Object obj)
/*    */   {
/* 56 */     synchronized (this)
/*    */     {
/* 58 */       if (this.annotationsArray == NOT_CONFIGURED)
/*    */       {
/* 60 */         this.annotationsArray = null;
/* 61 */         setupAnnotations(this.annotationHelper.getAnnotations(obj));
/*    */       }
/*    */     }
/* 64 */     return this.annotationsArray;
/*    */   }
/*    */ 
/*    */   public AnnotationValue getAnnotation(String name)
/*    */   {
/* 69 */     getAnnotations();
/* 70 */     return (AnnotationValue)this.annotationMap.get(name);
/*    */   }
/*    */ 
/*    */   public boolean isAnnotationPresent(String name)
/*    */   {
/* 75 */     getAnnotations();
/* 76 */     return this.annotationMap.containsKey(name);
/*    */   }
/*    */ 
/*    */   protected void setupAnnotations(AnnotationValue[] annotations)
/*    */   {
/* 86 */     if ((annotations != null) && (annotations.length > 0))
/*    */     {
/* 88 */       this.annotationsArray = annotations;
/* 89 */       this.annotationMap = new HashMap();
/* 90 */       for (int i = 0; i < annotations.length; i++)
/*    */       {
/* 92 */         AnnotationInfo type = annotations[i].getAnnotationType();
/* 93 */         this.annotationMap.put(type.getName(), annotations[i]);
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.javassist.JavassistAnnotatedInfo
 * JD-Core Version:    0.6.0
 */