/*    */ package org.jboss.reflect.plugins.javassist;
/*    */ 
/*    */ import java.lang.annotation.Annotation;
/*    */ import org.jboss.reflect.plugins.AnnotationHelper;
/*    */ import org.jboss.reflect.spi.AnnotationInfo;
/*    */ import org.jboss.reflect.spi.AnnotationValue;
/*    */ import org.jboss.reflect.spi.ClassInfo;
/*    */ import org.jboss.reflect.spi.ParameterInfo;
/*    */ import org.jboss.reflect.spi.TypeInfo;
/*    */ 
/*    */ public abstract class JavassistAnnotatedParameterInfo extends JavassistAnnotatedInfo
/*    */ {
/*    */   protected transient ParameterInfo[] parameters;
/*    */   protected transient TypeInfo[] parameterTypes;
/*    */   protected transient ClassInfo[] exceptionTypes;
/*    */   protected JavassistTypeInfo typeInfo;
/*    */ 
/*    */   public JavassistAnnotatedParameterInfo(AnnotationHelper annotationHelper)
/*    */   {
/* 54 */     super(annotationHelper);
/*    */   }
/*    */ 
/*    */   protected void setupParameterAnnotations(Object[][] annotations)
/*    */   {
/* 59 */     for (int param = 0; param < annotations.length; param++)
/*    */     {
/* 61 */       AnnotationValue[] annotationValues = new AnnotationValue[annotations[param].length];
/* 62 */       for (int ann = 0; ann < annotationValues.length; ann++)
/*    */       {
/* 64 */         Class clazz = ((Annotation)annotations[param][ann]).annotationType();
/*    */ 
/* 66 */         AnnotationInfo info = (AnnotationInfo)((JavassistTypeInfoFactoryImpl)this.annotationHelper).getTypeInfo(clazz);
/* 67 */         annotationValues[ann] = this.annotationHelper.createAnnotationValue(info, annotations[param][ann]);
/*    */       }
/* 69 */       ((JavassistParameterInfo)this.parameters[param]).setAnnotations(annotationValues);
/*    */     }
/*    */   }
/*    */ 
/*    */   protected abstract void createParameterAnnotations();
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.javassist.JavassistAnnotatedParameterInfo
 * JD-Core Version:    0.6.0
 */