/*    */ package org.jboss.reflect.plugins.javassist;
/*    */ 
/*    */ import java.util.HashMap;
/*    */ import javassist.CtClass;
/*    */ import org.jboss.reflect.plugins.AnnotationAttributeImpl;
/*    */ import org.jboss.reflect.plugins.AnnotationInfoImpl;
/*    */ import org.jboss.reflect.spi.AnnotationAttribute;
/*    */ import org.jboss.reflect.spi.AnnotationInfo;
/*    */ 
/*    */ public class JavassistAnnotationInfo extends JavassistTypeInfo
/*    */   implements AnnotationInfo
/*    */ {
/*    */   private static final long serialVersionUID = 3546645408219542832L;
/*    */   protected AnnotationAttribute[] attributes;
/*    */   protected HashMap<String, AnnotationAttribute> attributeMap;
/*    */ 
/*    */   public JavassistAnnotationInfo(JavassistTypeInfoFactoryImpl factory, CtClass ctClass, Class<? extends Object> clazz)
/*    */   {
/* 51 */     super(factory, ctClass, clazz);
/*    */   }
/*    */ 
/*    */   public void setAttributes(AnnotationAttributeImpl[] attributes)
/*    */   {
/* 61 */     this.attributes = attributes;
/* 62 */     if ((attributes != null) && (attributes.length > 0))
/*    */     {
/* 64 */       this.attributes = attributes;
/* 65 */       this.attributeMap = new HashMap();
/* 66 */       for (int i = 0; i < attributes.length; i++)
/*    */       {
/* 68 */         this.attributeMap.put(attributes[i].getName(), attributes[i]);
/*    */       }
/*    */     }
/*    */   }
/*    */ 
/*    */   public AnnotationAttribute[] getAttributes()
/*    */   {
/* 75 */     return this.attributes;
/*    */   }
/*    */ 
/*    */   public AnnotationAttribute getAttribute(String name)
/*    */   {
/* 80 */     if (this.attributeMap == null)
/* 81 */       return null;
/* 82 */     return (AnnotationAttribute)this.attributeMap.get(name);
/*    */   }
/*    */ 
/*    */   public boolean equals(Object o)
/*    */   {
/* 87 */     if (this == o) return true;
/* 88 */     if (!(o instanceof AnnotationInfoImpl)) return false;
/*    */ 
/* 90 */     AnnotationInfoImpl annotationInfo = (AnnotationInfoImpl)o;
/*    */ 
/* 92 */     return getName().equals(annotationInfo.getName());
/*    */   }
/*    */ 
/*    */   public int hashCode()
/*    */   {
/* 99 */     return getName().hashCode();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.javassist.JavassistAnnotationInfo
 * JD-Core Version:    0.6.0
 */