/*     */ package org.jboss.reflect.plugins.javassist;
/*     */ 
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.Arrays;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.reflect.plugins.AnnotationHelper;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.ConstructorInfo;
/*     */ import org.jboss.reflect.spi.ParameterInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class JavassistConstructorInfo extends JavassistAnnotatedParameterInfo
/*     */   implements ConstructorInfo
/*     */ {
/*     */   private static final long serialVersionUID = -2255405601790592604L;
/*  51 */   private static final JavassistReflectionFactory reflectionFactory = new JavassistReflectionFactory(true);
/*     */   private CtConstructor ctConstructor;
/*     */   private transient JavassistConstructor constructor;
/*     */ 
/*     */   public JavassistConstructorInfo(AnnotationHelper annotationHelper, JavassistTypeInfo typeInfo, CtConstructor ctConstructor)
/*     */   {
/*  68 */     super(annotationHelper);
/*  69 */     this.typeInfo = typeInfo;
/*  70 */     this.ctConstructor = ctConstructor;
/*     */   }
/*     */ 
/*     */   public int getModifiers()
/*     */   {
/*  76 */     return this.ctConstructor.getModifiers();
/*     */   }
/*     */ 
/*     */   public boolean isPublic()
/*     */   {
/*  81 */     return Modifier.isPublic(getModifiers());
/*     */   }
/*     */ 
/*     */   public boolean isStatic()
/*     */   {
/*  86 */     return Modifier.isStatic(getModifiers());
/*     */   }
/*     */ 
/*     */   public boolean isVolatile()
/*     */   {
/*  91 */     return Modifier.isVolatile(getModifiers());
/*     */   }
/*     */ 
/*     */   public ClassInfo getDeclaringClass()
/*     */   {
/*  96 */     return this.typeInfo;
/*     */   }
/*     */ 
/*     */   public ClassInfo[] getExceptionTypes()
/*     */   {
/* 101 */     if (this.exceptionTypes == null)
/*     */     {
/*     */       try
/*     */       {
/* 105 */         CtClass[] types = this.ctConstructor.getExceptionTypes();
/* 106 */         this.exceptionTypes = new ClassInfo[types.length];
/* 107 */         for (int i = 0; i < types.length; i++)
/* 108 */           this.exceptionTypes[i] = ((ClassInfo)this.typeInfo.getFactory().getTypeInfo(types[i]));
/*     */       }
/*     */       catch (NotFoundException e)
/*     */       {
/* 112 */         throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for exception types of constructor", e);
/*     */       }
/*     */     }
/* 115 */     return this.exceptionTypes;
/*     */   }
/*     */ 
/*     */   public ParameterInfo[] getParameters()
/*     */   {
/* 120 */     if (this.parameters == null)
/* 121 */       generateParameters();
/* 122 */     return this.parameters;
/*     */   }
/*     */ 
/*     */   public TypeInfo[] getParameterTypes()
/*     */   {
/* 127 */     if (this.parameterTypes == null)
/* 128 */       generateParameters();
/* 129 */     return this.parameterTypes;
/*     */   }
/*     */ 
/*     */   public Object newInstance(Object[] args) throws Throwable
/*     */   {
/* 134 */     if (this.constructor == null)
/* 135 */       this.constructor = reflectionFactory.createConstructor(this.ctConstructor);
/* 136 */     return this.constructor.newInstance(args);
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/* 141 */     int result = getDeclaringClass().hashCode();
/* 142 */     generateParameters();
/* 143 */     if (this.parameterTypes != null)
/*     */     {
/* 145 */       for (int i = 0; i < this.parameterTypes.length; i++)
/* 146 */         result = 29 * result + this.parameterTypes[i].hashCode();
/*     */     }
/* 148 */     return result;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 153 */     if (this == obj)
/* 154 */       return true;
/* 155 */     if ((obj == null) || (!(obj instanceof ConstructorInfo))) {
/* 156 */       return false;
/*     */     }
/* 158 */     ConstructorInfo other = (ConstructorInfo)obj;
/*     */ 
/* 160 */     if (!getDeclaringClass().equals(other.getDeclaringClass()))
/* 161 */       return false;
/* 162 */     return Arrays.equals(getParameterTypes(), other.getParameterTypes());
/*     */   }
/*     */ 
/*     */   protected void toString(JBossStringBuilder buffer)
/*     */   {
/* 168 */     buffer.append(Arrays.asList(getParameterTypes()));
/* 169 */     super.toString(buffer);
/*     */   }
/*     */ 
/*     */   protected void generateParameters()
/*     */   {
/*     */     try
/*     */     {
/* 179 */       CtClass[] types = this.ctConstructor.getParameterTypes();
/* 180 */       this.parameterTypes = new TypeInfo[types.length];
/* 181 */       for (int i = 0; i < types.length; i++)
/* 182 */         this.parameterTypes[i] = this.typeInfo.getFactory().getTypeInfo(types[i]);
/* 183 */       this.parameters = new ParameterInfo[types.length];
/* 184 */       for (int i = 0; i < types.length; i++)
/* 185 */         this.parameters[i] = new JavassistParameterInfo(this.annotationHelper, this, i, this.parameterTypes[i]);
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/* 189 */       throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for parameters of constructor", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public AnnotationValue[] getAnnotations()
/*     */   {
/* 195 */     return getAnnotations(this.ctConstructor);
/*     */   }
/*     */ 
/*     */   protected void createParameterAnnotations()
/*     */   {
/*     */     try
/*     */     {
/* 202 */       Object[][] parameterAnnotations = this.ctConstructor.getParameterAnnotations();
/* 203 */       super.setupParameterAnnotations(parameterAnnotations);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 208 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.javassist.JavassistConstructorInfo
 * JD-Core Version:    0.6.0
 */