/*     */ package org.jboss.reflect.plugins.javassist;
/*     */ 
/*     */ import java.lang.annotation.Inherited;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javassist.CtClass;
/*     */ import org.jboss.reflect.plugins.AnnotationHelper;
/*     */ import org.jboss.reflect.spi.AnnotationInfo;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ 
/*     */ public abstract class JavassistInheritableAnnotationHolder extends JavassistAnnotatedInfo
/*     */ {
/*  41 */   private static final String INHERITED_NAME = Inherited.class.getName();
/*     */   protected Map<String, AnnotationValue> allAnnotations;
/*  47 */   protected AnnotationValue[] allAnnotationsArray = NOT_CONFIGURED;
/*     */   protected CtClass ctClass;
/*     */ 
/*     */   public JavassistInheritableAnnotationHolder(CtClass ctClass, AnnotationHelper annotationHelper)
/*     */   {
/*  53 */     super(annotationHelper);
/*  54 */     this.ctClass = ctClass;
/*     */   }
/*     */ 
/*     */   public AnnotationValue[] getAnnotations()
/*     */   {
/*  59 */     if (this.allAnnotationsArray == NOT_CONFIGURED)
/*  60 */       setupAnnotations(this.annotationHelper.getAnnotations(this.ctClass));
/*  61 */     return this.allAnnotationsArray;
/*     */   }
/*     */ 
/*     */   protected AnnotationValue[] getAnnotations(Object obj)
/*     */   {
/*  66 */     synchronized (this)
/*     */     {
/*  68 */       if (this.allAnnotationsArray == NOT_CONFIGURED)
/*     */       {
/*  70 */         this.allAnnotationsArray = this.annotationHelper.getAnnotations(obj);
/*  71 */         setupAnnotations(this.allAnnotationsArray);
/*     */       }
/*     */     }
/*     */ 
/*  75 */     return this.allAnnotationsArray;
/*     */   }
/*     */ 
/*     */   public AnnotationValue getAnnotation(String name)
/*     */   {
/*  80 */     getAnnotations();
/*  81 */     return (AnnotationValue)this.allAnnotations.get(name);
/*     */   }
/*     */ 
/*     */   public boolean isAnnotationPresent(String name)
/*     */   {
/*  86 */     getAnnotations();
/*  87 */     return this.allAnnotations.containsKey(name);
/*     */   }
/*     */ 
/*     */   public void setupAnnotations(AnnotationValue[] annotations)
/*     */   {
/*  98 */     JavassistInheritableAnnotationHolder superHolder = getSuperHolder();
/*  99 */     AnnotationValue[] superAllAnnotations = superHolder != null ? superHolder.getAnnotations() : null;
/*     */ 
/* 101 */     if ((annotations != null) && (annotations.length > 0))
/*     */     {
/* 103 */       this.annotationMap = new HashMap();
/* 104 */       this.annotationsArray = annotations;
/* 105 */       for (int i = 0; i < annotations.length; i++)
/*     */       {
/* 107 */         this.annotationMap.put(annotations[i].getAnnotationType().getName(), annotations[i]);
/*     */       }
/* 109 */       this.allAnnotations = new HashMap();
/*     */ 
/* 111 */       if ((superHolder != null) && (superAllAnnotations != null) && (superAllAnnotations.length != 0))
/*     */       {
/* 113 */         for (int i = 0; i < superAllAnnotations.length; i++)
/*     */         {
/* 115 */           AnnotationValue av = superAllAnnotations[i];
/* 116 */           if (!av.getAnnotationType().isAnnotationPresent(INHERITED_NAME))
/*     */             continue;
/* 118 */           this.allAnnotations.put(av.getAnnotationType().getName(), av);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 123 */         this.allAnnotationsArray = this.annotationsArray;
/*     */       }
/* 125 */       for (int i = 0; i < annotations.length; i++) {
/* 126 */         this.allAnnotations.put(annotations[i].getAnnotationType().getName(), annotations[i]);
/*     */       }
/* 128 */       this.allAnnotationsArray = ((AnnotationValue[])this.allAnnotations.values().toArray(new AnnotationValue[this.allAnnotations.size()]));
/*     */     }
/* 132 */     else if (superHolder != null)
/*     */     {
/* 134 */       this.allAnnotations = superHolder.getAllAnnotations();
/* 135 */       this.allAnnotationsArray = superAllAnnotations;
/*     */     }
/*     */     else
/*     */     {
/* 139 */       this.allAnnotations = new HashMap();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Map<String, AnnotationValue> getAllAnnotations()
/*     */   {
/* 151 */     if (this.allAnnotations == null)
/* 152 */       setupAnnotations(this.annotationHelper.getAnnotations(this.ctClass));
/* 153 */     return this.allAnnotations;
/*     */   }
/*     */ 
/*     */   public abstract JavassistInheritableAnnotationHolder getSuperHolder();
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.javassist.JavassistInheritableAnnotationHolder
 * JD-Core Version:    0.6.0
 */