/*     */ package org.jboss.reflect.plugins.javassist;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.lang.reflect.Type;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMember;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtPrimitiveType;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.reflect.plugins.AnnotationAttributeImpl;
/*     */ import org.jboss.reflect.plugins.AnnotationHelper;
/*     */ import org.jboss.reflect.plugins.AnnotationValueFactory;
/*     */ import org.jboss.reflect.plugins.AnnotationValueImpl;
/*     */ import org.jboss.reflect.plugins.EnumConstantInfoImpl;
/*     */ import org.jboss.reflect.spi.AnnotationInfo;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.NumberInfo;
/*     */ import org.jboss.reflect.spi.PrimitiveInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.TypeInfoFactory;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.util.collection.WeakClassCache;
/*     */ 
/*     */ public class JavassistTypeInfoFactoryImpl extends WeakClassCache
/*     */   implements TypeInfoFactory, AnnotationHelper
/*     */ {
/*  51 */   static final ClassPool pool = ClassPool.getDefault();
/*     */ 
/*  53 */   static final AnnotationValue[] NO_ANNOTATIONS = new AnnotationValue[0];
/*     */ 
/*     */   public static NoClassDefFoundError raiseClassNotFound(String name, NotFoundException e)
/*     */     throws NoClassDefFoundError
/*     */   {
/*  64 */     NoClassDefFoundError ex = new NoClassDefFoundError("Unable to find class");
/*  65 */     if (e.getCause() != null)
/*  66 */       ex.initCause(e.getCause());
/*  67 */     throw ex;
/*     */   }
/*     */ 
/*     */   public static NoClassDefFoundError raiseClassNotFound(String name, ClassNotFoundException e)
/*     */     throws NoClassDefFoundError
/*     */   {
/*  80 */     NoClassDefFoundError ex = new NoClassDefFoundError("Unable to find class");
/*  81 */     ex.initCause(e);
/*  82 */     throw ex;
/*     */   }
/*     */ 
/*     */   public static NoClassDefFoundError raiseMethodNotFound(String name, NotFoundException e)
/*     */     throws NoClassDefFoundError
/*     */   {
/*  95 */     NoSuchMethodError ex = new NoSuchMethodError("Unable to find method " + name);
/*  96 */     if (e.getCause() != null)
/*  97 */       ex.initCause(e.getCause());
/*  98 */     throw ex;
/*     */   }
/*     */ 
/*     */   public static NoClassDefFoundError raiseFieldNotFound(String name, NotFoundException e)
/*     */     throws NoClassDefFoundError
/*     */   {
/* 111 */     NoSuchFieldError ex = new NoSuchFieldError("Unable to find field");
/* 112 */     if (e.getCause() != null)
/* 113 */       ex.initCause(e.getCause());
/* 114 */     throw ex;
/*     */   }
/*     */ 
/*     */   protected Object instantiate(Class clazz)
/*     */   {
/*     */     try
/*     */     {
/* 122 */       CtClass ctClass = getCtClass(clazz.getName());
/*     */ 
/* 124 */       if (clazz.isArray())
/*     */       {
/* 126 */         TypeInfo componentType = getTypeInfo(clazz.getComponentType());
/* 127 */         return new JavassistArrayInfoImpl(this, ctClass, clazz, componentType);
/*     */       }
/*     */ 
/* 130 */       if (ctClass.isAnnotation())
/*     */       {
/* 132 */         JavassistAnnotationInfo result = new JavassistAnnotationInfo(this, ctClass, clazz);
/* 133 */         CtMethod[] methods = ctClass.getDeclaredMethods();
/* 134 */         AnnotationAttributeImpl[] atttributes = new AnnotationAttributeImpl[methods.length];
/* 135 */         for (int i = 0; i < methods.length; i++)
/*     */         {
/* 137 */           atttributes[i] = new AnnotationAttributeImpl(methods[i].getName(), getTypeInfo(methods[i].getReturnType()), null);
/*     */         }
/* 139 */         result.setAttributes(atttributes);
/* 140 */         return result;
/*     */       }
/*     */ 
/* 143 */       if (ctClass.isEnum())
/*     */       {
/* 145 */         JavassistEnumInfo enumInfo = new JavassistEnumInfo(this, ctClass, clazz);
/* 146 */         CtField[] fields = ctClass.getFields();
/* 147 */         EnumConstantInfoImpl[] constants = new EnumConstantInfoImpl[fields.length];
/* 148 */         int i = 0;
/* 149 */         for (CtField field : fields)
/*     */         {
/* 151 */           AnnotationValue[] annotations = getAnnotations(field);
/* 152 */           constants[(i++)] = new EnumConstantInfoImpl(field.getName(), enumInfo, annotations);
/*     */         }
/* 154 */         enumInfo.setEnumConstants(constants);
/* 155 */         return enumInfo;
/*     */       }
/*     */ 
/* 159 */       return new JavassistTypeInfo(this, ctClass, clazz);
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/* 163 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   protected TypeInfo getTypeInfo(CtClass ctClass)
/*     */   {
/*     */     try
/*     */     {
/* 177 */       String name = convertName(ctClass);
/* 178 */       return getTypeInfo(name, null);
/*     */     }
/*     */     catch (ClassNotFoundException e) {
/*     */     }
/* 182 */     throw raiseClassNotFound(ctClass.getName(), e);
/*     */   }
/*     */ 
/*     */   protected String convertName(CtClass clazz)
/*     */   {
/* 194 */     CtClass temp = clazz;
/* 195 */     if (temp.isArray())
/*     */     {
/* 197 */       JBossStringBuilder buffer = new JBossStringBuilder();
/*     */       try
/*     */       {
/* 200 */         while (temp.isArray())
/*     */         {
/* 202 */           buffer.append('[');
/* 203 */           temp = temp.getComponentType();
/*     */         }
/* 205 */         if (temp.isPrimitive())
/*     */         {
/* 207 */           CtPrimitiveType primitive = (CtPrimitiveType)temp;
/* 208 */           buffer.append(Character.toString(primitive.getDescriptor()));
/*     */         }
/*     */         else
/*     */         {
/* 212 */           buffer.append('L');
/* 213 */           buffer.append(temp.getName());
/* 214 */           buffer.append(';');
/*     */         }
/* 216 */         return buffer.toString();
/*     */       }
/*     */       catch (NotFoundException e)
/*     */       {
/* 220 */         throw raiseClassNotFound(clazz.getName(), e);
/*     */       }
/*     */     }
/* 223 */     return clazz.getName();
/*     */   }
/*     */ 
/*     */   protected CtClass getCtClass(String name)
/*     */   {
/*     */     try
/*     */     {
/* 236 */       return pool.get(name);
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/* 240 */     throw raiseClassNotFound(name, e);
/*     */   }
/*     */ 
/*     */   protected void generate(Class clazz, Object result)
/*     */   {
/*     */   }
/*     */ 
/*     */   public TypeInfo getTypeInfo(Class clazz)
/*     */   {
/* 251 */     if (clazz == null) {
/* 252 */       throw new IllegalArgumentException("Null class");
/*     */     }
/* 254 */     TypeInfo primitive = PrimitiveInfo.valueOf(clazz.getName());
/* 255 */     if (primitive != null) {
/* 256 */       return primitive;
/*     */     }
/* 258 */     NumberInfo number = NumberInfo.valueOf(clazz.getName());
/* 259 */     if (number != null)
/*     */     {
/* 261 */       if (!number.isInitialized())
/*     */       {
/* 263 */         number.setDelegate((TypeInfo)get(clazz));
/*     */       }
/* 265 */       return number;
/*     */     }
/*     */ 
/* 268 */     return (TypeInfo)get(clazz);
/*     */   }
/*     */ 
/*     */   public TypeInfo getTypeInfo(String name, ClassLoader cl) throws ClassNotFoundException
/*     */   {
/* 273 */     if (name == null)
/* 274 */       throw new IllegalArgumentException("Null class name");
/* 275 */     if (cl == null) {
/* 276 */       cl = Thread.currentThread().getContextClassLoader();
/*     */     }
/* 278 */     TypeInfo primitive = PrimitiveInfo.valueOf(name);
/* 279 */     if (primitive != null) {
/* 280 */       return primitive;
/*     */     }
/* 282 */     NumberInfo number = NumberInfo.valueOf(name);
/* 283 */     if (number != null)
/*     */     {
/* 285 */       if (!number.isInitialized())
/*     */       {
/* 287 */         number.setDelegate((TypeInfo)get(cl.loadClass(name)));
/*     */       }
/* 289 */       return number;
/*     */     }
/*     */ 
/* 292 */     Class clazz = cl.loadClass(name);
/* 293 */     return getTypeInfo(clazz);
/*     */   }
/*     */ 
/*     */   public TypeInfo getTypeInfo(Type type)
/*     */   {
/* 298 */     if ((type instanceof Class)) {
/* 299 */       return getTypeInfo((Class)type);
/*     */     }
/*     */ 
/* 302 */     throw new NotImplementedException("getTypeInfo");
/*     */   }
/*     */ 
/*     */   public AnnotationValue[] getAnnotations(Object obj)
/*     */   {
/*     */     try
/*     */     {
/*     */       Object[] annotations;
/* 310 */       if ((obj instanceof CtMember))
/*     */       {
/* 312 */         annotations = ((CtMember)obj).getAvailableAnnotations();
/*     */       }
/*     */       else
/*     */       {
/*     */         Object[] annotations;
/* 314 */         if ((obj instanceof CtClass))
/*     */         {
/* 316 */           annotations = ((CtClass)obj).getAvailableAnnotations();
/*     */         }
/*     */         else
/*     */         {
/* 320 */           throw new RuntimeException("Attempt was made to read annotations from unsupported type " + obj.getClass().getName() + ": " + obj);
/*     */         }
/*     */       }
/*     */       Object[] annotations;
/* 323 */       if (annotations.length == 0)
/*     */       {
/* 325 */         return NO_ANNOTATIONS;
/*     */       }
/*     */ 
/* 328 */       AnnotationValue[] annotationValues = new AnnotationValueImpl[annotations.length];
/* 329 */       for (int i = 0; i < annotations.length; i++)
/*     */       {
/* 331 */         Class clazz = ((Annotation)annotations[i]).annotationType();
/*     */ 
/* 333 */         AnnotationInfo info = (AnnotationInfo)getTypeInfo(clazz);
/* 334 */         annotationValues[i] = AnnotationValueFactory.createAnnotationValue(this, this, info, annotations[i]);
/*     */       }
/* 336 */       return annotationValues;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*     */     }
/*     */ 
/* 344 */     throw new RuntimeException(t);
/*     */   }
/*     */ 
/*     */   public AnnotationValue createAnnotationValue(AnnotationInfo info, Object ann)
/*     */   {
/* 350 */     return AnnotationValueFactory.createAnnotationValue(this, this, info, ann);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl
 * JD-Core Version:    0.6.0
 */