/*     */ package org.jboss.reflect.spi;
/*     */ 
/*     */ import org.jboss.reflect.plugins.TypeInfoAttachments;
/*     */ import org.jboss.util.JBossObject;
/*     */ 
/*     */ public abstract class AbstractTypeInfo extends JBossObject
/*     */   implements TypeInfo
/*     */ {
/*     */   private transient TypeInfoAttachments attachments;
/*     */ 
/*     */   public boolean isArray()
/*     */   {
/*  40 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isCollection()
/*     */   {
/*  45 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isMap()
/*     */   {
/*  50 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isAnnotation()
/*     */   {
/*  55 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isEnum()
/*     */   {
/*  60 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isPrimitive()
/*     */   {
/*  65 */     return false;
/*     */   }
/*     */ 
/*     */   public void setAttachment(String name, Object attachment)
/*     */   {
/*  70 */     if (name == null)
/*  71 */       throw new IllegalArgumentException("Null name");
/*  72 */     synchronized (this)
/*     */     {
/*  74 */       if (this.attachments == null)
/*     */       {
/*  76 */         if (attachment == null)
/*  77 */           return;
/*  78 */         this.attachments = new TypeInfoAttachments();
/*     */       }
/*     */     }
/*  81 */     if (attachment == null)
/*  82 */       this.attachments.removeAttachment(name);
/*     */     else
/*  84 */       this.attachments.addAttachment(name, attachment);
/*     */   }
/*     */ 
/*     */   public <T> T getAttachment(Class<T> expectedType)
/*     */   {
/*  89 */     if (expectedType == null)
/*  90 */       throw new IllegalArgumentException("Null expectedType");
/*  91 */     Object result = getAttachment(expectedType.getName());
/*  92 */     if (result == null)
/*  93 */       return null;
/*  94 */     return expectedType.cast(result);
/*     */   }
/*     */ 
/*     */   public Object getAttachment(String name)
/*     */   {
/*  99 */     if (name == null)
/* 100 */       throw new IllegalArgumentException("Null name");
/* 101 */     synchronized (this)
/*     */     {
/* 103 */       if (this.attachments == null)
/* 104 */         return null;
/*     */     }
/* 106 */     return this.attachments.getAttachment(name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.spi.AbstractTypeInfo
 * JD-Core Version:    0.6.0
 */