/*     */ package org.jboss.reflect.spi;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.security.DigestOutputStream;
/*     */ import java.security.MessageDigest;
/*     */ 
/*     */ public class MethodInfoHashing
/*     */ {
/*     */   public static long methodHash(MethodInfo method)
/*     */     throws Exception
/*     */   {
/*  40 */     TypeInfo[] parameterTypes = method.getParameterTypes();
/*  41 */     String methodDesc = method.getName() + "(";
/*  42 */     for (int j = 0; j < parameterTypes.length; j++)
/*     */     {
/*  44 */       methodDesc = methodDesc + getTypeString(parameterTypes[j]);
/*     */     }
/*  46 */     methodDesc = methodDesc + ")" + getTypeString(method.getReturnType());
/*  47 */     return createHash(methodDesc);
/*     */   }
/*     */ 
/*     */   public static long createHash(String methodDesc)
/*     */     throws Exception
/*     */   {
/*  53 */     long hash = 0L;
/*  54 */     ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
/*  55 */     MessageDigest messagedigest = MessageDigest.getInstance("SHA");
/*  56 */     DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
/*  57 */     dataoutputstream.writeUTF(methodDesc);
/*  58 */     dataoutputstream.flush();
/*  59 */     byte[] abyte0 = messagedigest.digest();
/*  60 */     for (int j = 0; j < Math.min(8, abyte0.length); j++)
/*  61 */       hash += ((abyte0[j] & 0xFF) << j * 8);
/*  62 */     return hash;
/*     */   }
/*     */ 
/*     */   static String getTypeString(TypeInfo cl)
/*     */   {
/*  69 */     if (cl == PrimitiveInfo.BYTE)
/*     */     {
/*  71 */       return "B";
/*     */     }
/*  73 */     if (cl == PrimitiveInfo.CHAR)
/*     */     {
/*  75 */       return "C";
/*     */     }
/*  77 */     if (cl == PrimitiveInfo.DOUBLE)
/*     */     {
/*  79 */       return "D";
/*     */     }
/*  81 */     if (cl == PrimitiveInfo.FLOAT)
/*     */     {
/*  83 */       return "F";
/*     */     }
/*  85 */     if (cl == PrimitiveInfo.INT)
/*     */     {
/*  87 */       return "I";
/*     */     }
/*  89 */     if (cl == PrimitiveInfo.LONG)
/*     */     {
/*  91 */       return "J";
/*     */     }
/*  93 */     if (cl == PrimitiveInfo.SHORT)
/*     */     {
/*  95 */       return "S";
/*     */     }
/*  97 */     if (cl == PrimitiveInfo.BOOLEAN)
/*     */     {
/*  99 */       return "Z";
/*     */     }
/* 101 */     if (cl == PrimitiveInfo.VOID)
/*     */     {
/* 103 */       return "V";
/*     */     }
/* 105 */     if ((cl instanceof ArrayInfo))
/*     */     {
/* 107 */       ArrayInfo ai = (ArrayInfo)cl;
/* 108 */       return "[" + getTypeString(ai.getComponentType());
/*     */     }
/*     */ 
/* 112 */     return "L" + cl.getName().replace('.', '/') + ";";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.spi.MethodInfoHashing
 * JD-Core Version:    0.6.0
 */