/*     */ package org.jboss.reflect.spi;
/*     */ 
/*     */ import java.io.ObjectStreamException;
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.util.HashMap;
/*     */ import java.util.concurrent.atomic.AtomicInteger;
/*     */ import java.util.concurrent.atomic.AtomicLong;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class NumberInfo extends PrimitiveInfo
/*     */   implements ClassInfo
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  43 */   public static final NumberInfo BYTE_OBJECT = new NumberInfo(0, Byte.class);
/*     */ 
/*  46 */   public static final NumberInfo DOUBLE_OBJECT = new NumberInfo(1, Double.class);
/*     */ 
/*  49 */   public static final NumberInfo FLOAT_OBJECT = new NumberInfo(2, Float.class);
/*     */ 
/*  52 */   public static final NumberInfo INT_OBJECT = new NumberInfo(3, Integer.class);
/*     */ 
/*  55 */   public static final NumberInfo LONG_OBJECT = new NumberInfo(4, Long.class);
/*     */ 
/*  58 */   public static final NumberInfo SHORT_OBJECT = new NumberInfo(5, Short.class);
/*     */ 
/*  61 */   public static final NumberInfo ATOMIC_INT = new NumberInfo(6, AtomicInteger.class);
/*     */ 
/*  64 */   public static final NumberInfo ATOMIC_LONG = new NumberInfo(7, AtomicLong.class);
/*     */ 
/*  67 */   private static final NumberInfo[] values = { BYTE_OBJECT, DOUBLE_OBJECT, FLOAT_OBJECT, INT_OBJECT, LONG_OBJECT, SHORT_OBJECT, ATOMIC_INT, ATOMIC_LONG };
/*     */ 
/*  79 */   private static final HashMap<String, NumberInfo> map = new HashMap();
/*     */   private transient ClassInfo delegate;
/*     */ 
/*     */   public static NumberInfo valueOf(String name)
/*     */   {
/* 103 */     return (NumberInfo)map.get(name);
/*     */   }
/*     */ 
/*     */   protected NumberInfo(int ordinal, Class<? extends Object> type)
/*     */   {
/* 114 */     super(type.getName(), ordinal, type);
/*     */   }
/*     */ 
/*     */   public void setDelegate(TypeInfo info)
/*     */   {
/* 125 */     if (info == null)
/* 126 */       throw new IllegalArgumentException("Null info");
/* 127 */     if (!(info instanceof ClassInfo))
/* 128 */       throw new IllegalArgumentException("Should be of ClassInfo instance: " + info.getClass().getName());
/* 129 */     this.delegate = ((ClassInfo)info);
/*     */   }
/*     */ 
/*     */   public boolean isInitialized()
/*     */   {
/* 139 */     return this.delegate != null;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 145 */     if (obj == this)
/* 146 */       return true;
/* 147 */     if (obj == null)
/* 148 */       return false;
/* 149 */     if (!(obj instanceof NumberInfo))
/* 150 */       return false;
/* 151 */     NumberInfo other = (NumberInfo)obj;
/* 152 */     return other.ordinal == this.ordinal;
/*     */   }
/*     */ 
/*     */   Object readResolve() throws ObjectStreamException
/*     */   {
/* 157 */     return values[this.ordinal];
/*     */   }
/*     */ 
/*     */   public ConstructorInfo getDeclaredConstructor(TypeInfo[] parameters)
/*     */   {
/* 164 */     return this.delegate.getDeclaredConstructor(parameters);
/*     */   }
/*     */ 
/*     */   public ConstructorInfo[] getDeclaredConstructors()
/*     */   {
/* 169 */     return this.delegate.getDeclaredConstructors();
/*     */   }
/*     */ 
/*     */   public FieldInfo getDeclaredField(String name)
/*     */   {
/* 174 */     return this.delegate.getDeclaredField(name);
/*     */   }
/*     */ 
/*     */   public FieldInfo[] getDeclaredFields()
/*     */   {
/* 179 */     return this.delegate.getDeclaredFields();
/*     */   }
/*     */ 
/*     */   public MethodInfo getDeclaredMethod(String name, TypeInfo[] parameters)
/*     */   {
/* 184 */     return this.delegate.getDeclaredMethod(name, parameters);
/*     */   }
/*     */ 
/*     */   public MethodInfo[] getDeclaredMethods()
/*     */   {
/* 189 */     return this.delegate.getDeclaredMethods();
/*     */   }
/*     */ 
/*     */   public InterfaceInfo[] getGenericInterfaces()
/*     */   {
/* 194 */     return this.delegate.getGenericInterfaces();
/*     */   }
/*     */ 
/*     */   public ClassInfo getGenericSuperclass()
/*     */   {
/* 199 */     return this.delegate.getGenericSuperclass();
/*     */   }
/*     */ 
/*     */   public InterfaceInfo[] getInterfaces()
/*     */   {
/* 204 */     return this.delegate.getInterfaces();
/*     */   }
/*     */ 
/*     */   public ClassInfo getSuperclass()
/*     */   {
/* 209 */     return this.delegate.getSuperclass();
/*     */   }
/*     */ 
/*     */   public boolean isInterface()
/*     */   {
/* 214 */     return this.delegate.isInterface();
/*     */   }
/*     */ 
/*     */   public AnnotationValue getAnnotation(String name)
/*     */   {
/* 219 */     return this.delegate.getAnnotation(name);
/*     */   }
/*     */ 
/*     */   public AnnotationValue[] getAnnotations()
/*     */   {
/* 224 */     return this.delegate.getAnnotations();
/*     */   }
/*     */ 
/*     */   public boolean isAnnotationPresent(String name)
/*     */   {
/* 229 */     return this.delegate.isAnnotationPresent(name);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T getUnderlyingAnnotation(Class<T> annotationType)
/*     */   {
/* 234 */     return this.delegate.getUnderlyingAnnotation(annotationType);
/*     */   }
/*     */ 
/*     */   public Annotation[] getUnderlyingAnnotations()
/*     */   {
/* 239 */     return this.delegate.getUnderlyingAnnotations();
/*     */   }
/*     */ 
/*     */   public boolean isAnnotationPresent(Class<? extends Annotation> annotationType)
/*     */   {
/* 244 */     return this.delegate.isAnnotationPresent(annotationType);
/*     */   }
/*     */ 
/*     */   public int getModifiers()
/*     */   {
/* 249 */     return this.delegate.getModifiers();
/*     */   }
/*     */ 
/*     */   public boolean isPublic()
/*     */   {
/* 254 */     return this.delegate.isPublic();
/*     */   }
/*     */ 
/*     */   public boolean isStatic()
/*     */   {
/* 259 */     return this.delegate.isStatic();
/*     */   }
/*     */ 
/*     */   public boolean isVolatile()
/*     */   {
/* 264 */     return this.delegate.isVolatile();
/*     */   }
/*     */ 
/*     */   public boolean isPrimitive()
/*     */   {
/* 269 */     return this.delegate.isPrimitive();
/*     */   }
/*     */ 
/*     */   public TypeInfo[] getActualTypeArguments()
/*     */   {
/* 274 */     return this.delegate.getActualTypeArguments();
/*     */   }
/*     */ 
/*     */   public TypeInfo getOwnerType()
/*     */   {
/* 279 */     return this.delegate.getOwnerType();
/*     */   }
/*     */ 
/*     */   public ClassInfo getRawType()
/*     */   {
/* 284 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   public TypeInfo getComponentType()
/*     */   {
/* 289 */     return this.delegate.getComponentType();
/*     */   }
/*     */ 
/*     */   public TypeInfo getKeyType()
/*     */   {
/* 294 */     return this.delegate.getKeyType();
/*     */   }
/*     */ 
/*     */   public TypeInfo getValueType()
/*     */   {
/* 299 */     return this.delegate.getValueType();
/*     */   }
/*     */ 
/*     */   public PackageInfo getPackage()
/*     */   {
/* 304 */     return this.delegate.getPackage();
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/* 310 */     return this;
/*     */   }
/*     */ 
/*     */   public String toShortString()
/*     */   {
/* 315 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 320 */     buffer.append(this.name);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  83 */     map.put(Byte.class.getName(), BYTE_OBJECT);
/*  84 */     map.put(Double.class.getName(), DOUBLE_OBJECT);
/*  85 */     map.put(Float.class.getName(), FLOAT_OBJECT);
/*  86 */     map.put(Integer.class.getName(), INT_OBJECT);
/*  87 */     map.put(Long.class.getName(), LONG_OBJECT);
/*  88 */     map.put(Short.class.getName(), SHORT_OBJECT);
/*  89 */     map.put(AtomicInteger.class.getName(), ATOMIC_INT);
/*  90 */     map.put(AtomicLong.class.getName(), ATOMIC_LONG);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.spi.NumberInfo
 * JD-Core Version:    0.6.0
 */