/*      */ package org.jboss.remoting;
/*      */ 
/*      */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
/*      */ import java.io.IOException;
/*      */ import java.lang.reflect.Constructor;
/*      */ import java.net.InetAddress;
/*      */ import java.net.MalformedURLException;
/*      */ import java.net.UnknownHostException;
/*      */ import java.util.Collection;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import javax.management.MBeanServer;
/*      */ import javax.management.MBeanServerInvocationHandler;
/*      */ import javax.management.MalformedObjectNameException;
/*      */ import javax.management.ObjectName;
/*      */ import javax.net.ServerSocketFactory;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.remoting.callback.Callback;
/*      */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*      */ import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
/*      */ import org.jboss.remoting.invocation.InternalInvocation;
/*      */ import org.jboss.remoting.invocation.OnewayInvocation;
/*      */ import org.jboss.remoting.loading.ClassByteClassLoader;
/*      */ import org.jboss.remoting.loading.ClassBytes;
/*      */ import org.jboss.remoting.security.SSLSocketBuilder;
/*      */ import org.jboss.remoting.security.ServerSocketFactoryMBean;
/*      */ import org.jboss.remoting.security.ServerSocketFactoryWrapper;
/*      */ import org.jboss.remoting.serialization.ClassLoaderUtility;
/*      */ import org.jboss.remoting.socketfactory.CreationListenerServerSocketFactory;
/*      */ import org.jboss.remoting.socketfactory.SocketCreationListener;
/*      */ import org.jboss.remoting.stream.StreamHandler;
/*      */ import org.jboss.remoting.stream.StreamInvocationHandler;
/*      */ import org.jboss.remoting.transport.PortUtil;
/*      */ import org.jboss.util.threadpool.BasicThreadPool;
/*      */ import org.jboss.util.threadpool.BlockingMode;
/*      */ import org.jboss.util.threadpool.ThreadPool;
/*      */ import org.jboss.util.threadpool.ThreadPoolMBean;
/*      */ 
/*      */ public abstract class ServerInvoker extends AbstractInvoker
/*      */   implements ServerInvokerMBean
/*      */ {
/*   78 */   private static final Logger log = Logger.getLogger(ServerInvoker.class);
/*      */   public static final String MAX_NUM_ONEWAY_THREADS_KEY = "maxNumThreadsOneway";
/*      */   public static final String ONEWAY_THREAD_POOL_CLASS_KEY = "onewayThreadPool";
/*      */   public static final String SERVER_BIND_ADDRESS_KEY = "serverBindAddress";
/*      */   public static final String CLIENT_CONNECT_ADDRESS_KEY = "clientConnectAddress";
/*      */   public static final String SERVER_BIND_PORT_KEY = "serverBindPort";
/*      */   public static final String CLIENT_CONNECT_PORT_KEY = "clientConnectPort";
/*      */   public static final String CLIENT_LEASE_PERIOD = "clientLeasePeriod";
/*      */   public static final String TIMEOUT = "timeout";
/*      */   public static final String SERVER_SOCKET_FACTORY = "serverSocketFactory";
/*      */   public static final int MAX_NUM_ONEWAY_THREADS = 100;
/*      */   public static final String MAX_ONEWAY_THREAD_POOL_QUEUE_SIZE = "maxOnewayThreadPoolQueueSize";
/*      */   public static final int DEFAULT_CLIENT_LEASE_PERIOD = 5000;
/*      */   public static final int DEFAULT_TIMEOUT_PERIOD = 60000;
/*      */   public static final String BLOCKING_MODE = "blockingMode";
/*      */   public static final String BLOCKING_TIMEOUT = "blockingTimeout";
/*      */   public static final String BLOCKING = "blocking";
/*      */   public static final String NONBLOCKING = "nonblocking";
/*      */   public static final int DEFAULT_BLOCKING_TIMEOUT = 5000;
/*  211 */   private static boolean trace = log.isTraceEnabled();
/*      */ 
/*  218 */   private int maxNumberThreads = 100;
/*  219 */   private int maxOnewayThreadPoolQueueSize = -1;
/*  220 */   private String onewayThreadPoolClass = null;
/*      */   private ThreadPool onewayThreadPool;
/*  222 */   private Object onewayThreadPoolLock = new Object();
/*  223 */   private boolean created = false;
/*      */ 
/*  225 */   private MBeanServer mbeanServer = null;
/*      */   private String dataType;
/*  228 */   private String serverBindAddress = null;
/*  229 */   private int serverBindPort = 0;
/*  230 */   private String clientConnectAddress = null;
/*  231 */   private int clientConnectPort = -1;
/*  232 */   private int timeout = 60000;
/*      */ 
/*  235 */   private long leasePeriod = 5000L;
/*  236 */   private boolean leaseManagement = false;
/*  237 */   private Map clientLeases = new ConcurrentHashMap();
/*      */ 
/*  239 */   protected Map handlers = new HashMap();
/*      */   protected volatile ServerInvocationHandler singleHandler;
/*      */   protected volatile CallbackContainer singleCallbackContainer;
/*  249 */   protected Map callbackHandlers = new HashMap();
/*  250 */   protected Map clientCallbackListener = new HashMap();
/*  251 */   protected boolean started = false;
/*  252 */   protected ConnectionNotifier connectionNotifier = new ConnectionNotifier();
/*  253 */   protected ServerSocketFactory serverSocketFactory = null;
/*      */ 
/*      */   public ServerInvoker(InvokerLocator locator)
/*      */   {
/*  259 */     super(locator);
/*  260 */     Map params = locator.getParameters();
/*  261 */     if ((this.configuration != null) && (params != null))
/*      */     {
/*  263 */       this.configuration.putAll(locator.getParameters());
/*      */     }
/*      */   }
/*      */ 
/*      */   public ServerInvoker(InvokerLocator locator, Map configuration)
/*      */   {
/*  269 */     super(locator, configuration);
/*      */ 
/*  271 */     if (configuration != null)
/*      */     {
/*  273 */       this.configuration.putAll(configuration);
/*      */     }
/*      */ 
/*  276 */     Map locatorParams = locator.getParameters();
/*  277 */     if (locatorParams != null)
/*      */     {
/*  279 */       this.configuration.putAll(locator.getParameters());
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setServerSocketFactory(ServerSocketFactory serverSocketFactory)
/*      */   {
/*  287 */     this.serverSocketFactory = serverSocketFactory;
/*      */   }
/*      */ 
/*      */   public ServerSocketFactory getServerSocketFactory()
/*      */   {
/*  292 */     return this.serverSocketFactory;
/*      */   }
/*      */ 
/*      */   public void setTimeout(int timeout)
/*      */   {
/*  300 */     this.timeout = timeout;
/*      */   }
/*      */ 
/*      */   public int getTimeout()
/*      */   {
/*  308 */     return this.timeout;
/*      */   }
/*      */ 
/*      */   public boolean isLeaseActivated()
/*      */   {
/*  313 */     return this.leaseManagement;
/*      */   }
/*      */ 
/*      */   public void addConnectionListener(ConnectionListener listener)
/*      */   {
/*  318 */     if (listener != null)
/*      */     {
/*  320 */       this.connectionNotifier.addListener(listener);
/*      */ 
/*  322 */       if (this.leasePeriod > 0L)
/*      */       {
/*  324 */         this.leaseManagement = true;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  329 */       throw new IllegalArgumentException("Can not add null ConnectionListener.");
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeConnectionListener(ConnectionListener listener)
/*      */   {
/*  335 */     if (this.connectionNotifier != null)
/*      */     {
/*  337 */       this.connectionNotifier.removeListener(listener);
/*      */ 
/*  340 */       if (this.connectionNotifier.size() == 0)
/*      */       {
/*  342 */         this.leaseManagement = false;
/*      */ 
/*  345 */         Set clientKeys = this.clientLeases.keySet();
/*  346 */         Iterator itr = clientKeys.iterator();
/*  347 */         while (itr.hasNext())
/*      */         {
/*  349 */           String sessionId = (String)itr.next();
/*  350 */           Lease clientLease = (Lease)this.clientLeases.get(sessionId);
/*  351 */           clientLease.terminateLease(sessionId);
/*      */         }
/*  353 */         this.clientLeases.clear();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setLeasePeriod(long leasePeriodValue)
/*      */   {
/*  367 */     this.leasePeriod = leasePeriodValue;
/*      */ 
/*  369 */     if (this.leasePeriod <= 0L)
/*      */     {
/*  371 */       this.leaseManagement = false;
/*      */     }
/*  375 */     else if ((this.connectionNotifier != null) && (this.connectionNotifier.size() > 0))
/*      */     {
/*  377 */       this.leaseManagement = true;
/*      */     }
/*      */   }
/*      */ 
/*      */   public long getLeasePeriod()
/*      */   {
/*  387 */     return this.leasePeriod;
/*      */   }
/*      */ 
/*      */   public String getClientConnectAddress()
/*      */   {
/*  395 */     return this.clientConnectAddress;
/*      */   }
/*      */ 
/*      */   public int getClientConnectPort()
/*      */   {
/*  400 */     return this.clientConnectPort;
/*      */   }
/*      */ 
/*      */   public void setClientConnectPort(int clientConnectPort)
/*      */   {
/*  405 */     this.clientConnectPort = clientConnectPort;
/*      */   }
/*      */ 
/*      */   public void setClientConnectAddress(String clientConnectAddress)
/*      */   {
/*  419 */     this.clientConnectAddress = clientConnectAddress;
/*      */   }
/*      */ 
/*      */   public String getServerBindAddress()
/*      */   {
/*  424 */     return this.serverBindAddress;
/*      */   }
/*      */ 
/*      */   public int getServerBindPort()
/*      */   {
/*  429 */     return this.serverBindPort;
/*      */   }
/*      */ 
/*      */   public void setMaxNumberOfOnewayThreads(int numOfThreads)
/*      */   {
/*  440 */     this.maxNumberThreads = numOfThreads;
/*      */   }
/*      */ 
/*      */   public int getMaxNumberOfOnewayThreads()
/*      */   {
/*  449 */     return this.maxNumberThreads;
/*      */   }
/*      */ 
/*      */   public ThreadPool getOnewayThreadPool()
/*      */   {
/*  457 */     synchronized (this.onewayThreadPoolLock)
/*      */     {
/*  459 */       if (this.onewayThreadPool == null)
/*      */       {
/*  462 */         if ((this.onewayThreadPoolClass == null) || (this.onewayThreadPoolClass.length() == 0))
/*      */         {
/*  464 */           BasicThreadPool pool = new BasicThreadPool("JBossRemoting Server Oneway");
/*  465 */           pool.setMaximumPoolSize(this.maxNumberThreads);
/*  466 */           if (this.maxOnewayThreadPoolQueueSize > 0)
/*  467 */             pool.setMaximumQueueSize(this.maxOnewayThreadPoolQueueSize);
/*  468 */           pool.setBlockingMode(BlockingMode.RUN);
/*  469 */           this.onewayThreadPool = pool;
/*  470 */           log.debug(this + " created new thread pool");
/*      */         }
/*      */         else
/*      */         {
/*  475 */           boolean isObjName = false;
/*      */           try
/*      */           {
/*  478 */             ObjectName objName = new ObjectName(this.onewayThreadPoolClass);
/*  479 */             this.onewayThreadPool = createThreadPoolProxy(objName);
/*  480 */             isObjName = true;
/*      */           }
/*      */           catch (MalformedObjectNameException e)
/*      */           {
/*  484 */             log.debug("Thread pool class supplied is not an object name.");
/*      */           }
/*      */ 
/*  487 */           if (!isObjName)
/*      */           {
/*      */             try
/*      */             {
/*  491 */               this.onewayThreadPool = ((ThreadPool)Class.forName(this.onewayThreadPoolClass, false, getClassLoader()).newInstance());
/*      */             }
/*      */             catch (Exception e)
/*      */             {
/*  496 */               throw new RuntimeException("Error loading instance of ThreadPool based on class name " + this.onewayThreadPoolClass);
/*      */             }
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*  504 */         log.trace("reusing oneway thread pool");
/*      */       }
/*  506 */       return this.onewayThreadPool;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setOnewayThreadPool(ThreadPool pool)
/*      */   {
/*  515 */     this.onewayThreadPool = pool;
/*      */   }
/*      */ 
/*      */   public MBeanServer getMBeanServer()
/*      */   {
/*  520 */     return this.mbeanServer;
/*      */   }
/*      */ 
/*      */   public void setMBeanServer(MBeanServer server)
/*      */   {
/*  531 */     this.mbeanServer = server;
/*      */   }
/*      */ 
/*      */   public synchronized boolean hasInvocationHandler(String subsystem)
/*      */   {
/*  539 */     return this.handlers.containsKey(subsystem);
/*      */   }
/*      */ 
/*      */   public synchronized String[] getSupportedSubsystems()
/*      */   {
/*  547 */     String[] subsystems = new String[this.handlers.size()];
/*  548 */     return (String[])this.handlers.keySet().toArray(subsystems);
/*      */   }
/*      */ 
/*      */   public synchronized ServerInvocationHandler[] getInvocationHandlers()
/*      */   {
/*  556 */     ServerInvocationHandler[] ih = new ServerInvocationHandler[this.handlers.size()];
/*  557 */     return (ServerInvocationHandler[])this.handlers.values().toArray(ih);
/*      */   }
/*      */ 
/*      */   public synchronized ServerInvocationHandler addInvocationHandler(String subsystem, ServerInvocationHandler handler)
/*      */   {
/*  570 */     handler.setInvoker(this);
/*      */ 
/*  572 */     ServerInvocationHandler oldHandler = (ServerInvocationHandler)this.handlers.put(subsystem.toUpperCase(), handler);
/*      */ 
/*  575 */     log.debug(this + " added " + handler + " for subsystem '" + subsystem + "'" + (oldHandler == null ? "" : new StringBuffer().append(", replacing old handler ").append(oldHandler).toString()));
/*      */ 
/*  578 */     if (this.handlers.size() == 1)
/*      */     {
/*  580 */       this.singleHandler = handler;
/*      */     }
/*      */     else
/*      */     {
/*  584 */       this.singleHandler = null;
/*      */     }
/*      */ 
/*  587 */     return oldHandler;
/*      */   }
/*      */ 
/*      */   public synchronized ServerInvocationHandler removeInvocationHandler(String subsystem)
/*      */   {
/*  595 */     ServerInvocationHandler handler = (ServerInvocationHandler)this.handlers.remove(subsystem.toUpperCase());
/*      */ 
/*  598 */     log.debug(this + (handler == null ? " tried to remove handler for " + subsystem + " but no handler found" : new StringBuffer().append(" removed handler ").append(handler).append(" for subsystem '").append(subsystem).append("'").toString()));
/*      */ 
/*  602 */     if (this.handlers.size() == 1)
/*      */     {
/*  604 */       this.singleHandler = ((ServerInvocationHandler)this.handlers.values().iterator().next());
/*      */     }
/*      */     else
/*      */     {
/*  608 */       this.singleHandler = null;
/*      */     }
/*      */ 
/*  611 */     return handler;
/*      */   }
/*      */ 
/*      */   public synchronized ServerInvocationHandler getInvocationHandler(String subsystem)
/*      */   {
/*  619 */     return (ServerInvocationHandler)this.handlers.get(subsystem.toUpperCase());
/*      */   }
/*      */ 
/*      */   public Object invoke(Object invoke) throws IOException
/*      */   {
/*  624 */     InvocationRequest request = null;
/*  625 */     InvocationResponse response = null;
/*      */ 
/*  627 */     if (trace) log.trace("server received invocation " + invoke);
/*      */ 
/*  629 */     if ((invoke != null) && ((invoke instanceof InvocationRequest)))
/*      */     {
/*  631 */       request = (InvocationRequest)invoke;
/*      */       try
/*      */       {
/*  635 */         Object result = invoke(request);
/*      */ 
/*  637 */         response = new InvocationResponse(request.getSessionId(), result, false, request.getReturnPayload());
/*      */       }
/*      */       catch (Throwable throwable)
/*      */       {
/*  643 */         response = new InvocationResponse(request.getSessionId(), throwable, true, request.getReturnPayload());
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  649 */       log.error("server invoker received " + invoke + " as invocation. " + "Must not be null and must be of type InvocationRequest.");
/*      */ 
/*  652 */       Exception e = new Exception("Error processing invocation request on " + getLocator() + ". Either invocation was null or of wrong type.");
/*      */ 
/*  655 */       response = new InvocationResponse(request.getSessionId(), e, true, request.getReturnPayload());
/*      */     }
/*      */ 
/*  658 */     return response;
/*      */   }
/*      */ 
/*      */   public Object invoke(InvocationRequest invocation)
/*      */     throws Throwable
/*      */   {
/*  668 */     if (isStarted())
/*      */     {
/*  670 */       Object param = invocation.getParameter();
/*  671 */       Object result = null;
/*      */ 
/*  673 */       if (trace) log.trace(this + " received " + param);
/*      */ 
/*  676 */       if ("$PING$".equals(param))
/*      */       {
/*  679 */         if (this.leaseManagement)
/*      */         {
/*  683 */           updateClientLease(invocation);
/*      */         }
/*      */ 
/*  687 */         Map responseMap = new HashMap();
/*  688 */         responseMap.put("clientLeasePeriod", new Long(this.leasePeriod));
/*      */ 
/*  690 */         InvocationResponse ir = new InvocationResponse(invocation.getSessionId(), new Boolean(this.leaseManagement), false, responseMap);
/*      */ 
/*  694 */         if (trace) log.trace(this + " returning " + ir);
/*  695 */         return ir;
/*      */       }
/*      */ 
/*  698 */       if ("$GET_CLIENT_LOCAL_ADDRESS$".equals(param))
/*      */       {
/*  701 */         return new InvocationResponse(invocation.getSessionId(), null, false, null);
/*      */       }
/*      */ 
/*  704 */       if ("$DISCONNECT$".equals(param))
/*      */       {
/*  706 */         if (this.leaseManagement)
/*      */         {
/*  708 */           terminateLease(invocation);
/*      */         }
/*      */ 
/*  711 */         if (trace) log.trace(this + " returning null");
/*  712 */         return null;
/*      */       }
/*      */ 
/*  717 */       if ((param instanceof OnewayInvocation))
/*      */       {
/*  720 */         handleOnewayInvocation((OnewayInvocation)param, invocation);
/*      */ 
/*  722 */         return null;
/*      */       }
/*      */ 
/*  726 */       String subsystem = invocation.getSubsystem();
/*  727 */       String clientId = invocation.getSessionId();
/*      */ 
/*  733 */       ServerInvocationHandler handler = null;
/*      */ 
/*  735 */       if (this.singleHandler != null)
/*      */       {
/*  737 */         handler = this.singleHandler;
/*      */       }
/*  741 */       else if (subsystem != null)
/*      */       {
/*  743 */         handler = (ServerInvocationHandler)this.handlers.get(subsystem.toUpperCase());
/*      */       }
/*  748 */       else if (!this.handlers.isEmpty())
/*      */       {
/*  750 */         if (trace) log.trace(this + " handling invocation with no subsystem explicitely specified, using the default handler");
/*  751 */         handler = (ServerInvocationHandler)this.handlers.values().iterator().next();
/*      */       }
/*      */ 
/*  756 */       if ((param instanceof InternalInvocation))
/*      */       {
/*  758 */         result = handleInternalInvocation((InternalInvocation)param, invocation, handler);
/*      */       }
/*      */       else
/*      */       {
/*  762 */         if (trace) log.trace(this + " dispatching " + invocation + " from client " + clientId + " to subsystem '" + subsystem + "'");
/*      */ 
/*  764 */         if (handler == null)
/*      */         {
/*  766 */           throw new InvalidConfigurationException("Can not handle invocation request for subsystem '" + subsystem + "' because " + "there are no matching ServerInvocationHandlers registered. Please add via " + "xml configuration or via the Connector's addInvocationHandler() method.");
/*      */         }
/*      */ 
/*  771 */         result = handler.invoke(invocation);
/*      */       }
/*      */ 
/*  774 */       if (trace) log.trace(this + " successfully dispatched invocation, returning " + result + " from subsystem '" + subsystem + "' to client " + clientId);
/*      */ 
/*  777 */       return result;
/*      */     }
/*      */ 
/*  781 */     log.warn(this + " can not process invocation requests since is not in started state!");
/*  782 */     throw new InvalidStateException("Can not process invocation request since is not in started state.");
/*      */   }
/*      */ 
/*      */   public String getDataType()
/*      */   {
/*  795 */     if (this.dataType == null)
/*      */     {
/*  797 */       this.dataType = getDataType(getLocator());
/*  798 */       if (this.dataType == null)
/*      */       {
/*  800 */         this.dataType = getDefaultDataType();
/*      */       }
/*      */     }
/*  803 */     return this.dataType;
/*      */   }
/*      */ 
/*      */   public void create()
/*      */   {
/*  808 */     if (!this.created)
/*      */     {
/*      */       try
/*      */       {
/*  812 */         setup();
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  816 */         throw new RuntimeException("Error setting up server invoker " + this, e);
/*      */       }
/*  818 */       this.created = true;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void start()
/*      */     throws IOException
/*      */   {
/*  827 */     this.started = true;
/*  828 */     log.debug(this + " started for locator " + getLocator());
/*      */   }
/*      */ 
/*      */   public boolean isStarted()
/*      */   {
/*  836 */     return this.started;
/*      */   }
/*      */ 
/*      */   public void stop()
/*      */   {
/*  844 */     this.started = false;
/*      */ 
/*  846 */     for (Iterator i = this.callbackHandlers.values().iterator(); i.hasNext(); )
/*      */     {
/*  848 */       ServerInvokerCallbackHandler callbackHandler = (ServerInvokerCallbackHandler)i.next();
/*  849 */       callbackHandler.destroy();
/*      */     }
/*      */ 
/*  852 */     log.debug(this + " stopped");
/*      */   }
/*      */ 
/*      */   public void destroy()
/*      */   {
/*  860 */     if (this.classbyteloader != null)
/*      */     {
/*  862 */       this.classbyteloader.destroy();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setConfiguration(Map configuration)
/*      */   {
/*  872 */     this.configuration = configuration;
/*      */   }
/*      */ 
/*      */   public Map getConfiguration()
/*      */   {
/*  880 */     return this.configuration;
/*      */   }
/*      */ 
/*      */   public void removeCallbackListener(String subsystem, InvokerCallbackHandler callbackHandler)
/*      */   {
/*  885 */     ServerInvocationHandler handler = null;
/*  886 */     if (subsystem != null)
/*      */     {
/*  888 */       handler = (ServerInvocationHandler)this.handlers.get(subsystem.toUpperCase());
/*      */     }
/*  893 */     else if (!this.handlers.isEmpty())
/*      */     {
/*  895 */       handler = (ServerInvocationHandler)this.handlers.values().iterator().next();
/*      */     }
/*      */ 
/*  898 */     handler.removeListener(callbackHandler);
/*      */   }
/*      */ 
/*      */   public String getMBeanObjectName()
/*      */   {
/*  906 */     InvokerLocator locator = getLocator();
/*  907 */     StringBuffer buffer = new StringBuffer("jboss.remoting:service=invoker,transport= " + locator.getProtocol());
/*      */ 
/*  909 */     String host = locator.getHost();
/*  910 */     boolean isIPv6 = (host.indexOf("[") >= 0 ? 1 : 0) | (host.indexOf(":") >= 0 ? 1 : 0);
/*      */ 
/*  912 */     buffer.append(",host=");
/*  913 */     if (isIPv6)
/*  914 */       buffer.append("\"");
/*  915 */     buffer.append(locator.getHost());
/*  916 */     if (isIPv6) {
/*  917 */       buffer.append("\"");
/*      */     }
/*  919 */     buffer.append(",port=").append(locator.getPort());
/*  920 */     Map param = locator.getParameters();
/*  921 */     if (param != null)
/*      */     {
/*  923 */       Iterator itr = param.keySet().iterator();
/*  924 */       while (itr.hasNext())
/*      */       {
/*  926 */         buffer.append(",");
/*  927 */         String key = (String)itr.next();
/*  928 */         String value = (String)param.get(key);
/*  929 */         buffer.append(key);
/*  930 */         buffer.append("=");
/*  931 */         buffer.append(value);
/*      */       }
/*      */     }
/*  934 */     return buffer.toString();
/*      */   }
/*      */ 
/*      */   protected abstract String getDefaultDataType();
/*      */ 
/*      */   protected void setup()
/*      */     throws Exception
/*      */   {
/*  945 */     Map config = getConfiguration();
/*  946 */     String maxNumOfThreads = (String)config.get("maxNumThreadsOneway");
/*      */ 
/*  948 */     if ((maxNumOfThreads != null) && (maxNumOfThreads.length() > 0))
/*      */     {
/*      */       try
/*      */       {
/*  952 */         this.maxNumberThreads = Integer.parseInt(maxNumOfThreads);
/*      */       }
/*      */       catch (NumberFormatException e)
/*      */       {
/*  956 */         log.error("Can not convert max number of threads value (" + maxNumOfThreads + ") into a number.");
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  961 */     String param = (String)this.configuration.get("maxOnewayThreadPoolQueueSize");
/*      */ 
/*  963 */     if ((param != null) && (param.length() > 0))
/*      */     {
/*      */       try
/*      */       {
/*  967 */         this.maxOnewayThreadPoolQueueSize = Integer.parseInt(param);
/*      */       }
/*      */       catch (NumberFormatException e)
/*      */       {
/*  971 */         log.error("maxOnewayThreadPoolQueueSize parameter has invalid format: " + param);
/*      */       }
/*      */     }
/*      */ 
/*  975 */     this.onewayThreadPoolClass = ((String)config.get("onewayThreadPool"));
/*      */ 
/*  977 */     String locatorHost = this.locator.getHost();
/*  978 */     InetAddress addr = null;
/*  979 */     if (locatorHost != null)
/*      */     {
/*  981 */       addr = InetAddress.getByName(this.locator.getHost());
/*      */     }
/*      */     else
/*      */     {
/*  985 */       addr = InetAddress.getLocalHost();
/*      */     }
/*  987 */     int port = this.locator.getPort();
/*  988 */     if (port <= 0)
/*      */     {
/*  990 */       port = assignPort();
/*      */     }
/*      */ 
/*  994 */     this.serverBindAddress = ((String)config.get("serverBindAddress"));
/*  995 */     this.clientConnectAddress = ((String)config.get("clientConnectAddress"));
/*  996 */     if (this.serverBindAddress == null)
/*      */     {
/*  998 */       if (this.clientConnectAddress != null)
/*      */       {
/* 1001 */         this.serverBindAddress = InetAddress.getLocalHost().getHostAddress();
/*      */       }
/*      */       else
/*      */       {
/* 1005 */         this.serverBindAddress = addr.getHostAddress();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1010 */     String serverBindPortString = (String)config.get("serverBindPort");
/* 1011 */     String clientConnectPortString = (String)config.get("clientConnectPort");
/* 1012 */     if (clientConnectPortString != null)
/*      */     {
/*      */       try
/*      */       {
/* 1016 */         this.clientConnectPort = Integer.parseInt(clientConnectPortString);
/*      */       }
/*      */       catch (NumberFormatException e)
/*      */       {
/* 1020 */         throw new InvalidConfigurationException("Can not set client bind port because can not convert given value (" + clientConnectPortString + ") to a number.");
/*      */       }
/*      */     }
/*      */ 
/* 1024 */     if (serverBindPortString != null)
/*      */     {
/*      */       try
/*      */       {
/* 1028 */         this.serverBindPort = Integer.parseInt(serverBindPortString);
/* 1029 */         if (this.serverBindPort <= 0)
/*      */         {
/* 1031 */           this.serverBindPort = assignPort();
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (NumberFormatException e)
/*      */       {
/* 1037 */         throw new InvalidConfigurationException("Can not set server bind port because can not convert given value (" + serverBindPortString + ") to a number.");
/*      */       }
/*      */ 
/*      */     }
/* 1043 */     else if (this.clientConnectPort > 0)
/*      */     {
/* 1046 */       this.serverBindPort = PortUtil.findFreePort(this.locator.getHost());
/*      */     }
/*      */     else
/*      */     {
/* 1050 */       this.serverBindPort = port;
/*      */     }
/*      */ 
/* 1055 */     String timeoutPeriod = (String)config.get("timeout");
/* 1056 */     if ((timeoutPeriod != null) && (timeoutPeriod.length() > 0))
/*      */     {
/*      */       try
/*      */       {
/* 1060 */         this.timeout = Integer.parseInt(timeoutPeriod);
/*      */       }
/*      */       catch (NumberFormatException e)
/*      */       {
/* 1064 */         throw new InvalidConfigurationException("Can not set timeout because can not convert give value (" + timeoutPeriod + ") to a number.");
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1070 */     String clientLeasePeriod = (String)config.get("clientLeasePeriod");
/* 1071 */     if (clientLeasePeriod != null)
/*      */     {
/*      */       try
/*      */       {
/* 1075 */         long leasePeriodValue = Long.parseLong(clientLeasePeriod);
/* 1076 */         setLeasePeriod(leasePeriodValue);
/*      */       }
/*      */       catch (NumberFormatException e)
/*      */       {
/* 1080 */         throw new InvalidConfigurationException("Can not set client lease period because can not convert given value (" + clientLeasePeriod + ") to a number.");
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1085 */     createServerSocketFactory();
/*      */ 
/* 1088 */     this.locator = validateLocator(this.locator);
/*      */   }
/*      */ 
/*      */   private InvokerLocator validateLocator(InvokerLocator locator)
/*      */     throws MalformedURLException
/*      */   {
/* 1098 */     InvokerLocator externalLocator = locator;
/*      */ 
/* 1100 */     String host = locator.getHost();
/* 1101 */     String newHost = null;
/* 1102 */     if ((host == null) || ("0.0.0.0".equals(host)))
/*      */     {
/* 1105 */       boolean byHost = true;
/* 1106 */       String bindByHost = System.getProperty("remoting.bind_by_host", "True");
/*      */       try
/*      */       {
/* 1109 */         byHost = Boolean.valueOf(bindByHost).booleanValue();
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */       }
/*      */       try
/*      */       {
/* 1116 */         if (byHost)
/*      */         {
/* 1118 */           newHost = InetAddress.getLocalHost().getHostName();
/*      */         }
/*      */         else
/*      */         {
/* 1122 */           newHost = InetAddress.getLocalHost().getHostAddress();
/*      */         }
/*      */       }
/*      */       catch (UnknownHostException e)
/*      */       {
/* 1127 */         log.debug("Could not get host by name or address.", e);
/*      */       }
/* 1129 */       if (newHost == null)
/*      */       {
/* 1132 */         throw new RuntimeException("Can not determine bindable address for locator (" + locator + ")");
/*      */       }
/*      */ 
/* 1136 */       externalLocator = new InvokerLocator(locator.protocol, newHost, locator.getPort(), locator.getPath(), locator.getParameters());
/*      */ 
/* 1143 */       InvokerRegistry.updateServerInvokerLocator(locator, externalLocator);
/*      */     }
/*      */ 
/* 1146 */     return externalLocator;
/*      */   }
/*      */ 
/*      */   protected int assignPort()
/*      */     throws IOException
/*      */   {
/* 1152 */     int port = PortUtil.findFreePort(this.locator.getHost());
/*      */ 
/* 1155 */     InvokerLocator newLocator = new InvokerLocator(this.locator.getProtocol(), this.locator.getHost(), port, this.locator.getPath(), this.locator.getParameters());
/*      */ 
/* 1159 */     InvokerRegistry.updateServerInvokerLocator(this.locator, newLocator);
/* 1160 */     this.locator = newLocator;
/* 1161 */     return port;
/*      */   }
/*      */ 
/*      */   protected ServerSocketFactory createServerSocketFactory()
/*      */     throws IOException
/*      */   {
/* 1167 */     if (this.serverSocketFactory == null)
/*      */     {
/* 1169 */       Object obj = this.configuration.get("customServerSocketFactory");
/* 1170 */       if (obj != null)
/*      */       {
/* 1172 */         if ((obj instanceof ServerSocketFactory))
/*      */         {
/* 1174 */           this.serverSocketFactory = ((ServerSocketFactory)obj);
/*      */         }
/*      */         else
/*      */         {
/* 1178 */           throw new RuntimeException("Can not set custom server socket factory (" + obj + ") as is not of type javax.net.SocketFactory");
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1183 */       if (this.serverSocketFactory == null)
/*      */       {
/* 1192 */         String serverSocketFactoryString = (String)this.configuration.get("serverSocketFactory");
/* 1193 */         if ((serverSocketFactoryString != null) && (serverSocketFactoryString.length() > 0))
/*      */         {
/*      */           try
/*      */           {
/* 1197 */             if (serverSocketFactoryString != null)
/*      */             {
/* 1199 */               MBeanServer server = getMBeanServer();
/* 1200 */               ObjectName serverSocketFactoryObjName = new ObjectName(serverSocketFactoryString);
/*      */ 
/* 1203 */               if (server != null)
/*      */               {
/*      */                 try
/*      */                 {
/* 1207 */                   ServerSocketFactoryMBean serverSocketFactoryMBean = (ServerSocketFactoryMBean)MBeanServerInvocationHandler.newProxyInstance(server, serverSocketFactoryObjName, ServerSocketFactoryMBean.class, false);
/*      */ 
/* 1211 */                   this.serverSocketFactory = new ServerSocketFactoryWrapper(serverSocketFactoryMBean);
/*      */                 }
/*      */                 catch (Exception e)
/*      */                 {
/* 1216 */                   log.debug("Error creating mbean proxy for server socket factory for object name " + serverSocketFactoryObjName + ". " + "Will try by class name.");
/*      */                 }
/*      */ 
/*      */               }
/*      */               else
/*      */               {
/* 1223 */                 log.debug("The 'serverSocketFactory' attribute was set with a value, but the MBeanServer reference is null.");
/*      */               }
/*      */             }
/*      */ 
/*      */           }
/*      */           catch (MalformedObjectNameException e)
/*      */           {
/* 1230 */             log.debug("Attibute value (" + serverSocketFactoryString + ") passed is not a " + "valid ObjectName. Can not look up if is a mbean service. Will try by classname.");
/*      */           }
/*      */           catch (NullPointerException e)
/*      */           {
/* 1235 */             log.debug("Could not set up the server socket factory as a mbean service due to null pointer exception.");
/*      */           }
/*      */ 
/* 1240 */           if (this.serverSocketFactory == null)
/*      */           {
/*      */             try
/*      */             {
/* 1244 */               Class cl = ClassLoaderUtility.loadClass(serverSocketFactoryString, getClass());
/*      */ 
/* 1246 */               Constructor serverSocketConstructor = null;
/* 1247 */               serverSocketConstructor = cl.getConstructor(new Class[0]);
/* 1248 */               this.serverSocketFactory = ((ServerSocketFactory)serverSocketConstructor.newInstance(new Object[0]));
/*      */ 
/* 1250 */               log.trace("ServerSocketFactory (" + serverSocketFactoryString + ") loaded");
/*      */             }
/*      */             catch (Exception e)
/*      */             {
/* 1254 */               log.debug("Could not create server socket factory by classname (" + serverSocketFactoryString + ").  Error message: " + e.getMessage());
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1262 */     if ((this.serverSocketFactory == null) && (needsCustomSSLConfiguration(this.configuration)))
/*      */     {
/*      */       try
/*      */       {
/* 1266 */         SSLSocketBuilder socketBuilder = new SSLSocketBuilder(this.configuration);
/* 1267 */         socketBuilder.setUseSSLServerSocketFactory(false);
/* 1268 */         this.serverSocketFactory = socketBuilder.createSSLServerSocketFactory();
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/* 1272 */         throw new RuntimeException("Unable to create customized SSL socket factory", e);
/*      */       }
/*      */     }
/*      */ 
/* 1276 */     if (this.serverSocketFactory == null)
/*      */     {
/* 1278 */       log.debug(this + " did not find server socket factory configuration as mbean service " + "or classname. Creating default server socket factory.");
/*      */ 
/* 1281 */       this.serverSocketFactory = getDefaultServerSocketFactory();
/*      */     }
/*      */ 
/* 1284 */     log.debug(this + " created server socket factory " + this.serverSocketFactory);
/*      */ 
/* 1286 */     this.serverSocketFactory = wrapServerSocketFactory(this.serverSocketFactory, this.configuration);
/* 1287 */     return this.serverSocketFactory;
/*      */   }
/*      */ 
/*      */   protected boolean justNeedsSSLClientMode(Map configuration)
/*      */   {
/* 1293 */     if ((configuration.size() == 1) && (configuration.containsKey("org.jboss.remoting.serversocket.useClientMode")))
/*      */     {
/* 1296 */       String useClientModeString = (String)configuration.get("org.jboss.remoting.serversocket.useClientMode");
/*      */ 
/* 1298 */       return Boolean.valueOf(useClientModeString).booleanValue();
/*      */     }
/*      */ 
/* 1301 */     if ((configuration.size() == 1) && (configuration.containsKey("org.jboss.remoting.socket.useClientMode")))
/*      */     {
/* 1304 */       String useClientModeString = (String)configuration.get("org.jboss.remoting.socket.useClientMode");
/*      */ 
/* 1306 */       return Boolean.valueOf(useClientModeString).booleanValue();
/*      */     }
/*      */ 
/* 1309 */     if ((configuration.size() == 2) && (configuration.containsKey("org.jboss.remoting.serversocket.useClientMode")) && (configuration.containsKey("org.jboss.remoting.socket.useClientMode")))
/*      */     {
/* 1313 */       String useClientModeString = (String)configuration.get("org.jboss.remoting.serversocket.useClientMode");
/*      */ 
/* 1315 */       return Boolean.valueOf(useClientModeString).booleanValue();
/*      */     }
/*      */ 
/* 1318 */     return false;
/*      */   }
/*      */ 
/*      */   protected ServerSocketFactory getDefaultServerSocketFactory()
/*      */     throws IOException
/*      */   {
/* 1327 */     return ServerSocketFactory.getDefault();
/*      */   }
/*      */ 
/*      */   protected ServerSocketFactory wrapServerSocketFactory(ServerSocketFactory ssf, Map config)
/*      */   {
/* 1332 */     if (config == null)
/*      */     {
/* 1334 */       return ssf;
/*      */     }
/*      */ 
/* 1337 */     Object o = config.get("socketCreationServerListener");
/*      */ 
/* 1339 */     if (o == null)
/*      */     {
/* 1341 */       return ssf;
/*      */     }
/*      */ 
/* 1344 */     if ((o instanceof SocketCreationListener))
/*      */     {
/* 1346 */       return new CreationListenerServerSocketFactory(ssf, (SocketCreationListener)o);
/*      */     }
/* 1348 */     if ((o instanceof String))
/*      */     {
/*      */       try
/*      */       {
/* 1352 */         Class c = ClassLoaderUtility.loadClass((String)o, ServerInvoker.class);
/* 1353 */         SocketCreationListener listener = (SocketCreationListener)c.newInstance();
/* 1354 */         return new CreationListenerServerSocketFactory(ssf, listener);
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/* 1358 */         log.error("unable to instantiate class: " + o, e);
/* 1359 */         return ssf;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1364 */     log.error("unrecognized type for socket creation server listener: " + o);
/* 1365 */     return ssf;
/*      */   }
/*      */ 
/*      */   protected Object handleInternalInvocation(InternalInvocation param, InvocationRequest invocation, ServerInvocationHandler handler)
/*      */     throws Throwable
/*      */   {
/* 1377 */     Object result = null;
/* 1378 */     String methodName = param.getMethodName();
/*      */ 
/* 1380 */     if (trace) log.trace("handling InternalInvocation where method name = " + methodName);
/*      */ 
/* 1383 */     if ("handleCallback".equals(methodName))
/*      */     {
/* 1385 */       String sessionId = ServerInvokerCallbackHandler.getId(invocation);
/* 1386 */       if (trace) log.trace("ServerInvoker (" + this + ") is being asked to deliver callback on client callback handler with session id of " + sessionId + ".");
/*      */ 
/* 1388 */       CallbackContainer callbackContainer = null;
/*      */ 
/* 1390 */       if (this.singleCallbackContainer != null)
/*      */       {
/* 1392 */         callbackContainer = this.singleCallbackContainer;
/*      */       }
/*      */       else
/*      */       {
/* 1396 */         callbackContainer = (CallbackContainer)this.clientCallbackListener.get(sessionId);
/*      */       }
/*      */ 
/* 1399 */       if ((callbackContainer != null) && (callbackContainer.getCallbackHandler() != null))
/*      */       {
/* 1401 */         Object[] params = param.getParameters();
/*      */ 
/* 1403 */         Callback callbackRequest = (Callback)params[0];
/*      */ 
/* 1405 */         Object obj = callbackContainer.getCallbackHandleObject();
/*      */ 
/* 1407 */         if (obj != null)
/*      */         {
/* 1409 */           Map callbackHandleObject = callbackRequest.getReturnPayload();
/*      */ 
/* 1411 */           if (callbackHandleObject == null)
/*      */           {
/* 1413 */             callbackHandleObject = new HashMap();
/*      */           }
/*      */ 
/* 1417 */           callbackHandleObject.put("callback_handle_object", obj);
/*      */ 
/* 1420 */           callbackRequest.setReturnPayload(callbackHandleObject);
/*      */         }
/*      */ 
/* 1423 */         InvokerCallbackHandler callbackHandler = callbackContainer.getCallbackHandler();
/*      */ 
/* 1425 */         callbackHandler.handleCallback(callbackRequest);
/*      */       }
/*      */       else
/*      */       {
/* 1429 */         log.error("Could not find callback handler to call upon for handleCallback where session id equals " + sessionId);
/*      */       }
/*      */ 
/*      */     }
/* 1433 */     else if ("addListener".equals(methodName))
/*      */     {
/* 1435 */       if (handler == null)
/*      */       {
/* 1437 */         throw new InvalidConfigurationException("Can not accept a callback listener since there are no ServerInvocationHandlers registered. Please add via xml configuration or via the Connector's addInvocationHandler() method.");
/*      */       }
/*      */ 
/* 1443 */       InvokerCallbackHandler callbackHandler = getCallbackHandler(invocation);
/* 1444 */       handler.addListener(callbackHandler);
/*      */     }
/* 1446 */     else if ("removeListener".equals(methodName))
/*      */     {
/* 1448 */       ServerInvokerCallbackHandler callbackHandler = removeCallbackHandler(invocation);
/* 1449 */       if (callbackHandler != null)
/*      */       {
/* 1451 */         if (handler == null)
/*      */         {
/* 1453 */           throw new InvalidConfigurationException("Can not remove a callback listener since there are no ServerInvocationHandlers registered.  Please add via xml configuration or via the Connector's addInvocationHandler() method.");
/*      */         }
/*      */ 
/* 1458 */         handler.removeListener(callbackHandler);
/*      */ 
/* 1460 */         if (trace) log.trace("ServerInvoker (" + this + ") removing server callback handler " + callbackHandler + ".");
/*      */ 
/* 1462 */         callbackHandler.destroy();
/*      */       }
/*      */       else
/*      */       {
/* 1466 */         String sessionId = ServerInvokerCallbackHandler.getId(invocation);
/* 1467 */         throw new RuntimeException("Can not remove callback listener from target server with id of " + sessionId + " as it does not exist as a registered callback listener.");
/*      */       }
/*      */ 
/*      */     }
/* 1471 */     else if ("getCallbacks".equals(methodName))
/*      */     {
/* 1473 */       ServerInvokerCallbackHandler callbackHandler = getCallbackHandler(invocation);
/* 1474 */       if (trace) log.trace("ServerInvoker (" + this + ") getting callbacks for callback handler " + callbackHandler + ".");
/* 1475 */       result = callbackHandler.getCallbacks(invocation.getRequestPayload());
/*      */     }
/* 1477 */     else if ("acknowledgeCallback".equals(methodName))
/*      */     {
/* 1479 */       ServerInvokerCallbackHandler callbackHandler = getCallbackHandler(invocation);
/* 1480 */       if (trace) log.trace("ServerInvoker (" + this + ") acknowledge callback on callback handler " + callbackHandler + ".");
/* 1481 */       callbackHandler.acknowledgeCallbacks(param);
/*      */     }
/* 1483 */     else if ("addClientListener".equals(methodName))
/*      */     {
/* 1485 */       String sessionId = ServerInvokerCallbackHandler.getId(invocation);
/* 1486 */       Object[] params = param.getParameters();
/*      */ 
/* 1489 */       if ((params == null) || (params.length < 0) || (params.length > 3))
/*      */       {
/* 1491 */         log.error("Recieved addClientListener InternalInvocation, but getParameters() returned: " + params);
/*      */ 
/* 1493 */         throw new RuntimeException("InvokerCallbackHandler and callback handle object (optional) must be supplied as the only parameter objects within the InternalInvocation when calling addClientListener.");
/*      */       }
/*      */ 
/* 1499 */       InvokerCallbackHandler callbackHandler = (InvokerCallbackHandler)params[0];
/* 1500 */       Object callbackHandleObject = params[1];
/* 1501 */       CallbackContainer callbackContainer = new CallbackContainer(callbackHandler, callbackHandleObject);
/*      */ 
/* 1504 */       this.clientCallbackListener.put(sessionId, callbackContainer);
/*      */ 
/* 1508 */       if (this.clientCallbackListener.size() == 1)
/*      */       {
/* 1510 */         this.singleCallbackContainer = callbackContainer;
/*      */       }
/*      */       else
/*      */       {
/* 1514 */         this.singleCallbackContainer = null;
/*      */       }
/*      */ 
/* 1517 */       log.debug("ServerInvoker (" + this + ") added client callback handler " + callbackHandler + " with session id of " + sessionId + " and callback handle object of " + callbackHandleObject + ".");
/*      */     }
/* 1522 */     else if ("removeClientListener".equals(methodName))
/*      */     {
/* 1524 */       String sessionId = ServerInvokerCallbackHandler.getId(invocation);
/*      */ 
/* 1526 */       log.debug("ServerInvoker (" + this + ") removing client callback handler with session " + "id of " + sessionId + ".");
/*      */ 
/* 1529 */       Object cbo = this.clientCallbackListener.remove(sessionId);
/* 1530 */       if (cbo == null)
/*      */       {
/* 1532 */         throw new RuntimeException("Can not remove callback listener from callback server with id of " + sessionId + " as it does not exist as a registered callback listener.");
/*      */       }
/*      */ 
/* 1538 */       if (this.clientCallbackListener.size() == 1)
/*      */       {
/* 1540 */         this.singleCallbackContainer = ((CallbackContainer)this.clientCallbackListener.values().iterator().next());
/*      */       }
/*      */       else
/*      */       {
/* 1545 */         this.singleCallbackContainer = null;
/*      */       }
/*      */ 
/*      */     }
/* 1550 */     else if ("addStreamCallback".equals(methodName))
/*      */     {
/* 1552 */       StreamHandler streamHandler = getStreamHandler(invocation);
/* 1553 */       if ((handler instanceof StreamInvocationHandler))
/*      */       {
/* 1555 */         InternalInvocation inv = (InternalInvocation)invocation.getParameter();
/*      */ 
/* 1557 */         result = ((StreamInvocationHandler)handler).handleStream(streamHandler, (InvocationRequest)inv.getParameters()[1]);
/*      */       }
/*      */       else
/*      */       {
/* 1562 */         log.error("Client request is an InputStream, but the registered handlers do not implement the StreamInvocationHandler interface, so could not process call.");
/*      */ 
/* 1564 */         throw new RuntimeException("No handler registered of proper type (StreamInvocationHandler).");
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1570 */       log.error("Error processing InternalInvocation.  Unable to process method " + methodName + ". Please make sure this should be an InternalInvocation.");
/*      */ 
/* 1572 */       throw new RuntimeException("Error processing InternalInvocation. Unable to process method " + methodName);
/*      */     }
/*      */ 
/* 1575 */     return result;
/*      */   }
/*      */ 
/*      */   protected void preProcess(String sessionId, ClassBytes arg, Map payload, InvokerLocator locator)
/*      */   {
/*      */   }
/*      */ 
/*      */   protected void postProcess(String sessionId, Object param, Map payload, InvokerLocator locator)
/*      */   {
/*      */   }
/*      */ 
/*      */   private ThreadPool createThreadPoolProxy(ObjectName objName)
/*      */   {
/* 1599 */     MBeanServer server = getMBeanServer();
/*      */     ThreadPool pool;
/* 1600 */     if (server != null)
/*      */     {
/* 1602 */       ThreadPoolMBean poolMBean = (ThreadPoolMBean)MBeanServerInvocationHandler.newProxyInstance(server, objName, ThreadPoolMBean.class, false);
/*      */ 
/* 1605 */       pool = poolMBean.getInstance();
/*      */     }
/*      */     else
/*      */     {
/* 1609 */       throw new RuntimeException("Can not register MBean ThreadPool as the ServerInvoker has not been registered with a MBeanServer.");
/*      */     }
/*      */     ThreadPool pool;
/* 1612 */     return pool;
/*      */   }
/*      */ 
/*      */   private String getDataType(InvokerLocator locator)
/*      */   {
/* 1618 */     String type = null;
/*      */ 
/* 1620 */     if (locator != null)
/*      */     {
/* 1622 */       Map params = locator.getParameters();
/* 1623 */       if (params != null)
/*      */       {
/* 1625 */         type = (String)params.get("datatype");
/*      */       }
/*      */     }
/* 1628 */     return type;
/*      */   }
/*      */ 
/*      */   private void terminateLease(InvocationRequest invocation)
/*      */   {
/* 1633 */     if (invocation != null)
/*      */     {
/* 1635 */       String clientSessionId = invocation.getSessionId();
/* 1636 */       Lease clientLease = (Lease)this.clientLeases.get(clientSessionId);
/*      */ 
/* 1638 */       if (clientLease != null)
/*      */       {
/* 1640 */         boolean clientOnlyTerminated = false;
/*      */ 
/* 1644 */         Map reqMap = invocation.getRequestPayload();
/* 1645 */         if (reqMap != null)
/*      */         {
/* 1647 */           Object holderObj = reqMap.get("ClientHolderKey");
/* 1648 */           if ((holderObj != null) && ((holderObj instanceof ClientHolder)))
/*      */           {
/* 1652 */             if (trace) log.trace("terminating client lease: " + clientSessionId);
/* 1653 */             ClientHolder holder = (ClientHolder)holderObj;
/* 1654 */             clientLease.terminateLease(holder.getSessionId());
/* 1655 */             clientOnlyTerminated = true;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 1660 */         if (!clientOnlyTerminated)
/*      */         {
/* 1662 */           if (trace) log.trace("terminating invoker lease: " + clientSessionId);
/* 1663 */           clientLease.terminateLease(clientSessionId);
/* 1664 */           this.clientLeases.remove(clientSessionId);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 1669 */         String type = "invoker";
/* 1670 */         Map reqMap = invocation.getRequestPayload();
/* 1671 */         if (reqMap != null)
/*      */         {
/* 1673 */           Object holderObj = reqMap.get("ClientHolderKey");
/* 1674 */           if ((holderObj != null) && ((holderObj instanceof ClientHolder)))
/*      */           {
/* 1676 */             type = "client";
/*      */           }
/*      */         }
/* 1679 */         log.warn("Asked to terminate " + type + " lease for client session id " + clientSessionId + ", but lease for this id could not be found." + ": " + this.clientLeases);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void updateClientLease(InvocationRequest invocation)
/*      */   {
/* 1687 */     if (invocation != null)
/*      */     {
/* 1689 */       String clientSessionId = invocation.getSessionId();
/* 1690 */       if (clientSessionId != null)
/*      */       {
/* 1692 */         if (trace) log.trace("Getting lease for client session id: " + clientSessionId);
/*      */ 
/* 1694 */         Lease clientLease = (Lease)this.clientLeases.get(clientSessionId);
/* 1695 */         if (clientLease == null)
/*      */         {
/* 1697 */           Lease newClientLease = new Lease(clientSessionId, this.leasePeriod, this.locator.getLocatorURI(), invocation.getRequestPayload(), this.connectionNotifier, this.clientLeases);
/*      */ 
/* 1703 */           this.clientLeases.put(clientSessionId, newClientLease);
/* 1704 */           newClientLease.startLease();
/*      */ 
/* 1706 */           if (trace) log.trace("No lease established for client session id (" + clientSessionId + "), so starting a new one.");
/*      */ 
/*      */         }
/*      */         else
/*      */         {
/* 1711 */           clientLease.updateLease(this.leasePeriod, invocation.getRequestPayload());
/*      */ 
/* 1713 */           if (trace) log.trace("Updated lease for client session id (" + clientSessionId + ")");
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void handleOnewayInvocation(OnewayInvocation onewayInvocation, InvocationRequest invocation)
/*      */     throws Throwable
/*      */   {
/* 1726 */     Object[] objs = onewayInvocation.getParameters();
/*      */ 
/* 1729 */     Object realParam = objs[0];
/* 1730 */     invocation.setParameter(realParam);
/*      */ 
/* 1732 */     InvocationRequest newInvocation = invocation;
/*      */ 
/* 1734 */     ThreadPool executor = getOnewayThreadPool();
/* 1735 */     Runnable onewayRun = new Runnable(newInvocation) {
/*      */       private final InvocationRequest val$newInvocation;
/*      */ 
/*      */       public void run() {
/*      */         try {
/* 1741 */           ServerInvoker.this.invoke(this.val$newInvocation);
/*      */         }
/*      */         catch (Throwable e)
/*      */         {
/* 1746 */           ServerInvoker.log.error("Error executing server oneway invocation request: " + this.val$newInvocation, e);
/*      */         }
/*      */       }
/*      */     };
/* 1751 */     if (trace) log.trace(this + " placing " + invocation + " in onewayThreadPool");
/* 1752 */     executor.run(onewayRun);
/*      */   }
/*      */ 
/*      */   private StreamHandler getStreamHandler(InvocationRequest invocation) throws Exception
/*      */   {
/* 1757 */     InternalInvocation inv = (InternalInvocation)invocation.getParameter();
/* 1758 */     String locator = (String)inv.getParameters()[0];
/* 1759 */     return new StreamHandler(locator);
/*      */   }
/*      */ 
/*      */   private ServerInvokerCallbackHandler getCallbackHandler(InvocationRequest invocation)
/*      */     throws Exception
/*      */   {
/* 1765 */     ServerInvokerCallbackHandler callbackHandler = null;
/* 1766 */     String id = ServerInvokerCallbackHandler.getId(invocation);
/* 1767 */     synchronized (this.callbackHandlers)
/*      */     {
/* 1769 */       callbackHandler = (ServerInvokerCallbackHandler)this.callbackHandlers.get(id);
/*      */ 
/* 1772 */       if (callbackHandler == null)
/*      */       {
/* 1774 */         callbackHandler = new ServerInvokerCallbackHandler(invocation, getLocator(), this);
/* 1775 */         this.callbackHandlers.put(id, callbackHandler);
/*      */       }
/*      */     }
/*      */ 
/* 1779 */     callbackHandler.connect();
/* 1780 */     if (trace) log.trace("ServerInvoker (" + this + ") adding server callback handler " + callbackHandler + " with id of " + id + ".");
/* 1781 */     return callbackHandler;
/*      */   }
/*      */ 
/*      */   private ServerInvokerCallbackHandler removeCallbackHandler(InvocationRequest invocation)
/*      */   {
/* 1786 */     String id = ServerInvokerCallbackHandler.getId(invocation);
/* 1787 */     ServerInvokerCallbackHandler callbackHandler = null;
/*      */ 
/* 1789 */     synchronized (this.callbackHandlers)
/*      */     {
/* 1791 */       callbackHandler = (ServerInvokerCallbackHandler)this.callbackHandlers.remove(id);
/*      */     }
/* 1793 */     return callbackHandler;
/*      */   }
/*      */ 
/*      */   private class CallbackContainer
/*      */   {
/*      */     private InvokerCallbackHandler handler;
/*      */     private Object handleObject;
/*      */ 
/*      */     public CallbackContainer(InvokerCallbackHandler handler, Object handleObject)
/*      */     {
/* 1813 */       this.handler = handler;
/* 1814 */       this.handleObject = handleObject;
/*      */     }
/*      */ 
/*      */     public InvokerCallbackHandler getCallbackHandler()
/*      */     {
/* 1819 */       return this.handler;
/*      */     }
/*      */ 
/*      */     public Object getCallbackHandleObject()
/*      */     {
/* 1824 */       return this.handleObject;
/*      */     }
/*      */   }
/*      */ 
/*      */   public static class InvalidStateException extends Exception
/*      */   {
/*      */     public InvalidStateException(String msg)
/*      */     {
/* 1802 */       super();
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.ServerInvoker
 * JD-Core Version:    0.6.0
 */