/*     */ package org.jboss.remoting.callback;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.SerializableStore;
/*     */ 
/*     */ public class BlockingCallbackStore
/*     */   implements SerializableStore
/*     */ {
/*  44 */   private Object lockObject = new Object();
/*     */ 
/*  46 */   private List callbacks = new ArrayList();
/*     */ 
/*  48 */   private static final Logger log = Logger.getLogger(BlockingCallbackStore.class);
/*     */ 
/*     */   public int size()
/*     */   {
/*  57 */     return this.callbacks.size();
/*     */   }
/*     */ 
/*     */   public Object getNext()
/*     */     throws IOException
/*     */   {
/*  69 */     Object callback = null;
/*     */ 
/*  71 */     synchronized (this.lockObject)
/*     */     {
/*  73 */       if (this.callbacks.size() > 0)
/*     */       {
/*  75 */         callback = this.callbacks.remove(0);
/*     */       }
/*  77 */       this.lockObject.notify();
/*     */     }
/*  79 */     return callback;
/*     */   }
/*     */ 
/*     */   public void add(Serializable object)
/*     */     throws IOException
/*     */   {
/*  91 */     if (log.isTraceEnabled())
/*     */     {
/*  93 */       log.trace("Adding " + object + " to blocking callback store.  Calling thread " + Thread.currentThread() + " will be held until getNext() is called");
/*     */     }
/*     */ 
/*  97 */     synchronized (this.lockObject)
/*     */     {
/*     */       try
/*     */       {
/* 101 */         this.callbacks.add(object);
/* 102 */         this.lockObject.wait();
/*     */       }
/*     */       catch (InterruptedException e)
/*     */       {
/* 106 */         log.debug("InterruptedException received while waiting for thread (" + Thread.currentThread() + ") to be released from BlockingCallbackStore.add(Serializable) call.");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setConfig(Map config)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setPurgeOnShutdown(boolean purgeOnShutdown)
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean getPurgeOnShutdown()
/*     */   {
/* 164 */     return false;
/*     */   }
/*     */ 
/*     */   public void purgeFiles()
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.callback.BlockingCallbackStore
 * JD-Core Version:    0.6.0
 */