/*     */ package org.jboss.remoting.callback;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.SerializableStore;
/*     */ 
/*     */ public class NullCallbackStore
/*     */   implements SerializableStore, Serializable
/*     */ {
/*     */   static final long serialVersionUID = -8182007953992756845L;
/*     */   private boolean isCallbackLost;
/*  44 */   private static final Logger log = Logger.getLogger(NullCallbackStore.class);
/*     */ 
/*     */   public NullCallbackStore()
/*     */   {
/*  42 */     this.isCallbackLost = false;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/*  53 */     return this.isCallbackLost ? 1 : 0;
/*     */   }
/*     */ 
/*     */   public Object getNext()
/*     */     throws IOException
/*     */   {
/*  67 */     if (this.isCallbackLost)
/*     */     {
/*  69 */       this.isCallbackLost = false;
/*  70 */       return new FailedCallback("This is an invalid callback.  The server ran out of memory, so callbacks were lost.");
/*     */     }
/*     */ 
/*  74 */     return null;
/*     */   }
/*     */ 
/*     */   public void add(Serializable object)
/*     */     throws IOException
/*     */   {
/*  88 */     this.isCallbackLost = true;
/*  89 */     log.error("Lost callback because not enough free memory available.  Callback lost was " + object);
/*  90 */     throw new IOException("Callback has been lost because not enough free memory to hold object.");
/*     */   }
/*     */ 
/*     */   public void setConfig(Map config)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setPurgeOnShutdown(boolean purgeOnShutdown)
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean getPurgeOnShutdown()
/*     */   {
/* 150 */     return false;
/*     */   }
/*     */ 
/*     */   public void purgeFiles()
/*     */   {
/*     */   }
/*     */ 
/*     */   public class FailedCallback extends Callback
/*     */   {
/*     */     public FailedCallback(Object callbackPayload)
/*     */     {
/* 162 */       super();
/*     */     }
/*     */ 
/*     */     public Object getCallbackObject()
/*     */     {
/* 167 */       throw new RuntimeException("This is an invalid callback.  The server ran out of memory, so callbacks were lost.");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.callback.NullCallbackStore
 * JD-Core Version:    0.6.0
 */