/*     */ package org.jboss.remoting.detection;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.Timer;
/*     */ import java.util.TimerTask;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerInvocationHandler;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.ConnectionValidator;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.InvokerRegistry;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.ident.Identity;
/*     */ import org.jboss.remoting.network.NetworkInstance;
/*     */ import org.jboss.remoting.network.NetworkRegistryFinder;
/*     */ import org.jboss.remoting.network.NetworkRegistryMBean;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public abstract class AbstractDetector
/*     */   implements AbstractDetectorMBean
/*     */ {
/*  61 */   private long defaultTimeDelay = 5000L;
/*  62 */   private long heartbeatTimeDelay = 1000L;
/*  63 */   protected final Logger log = Logger.getLogger(getClass());
/*     */   protected MBeanServer mbeanserver;
/*     */   protected ObjectName objectName;
/*     */   protected ObjectName registryObjectName;
/*     */   protected NetworkRegistryMBean networkRegistry;
/*     */   private Identity myself;
/*     */   private Timer heartbeatTimer;
/*     */   private Timer failureTimer;
/*  72 */   private Map servers = new HashMap();
/*     */   private Element xml;
/*  74 */   private Set domains = new HashSet();
/*  75 */   private boolean acceptLocal = false;
/*     */   private Map config;
/*     */ 
/*     */   public AbstractDetector()
/*     */   {
/*  81 */     this(null);
/*     */   }
/*     */ 
/*     */   public AbstractDetector(Map config)
/*     */   {
/*  86 */     this.config = new HashMap();
/*  87 */     if (config != null)
/*  88 */       this.config.putAll(config);
/*     */   }
/*     */ 
/*     */   public void setHeartbeatTimeDelay(long heartbeatTimeDelay)
/*     */   {
/*  99 */     if ((heartbeatTimeDelay > 0L) && (heartbeatTimeDelay < this.defaultTimeDelay))
/*     */     {
/* 101 */       this.heartbeatTimeDelay = heartbeatTimeDelay;
/*     */     }
/*     */     else
/*     */     {
/* 105 */       throw new IllegalArgumentException("Can not set heartbeat time delay (" + heartbeatTimeDelay + ") to a negative number or " + "to a number greater than the default time delay (" + this.defaultTimeDelay + ").");
/*     */     }
/*     */   }
/*     */ 
/*     */   public long getHeartbeatTimeDelay()
/*     */   {
/* 117 */     return this.heartbeatTimeDelay;
/*     */   }
/*     */ 
/*     */   public void setDefaultTimeDelay(long defaultTimeDelay)
/*     */   {
/* 129 */     if (defaultTimeDelay >= this.heartbeatTimeDelay)
/*     */     {
/* 131 */       this.defaultTimeDelay = defaultTimeDelay;
/*     */     }
/*     */     else
/*     */     {
/* 135 */       throw new IllegalArgumentException("Can not set the default time delay (" + defaultTimeDelay + ") to be less" + " than that of the heartbeat time delay (" + this.heartbeatTimeDelay + ").");
/*     */     }
/*     */   }
/*     */ 
/*     */   public long getDefaultTimeDelay()
/*     */   {
/* 146 */     return this.defaultTimeDelay;
/*     */   }
/*     */ 
/*     */   public Detection createDetection()
/*     */   {
/* 157 */     Detection detection = null;
/*     */ 
/* 159 */     ServerInvoker[] invokers = InvokerRegistry.getServerInvokers();
/* 160 */     if ((invokers == null) || (invokers.length <= 0))
/*     */     {
/* 162 */       return detection;
/*     */     }
/* 164 */     List l = new ArrayList(invokers.length);
/* 165 */     for (int c = 0; c < invokers.length; c++)
/*     */     {
/* 167 */       if (!invokers[c].isStarted())
/*     */         continue;
/* 169 */       ServerInvokerMetadata serverInvoker = new ServerInvokerMetadata(invokers[c].getLocator(), invokers[c].getSupportedSubsystems());
/*     */ 
/* 171 */       l.add(serverInvoker);
/*     */     }
/*     */ 
/* 174 */     if (l.isEmpty())
/*     */     {
/* 176 */       return detection;
/*     */     }
/* 178 */     ServerInvokerMetadata[] metadata = (ServerInvokerMetadata[])l.toArray(new ServerInvokerMetadata[l.size()]);
/* 179 */     detection = new Detection(Identity.get(this.mbeanserver), metadata);
/* 180 */     return detection;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 191 */     this.myself = Identity.get(this.mbeanserver);
/*     */ 
/* 194 */     if ((this.domains.isEmpty()) && (this.xml == null))
/*     */     {
/* 196 */       this.domains.add(this.myself.getDomain());
/*     */     }
/*     */ 
/* 200 */     this.registryObjectName = NetworkRegistryFinder.find(this.mbeanserver);
/* 201 */     if (this.registryObjectName == null)
/*     */     {
/* 203 */       this.log.warn("Detector: " + getClass().getName() + " could not be loaded because the NetworkRegistry is not registered");
/* 204 */       this.log.warn("This means that only the broadcasting of detection messages will be functional and will not be able to discover other servers.");
/*     */     }
/*     */     else
/*     */     {
/* 208 */       this.networkRegistry = ((NetworkRegistryMBean)MBeanServerInvocationHandler.newProxyInstance(this.mbeanserver, this.registryObjectName, NetworkRegistryMBean.class, false));
/*     */     }
/*     */ 
/* 211 */     startPinger(getPingerDelay(), getPingerPeriod());
/* 212 */     startHeartbeat(getHeartbeatDelay(), getHeartbeatPeriod());
/*     */   }
/*     */ 
/*     */   protected long getPingerDelay()
/*     */   {
/* 223 */     return 5000L;
/*     */   }
/*     */ 
/*     */   protected long getPingerPeriod()
/*     */   {
/* 234 */     return 1500L;
/*     */   }
/*     */ 
/*     */   protected void startPinger(long delay, long period)
/*     */   {
/* 245 */     this.failureTimer = new Timer(false);
/* 246 */     this.failureTimer.schedule(new FailureDetector(null), delay, period);
/*     */   }
/*     */ 
/*     */   protected void stopPinger()
/*     */   {
/* 254 */     if (this.failureTimer != null)
/*     */     {
/* 256 */       this.failureTimer.cancel();
/* 257 */       this.failureTimer = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/* 268 */     stopPinger();
/* 269 */     stopHeartbeat();
/* 270 */     stopPinger();
/*     */   }
/*     */ 
/*     */   public void postDeregister()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void postRegister(Boolean aBoolean)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void preDeregister() throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception
/*     */   {
/* 287 */     this.mbeanserver = mBeanServer;
/* 288 */     this.objectName = objectName;
/* 289 */     return objectName;
/*     */   }
/*     */ 
/*     */   public void setConfiguration(Element xml)
/*     */     throws Exception
/*     */   {
/* 302 */     this.xml = xml;
/*     */ 
/* 305 */     if (xml != null)
/*     */     {
/* 308 */       this.domains.clear();
/*     */ 
/* 310 */       NodeList domainNodes = xml.getElementsByTagName("domain");
/* 311 */       if ((domainNodes == null) || (domainNodes.getLength() <= 0))
/*     */       {
/* 314 */         this.log.debug("No domains specified.  Will accept all domains.");
/*     */       }
/* 316 */       int len = domainNodes.getLength();
/* 317 */       for (int c = 0; c < len; c++)
/*     */       {
/* 319 */         Node node = domainNodes.item(c);
/* 320 */         String domain = node.getFirstChild().getNodeValue();
/* 321 */         this.domains.add(domain);
/* 322 */         this.log.debug("Added domain " + domain + " to detector list.");
/*     */       }
/*     */ 
/* 326 */       NodeList localNode = xml.getElementsByTagName("local");
/* 327 */       if (localNode != null)
/*     */       {
/* 329 */         this.acceptLocal = true;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Element getConfiguration()
/*     */   {
/* 344 */     return this.xml;
/*     */   }
/*     */ 
/*     */   protected void startHeartbeat(long delay, long period)
/*     */   {
/* 357 */     if (this.heartbeatTimer == null)
/*     */     {
/* 359 */       this.heartbeatTimer = new Timer(false);
/*     */     }
/* 361 */     this.heartbeatTimer.schedule(new Heartbeat(null), delay, period);
/*     */   }
/*     */ 
/*     */   protected void stopHeartbeat()
/*     */   {
/* 369 */     if (this.heartbeatTimer != null)
/*     */     {
/*     */       try
/*     */       {
/* 373 */         this.heartbeatTimer.cancel();
/*     */       }
/*     */       catch (Exception eg)
/*     */       {
/*     */       }
/* 378 */       this.heartbeatTimer = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected long getHeartbeatDelay()
/*     */   {
/* 390 */     return 0L;
/*     */   }
/*     */ 
/*     */   protected long getHeartbeatPeriod()
/*     */   {
/* 401 */     return this.heartbeatTimeDelay;
/*     */   }
/*     */ 
/*     */   protected abstract void heartbeat();
/*     */ 
/*     */   public NetworkInstance[] forceDetection()
/*     */   {
/* 420 */     forceHeartbeat();
/* 421 */     if (this.networkRegistry != null)
/*     */     {
/* 423 */       return this.networkRegistry.getServers();
/*     */     }
/*     */ 
/* 427 */     return null;
/*     */   }
/*     */ 
/*     */   protected abstract void forceHeartbeat();
/*     */ 
/*     */   protected void detect(Detection detection)
/*     */   {
/* 445 */     if (detection != null)
/*     */     {
/* 447 */       if (this.log.isTraceEnabled())
/*     */       {
/* 449 */         this.log.trace("Detection message received.");
/* 450 */         this.log.trace("Id = " + detection.getIdentity() != null ? detection.getIdentity().getInstanceId() : "null");
/* 451 */         this.log.trace("isRemoteDetection() = " + isRemoteDetection(detection));
/*     */       }
/*     */ 
/* 454 */       if (isRemoteDetection(detection))
/*     */       {
/*     */         try
/*     */         {
/* 458 */           boolean found = false;
/* 459 */           Server server = null;
/*     */ 
/* 461 */           synchronized (this.servers)
/*     */           {
/* 463 */             server = (Server)this.servers.get(detection);
/* 464 */             found = server != null;
/* 465 */             if (!found)
/*     */             {
/* 468 */               this.servers.put(detection, new Server(detection));
/*     */             }
/*     */             else
/*     */             {
/* 472 */               server.lastDetection = System.currentTimeMillis();
/*     */             }
/*     */           }
/* 475 */           if (!found)
/*     */           {
/* 477 */             if (this.networkRegistry != null)
/*     */             {
/* 479 */               this.log.debug("detected NEW server: " + detection);
/* 480 */               this.networkRegistry.addServer(detection.getIdentity(), detection.getServerInvokers());
/*     */             }
/*     */ 
/*     */           }
/* 485 */           else if (server.changed(detection))
/*     */           {
/* 488 */             this.servers.put(detection, new Server(detection));
/* 489 */             if (this.networkRegistry != null)
/*     */             {
/* 491 */               if (this.log.isTraceEnabled())
/*     */               {
/* 493 */                 this.log.trace("detected UPDATE for server: " + detection);
/*     */               }
/* 495 */               this.networkRegistry.updateServer(detection.getIdentity(), detection.getServerInvokers());
/*     */             }
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 502 */           this.log.error("Error during detection of: " + detection, e);
/*     */         }
/*     */       }
/* 505 */       else if (this.log.isTraceEnabled())
/*     */       {
/* 507 */         this.log.trace("detection from myself - ignored");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean isRemoteDetection(Detection detection)
/*     */   {
/* 514 */     String domain = null;
/* 515 */     if (detection != null)
/*     */     {
/* 517 */       Identity identity = detection.getIdentity();
/* 518 */       if (identity != null)
/*     */       {
/* 520 */         domain = identity.getDomain();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 525 */     return ((domain == null) || (this.domains.isEmpty()) || (this.domains.contains(domain))) && ((this.acceptLocal) || (!this.myself.isSameJVM(detection.getIdentity())));
/*     */   }
/*     */ 
/*     */   protected boolean checkInvokerServer(Detection detection, ClassLoader cl)
/*     */   {
/* 531 */     boolean ok = false;
/* 532 */     ServerInvokerMetadata[] invokerMetadataArray = detection.getServerInvokers();
/* 533 */     ArrayList validinvokers = new ArrayList();
/* 534 */     for (int c = 0; c < invokerMetadataArray.length; c++)
/*     */     {
/* 536 */       InvokerLocator locator = null;
/*     */       try
/*     */       {
/* 539 */         ServerInvokerMetadata invokerMetadata = invokerMetadataArray[c];
/* 540 */         locator = invokerMetadata.getInvokerLocator();
/*     */ 
/* 542 */         boolean isValid = ConnectionValidator.checkConnection(locator, this.config);
/* 543 */         if (isValid)
/*     */         {
/* 546 */           ok = true;
/* 547 */           validinvokers.add(invokerMetadata);
/* 548 */           if (this.log.isTraceEnabled())
/*     */           {
/* 550 */             this.log.trace("Successful connection check for " + locator);
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (Throwable ig)
/*     */       {
/* 557 */         this.log.debug("failed calling ping on " + detection + " due to " + ig.getMessage());
/* 558 */         if (!this.log.isTraceEnabled())
/*     */           continue;
/* 560 */         this.log.trace(ig);
/*     */       }
/*     */     }
/*     */ 
/* 564 */     if (!ok)
/*     */     {
/*     */       try
/*     */       {
/* 573 */         if (this.networkRegistry != null)
/*     */         {
/* 575 */           this.networkRegistry.removeServer(detection.getIdentity());
/* 576 */           this.log.debug("Removed detection " + detection);
/*     */         }
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 581 */         this.log.debug("Error removing server for detection (" + detection + ").  Possible network registry does not exist.");
/*     */       }
/*     */       finally
/*     */       {
/* 586 */         this.servers.remove(detection);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 591 */       if (this.log.isTraceEnabled())
/*     */       {
/* 593 */         this.log.trace("Done checking all locators for suspected dead server.  There are " + validinvokers.size() + " out of original " + invokerMetadataArray.length + " still valid.");
/*     */       }
/*     */ 
/* 598 */       if (validinvokers.size() != invokerMetadataArray.length)
/*     */       {
/* 600 */         ServerInvokerMetadata[] newLocators = (ServerInvokerMetadata[])validinvokers.toArray(new ServerInvokerMetadata[validinvokers.size()]);
/* 601 */         Detection newDetection = new Detection(detection.getIdentity(), newLocators);
/* 602 */         if (this.log.isTraceEnabled())
/*     */         {
/* 604 */           this.log.trace("Since at least one invoker failed while doing connection check, will be re-evaluating detection for:\n" + newDetection);
/*     */         }
/* 606 */         detect(newDetection);
/*     */       }
/*     */     }
/*     */ 
/* 610 */     return ok;
/*     */   }
/*     */   private final class Heartbeat extends TimerTask {
/* 711 */     private int threadCounter = 0;
/*     */     private final AbstractDetector this$0;
/*     */ 
/*     */     private Heartbeat() {  }
/*     */ 
/* 715 */     public void run() { Thread.currentThread().setName("Remoting Detector - Heartbeat Thread: " + this.threadCounter++);
/* 716 */       this.this$0.heartbeat();
/*     */     }
/*     */ 
/*     */     Heartbeat(AbstractDetector.1 x1)
/*     */     {
/* 709 */       this();
/*     */     }
/*     */   }
/*     */ 
/*     */   private final class Server
/*     */   {
/*     */     Detection detection;
/* 665 */     private int hashCode = 0;
/* 666 */     long lastDetection = System.currentTimeMillis();
/*     */ 
/*     */     Server(Detection detection)
/*     */     {
/* 670 */       this.detection = detection;
/* 671 */       rehash(detection);
/*     */     }
/*     */ 
/*     */     private void rehash(Detection d)
/*     */     {
/* 676 */       this.hashCode = hash(d);
/*     */     }
/*     */ 
/*     */     private int hash(Detection d)
/*     */     {
/* 681 */       int hc = 0;
/* 682 */       InvokerLocator[] locators = d.getLocators();
/* 683 */       if (locators != null)
/*     */       {
/* 685 */         for (int c = 0; c < locators.length; c++)
/*     */         {
/* 687 */           hc += locators[c].hashCode();
/*     */         }
/*     */       }
/* 690 */       return hc;
/*     */     }
/*     */ 
/*     */     boolean changed(Detection detection)
/*     */     {
/* 695 */       return this.hashCode != hash(detection);
/*     */     }
/*     */ 
/*     */     public boolean equals(Object obj)
/*     */     {
/* 700 */       return ((obj instanceof Server)) && (this.hashCode == obj.hashCode());
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 705 */       return this.hashCode;
/*     */     }
/*     */   }
/*     */ 
/*     */   private final class FailureDetector extends TimerTask
/*     */   {
/* 616 */     private int threadCounter = 0;
/*     */     private final AbstractDetector this$0;
/*     */ 
/*     */     private FailureDetector()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 620 */       Thread.currentThread().setName("Remoting Detector - Failure Detector Thread: " + this.threadCounter++);
/*     */ 
/* 622 */       synchronized (this.this$0.servers)
/*     */       {
/* 624 */         if (this.this$0.servers.isEmpty())
/*     */         {
/* 626 */           return;
/*     */         }
/* 628 */         ClassLoader cl = this.this$0.getClass().getClassLoader();
/*     */ 
/* 630 */         Collection serverCollection = this.this$0.servers.values();
/* 631 */         AbstractDetector.Server[] serverArray = (AbstractDetector.Server[])serverCollection.toArray(new AbstractDetector.Server[serverCollection.size()]);
/* 632 */         for (int x = 0; x < serverArray.length; x++)
/*     */         {
/* 634 */           AbstractDetector.Server svr = serverArray[x];
/* 635 */           Detection detect = svr.detection;
/* 636 */           long lastDetection = svr.lastDetection;
/* 637 */           long duration = System.currentTimeMillis() - lastDetection;
/* 638 */           if (duration < this.this$0.defaultTimeDelay)
/*     */             continue;
/* 640 */           if (this.this$0.log.isTraceEnabled())
/*     */           {
/* 642 */             this.this$0.log.trace("detection for: " + detect + " has not been received in: " + this.this$0.defaultTimeDelay + " ms, contacting..");
/*     */           }
/*     */ 
/* 647 */           if (!this.this$0.checkInvokerServer(detect, cl))
/*     */             continue;
/* 649 */           if (this.this$0.log.isTraceEnabled())
/*     */           {
/* 651 */             this.this$0.log.trace("detection for: " + detect + " recovered on ping");
/*     */           }
/* 653 */           svr.lastDetection = System.currentTimeMillis();
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     FailureDetector(AbstractDetector.1 x1)
/*     */     {
/* 614 */       this();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.detection.AbstractDetector
 * JD-Core Version:    0.6.0
 */