/*     */ package org.jboss.remoting.detection.util;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerFactory;
/*     */ import javax.management.ObjectName;
/*     */ import org.apache.log4j.BasicConfigurator;
/*     */ import org.apache.log4j.Category;
/*     */ import org.apache.log4j.Level;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.detection.Detector;
/*     */ import org.jboss.remoting.detection.jndi.JNDIDetector;
/*     */ import org.jboss.remoting.detection.multicast.MulticastDetector;
/*     */ import org.jboss.remoting.network.NetworkInstance;
/*     */ import org.jboss.remoting.network.NetworkRegistry;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class DetectorUtil
/*     */ {
/*     */   public static final String TYPE_MULTICAST = "multicast";
/*     */   public static final String TYPE_JNDI = "jndi";
/*     */   public static final int DEFAULT_PORT = 2410;
/*     */   public static final String DEFAULT_HOST = "localhost";
/*  65 */   private String contextFactory = "org.jnp.interfaces.NamingContextFactory";
/*  66 */   private String urlPackage = "org.jboss.naming:org.jnp.interfaces";
/*     */ 
/*  68 */   private String type = "multicast";
/*  69 */   private int port = 2410;
/*  70 */   private String host = "localhost";
/*     */ 
/*     */   public DetectorUtil()
/*     */   {
/*     */   }
/*     */ 
/*     */   public DetectorUtil(String type)
/*     */   {
/*  78 */     this(type, 2410, "localhost");
/*     */   }
/*     */ 
/*     */   public DetectorUtil(String type, int port)
/*     */   {
/*  83 */     this(type, port, "localhost");
/*     */   }
/*     */ 
/*     */   public DetectorUtil(String type, int port, String host)
/*     */   {
/*  88 */     this.type = type;
/*  89 */     this.port = port;
/*  90 */     this.host = host;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*     */     try
/*     */     {
/*  98 */       BasicConfigurator.configure();
/*  99 */       Category.getRoot().setLevel(Level.DEBUG);
/* 100 */       Logger log = Logger.getLogger(getClass());
/*     */ 
/* 102 */       System.setProperty("jboss.identity", String.valueOf(System.currentTimeMillis()));
/*     */ 
/* 104 */       MBeanServer server = MBeanServerFactory.createMBeanServer();
/*     */ 
/* 106 */       NetworkRegistry registry = NetworkRegistry.getInstance();
/* 107 */       server.registerMBean(registry, new ObjectName("remoting:type=NetworkRegistry"));
/*     */ 
/* 109 */       InvokerLocator locator = new InvokerLocator("socket://localhost");
/*     */ 
/* 116 */       Connector connector = new Connector();
/* 117 */       connector.setInvokerLocator(locator.getLocatorURI());
/* 118 */       ObjectName obj = new ObjectName("jboss.remoting:type=Connector,transport=" + locator.getProtocol());
/* 119 */       server.registerMBean(connector, obj);
/*     */ 
/* 121 */       connector.start();
/*     */ 
/* 123 */       Detector detector = null;
/* 124 */       ObjectName objName = null;
/*     */ 
/* 126 */       if (this.type.equals("multicast"))
/*     */       {
/* 128 */         MulticastDetector mdet = new MulticastDetector();
/* 129 */         mdet.setPort(this.port);
/* 130 */         detector = mdet;
/* 131 */         objName = new ObjectName("remoting:type=Detector,transport=multicast");
/*     */       }
/* 133 */       else if (this.type.equals("jndi"))
/*     */       {
/* 135 */         JNDIDetector jdet = new JNDIDetector();
/* 136 */         jdet.setPort(this.port);
/* 137 */         jdet.setHost(this.host);
/* 138 */         jdet.setContextFactory(this.contextFactory);
/* 139 */         jdet.setURLPackage(this.urlPackage);
/* 140 */         detector = jdet;
/* 141 */         objName = new ObjectName("remoting:type=Detector,transport=jndi");
/*     */       }
/*     */ 
/* 144 */       server.registerMBean(detector, objName);
/* 145 */       detector.start();
/* 146 */       System.err.println("Starting Detector");
/*     */       while (true)
/*     */       {
/* 150 */         Thread.currentThread(); Thread.sleep(3000L);
/* 151 */         NetworkInstance[] instances = registry.getServers();
/* 152 */         for (int x = 0; x < instances.length; x++)
/*     */         {
/* 154 */           log.debug(instances[x]);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 162 */       System.err.println("Error creating and starting DetectorUtil.");
/* 163 */       ex.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 169 */     DetectorUtil test = null;
/*     */ 
/* 171 */     if (args.length == 1)
/*     */     {
/* 173 */       String type = args[0];
/* 174 */       test = new DetectorUtil(type);
/*     */     }
/* 176 */     else if (args.length == 2)
/*     */     {
/* 178 */       String type = args[0];
/* 179 */       int port = Integer.parseInt(args[1]);
/* 180 */       test = new DetectorUtil(type, port);
/*     */     }
/* 182 */     else if (args.length == 3)
/*     */     {
/* 184 */       String type = args[0];
/* 185 */       int port = Integer.parseInt(args[1]);
/* 186 */       String host = args[2];
/* 187 */       test = new DetectorUtil(type, port, host);
/*     */     }
/*     */     else
/*     */     {
/* 191 */       test = new DetectorUtil();
/* 192 */       System.out.println("Using default type (" + test.getTransport() + ") and default port (" + test.getPort() + ") and " + "default host (" + test.getHost() + ")" + "\nCan enter type (multicast, jndi), port, and/or host via command line.");
/*     */     }
/*     */ 
/* 198 */     test.start();
/*     */   }
/*     */ 
/*     */   private String getHost()
/*     */   {
/* 205 */     return this.host;
/*     */   }
/*     */ 
/*     */   private int getPort()
/*     */   {
/* 210 */     return this.port;
/*     */   }
/*     */ 
/*     */   private String getTransport()
/*     */   {
/* 215 */     return this.type;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.detection.util.DetectorUtil
 * JD-Core Version:    0.6.0
 */