/*     */ package org.jboss.remoting.loading;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.io.PrintStream;
/*     */ import java.io.StreamCorruptedException;
/*     */ import java.util.zip.DataFormatException;
/*     */ import java.util.zip.Deflater;
/*     */ import java.util.zip.Inflater;
/*     */ 
/*     */ public class CompressedClassBytes extends ClassBytes
/*     */   implements Externalizable
/*     */ {
/*     */   static final long serialVersionUID = 5984363018051268886L;
/*  39 */   private static final int MIN_COMPRESS = Integer.parseInt(System.getProperty("jboss.remoting.compression.min", "1000"));
/*  40 */   private static final boolean DEBUG = Boolean.getBoolean("jboss.remoting.compression.debug");
/*     */   private int compressionLevel;
/*     */   private int compressedSize;
/*     */   private int originalSize;
/*     */   static final int VERSION_5_0 = 500;
/*     */   static final int CURRENT_VERSION = 500;
/*     */ 
/*     */   public CompressedClassBytes()
/*     */   {
/*  50 */     super(null, null);
/*     */   }
/*     */ 
/*     */   public CompressedClassBytes(String className, byte[] data, int compressionLevel)
/*     */   {
/*  55 */     super(className, data);
/*  56 */     this.compressionLevel = compressionLevel;
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*     */     try
/*     */     {
/*  63 */       String string = new String("Hello,world - this is a test of compression, not sure what will happen. alskjfdalksjflkajsdfljaslkfjaslkdjflksajflkajsfdlkjsalkfjaslkfdjlksajflkasjfdlkajslkfjsalkfjasldfjlksadjflkasjfdlkajdsf");
/*  64 */       byte[] buf = ClassUtil.serialize(string);
/*  65 */       CompressedClassBytes cb = new CompressedClassBytes("java.lang.String", buf, 9);
/*  66 */       byte[] b1 = ClassUtil.serialize(cb);
/*  67 */       obj = ClassUtil.deserialize(b1, ClassLoader.getSystemClassLoader());
/*     */     }
/*     */     catch (Throwable ex)
/*     */     {
/*     */       Object obj;
/*  71 */       ex.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*     */   {
/*  77 */     int version = in.readInt();
/*     */ 
/*  79 */     switch (version)
/*     */     {
/*     */     case 500:
/*  85 */       this.compressionLevel = in.readInt();
/*  86 */       this.originalSize = in.readInt();
/*  87 */       this.compressedSize = in.readInt();
/*  88 */       byte[] buf = new byte[this.compressedSize];
/*  89 */       int count = in.read(buf, 0, this.compressedSize);
/*  90 */       if (this.compressedSize != this.originalSize)
/*     */       {
/*  92 */         this.classBytes = uncompress(buf);
/*     */       }
/*     */       else
/*     */       {
/*  96 */         this.classBytes = buf;
/*     */       }
/*  98 */       if (DEBUG)
/*     */       {
/* 100 */         System.err.println("<< reading compressed: " + this.compressedSize + ", original: " + this.originalSize + ", compressionLevel:" + this.compressionLevel);
/*     */       }
/* 102 */       this.className = ((String)in.readObject());
/* 103 */       break;
/*     */     default:
/* 106 */       throw new StreamCorruptedException("Unknown version seen: " + version);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out) throws IOException
/*     */   {
/* 112 */     out.writeInt(500);
/* 113 */     out.writeInt(this.compressionLevel);
/* 114 */     out.writeInt(this.classBytes.length);
/* 115 */     byte[] compressed = compress(this.classBytes);
/* 116 */     out.writeInt(compressed.length);
/* 117 */     out.write(compressed);
/* 118 */     out.writeObject(this.className);
/* 119 */     out.flush();
/*     */   }
/*     */ 
/*     */   public byte[] compress(byte[] input)
/*     */   {
/* 131 */     if (input.length < MIN_COMPRESS)
/*     */     {
/* 133 */       return input;
/*     */     }
/*     */ 
/* 136 */     Deflater deflater = new Deflater(this.compressionLevel);
/* 137 */     deflater.setInput(input, 0, input.length);
/* 138 */     deflater.finish();
/* 139 */     byte[] buff = new byte[input.length + 50];
/* 140 */     deflater.deflate(buff);
/*     */ 
/* 142 */     int compressedSize = deflater.getTotalOut();
/*     */ 
/* 145 */     if (deflater.getTotalIn() != input.length)
/*     */     {
/* 147 */       if (DEBUG)
/*     */       {
/* 149 */         System.err.println(">> Attempting compression and the data didn't compress well, returning original");
/*     */       }
/* 151 */       return input;
/*     */     }
/* 153 */     if (compressedSize >= input.length - 4)
/*     */     {
/* 155 */       if (DEBUG)
/*     */       {
/* 157 */         System.err.println(">> Compressed size is larger than original .. ?");
/*     */       }
/* 159 */       return input;
/*     */     }
/*     */ 
/* 162 */     byte[] output = new byte[compressedSize + 4];
/* 163 */     System.arraycopy(buff, 0, output, 4, compressedSize);
/* 164 */     output[0] = (byte)(input.length >> 24);
/* 165 */     output[1] = (byte)(input.length >> 16);
/* 166 */     output[2] = (byte)(input.length >> 8);
/* 167 */     output[3] = (byte)input.length;
/* 168 */     if (DEBUG)
/*     */     {
/* 170 */       System.err.println(">> writing compressed: " + output.length + ", original: " + this.classBytes.length + ", compressionLevel:" + this.compressionLevel);
/*     */     }
/* 172 */     return output;
/*     */   }
/*     */ 
/*     */   public byte[] uncompress(byte[] input)
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 184 */       int uncompressedSize = ((input[0] & 0xFF) << 24) + ((input[1] & 0xFF) << 16) + ((input[2] & 0xFF) << 8) + (input[3] & 0xFF);
/*     */ 
/* 190 */       Inflater inflater = new Inflater();
/* 191 */       inflater.setInput(input, 4, input.length - 4);
/* 192 */       inflater.finished();
/*     */ 
/* 194 */       byte[] out = new byte[uncompressedSize];
/* 195 */       inflater.inflate(out);
/*     */ 
/* 197 */       inflater.reset();
/* 198 */       return out;
/*     */     }
/*     */     catch (DataFormatException e)
/*     */     {
/*     */     }
/* 203 */     throw new IOException("Input Stream is corrupt: " + e);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.loading.CompressedClassBytes
 * JD-Core Version:    0.6.0
 */