/*     */ package org.jboss.remoting.marshal;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.marshal.http.HTTPMarshaller;
/*     */ import org.jboss.remoting.marshal.http.HTTPUnMarshaller;
/*     */ import org.jboss.remoting.marshal.rmi.RMIMarshaller;
/*     */ import org.jboss.remoting.marshal.rmi.RMIUnMarshaller;
/*     */ import org.jboss.remoting.marshal.serializable.SerializableMarshaller;
/*     */ import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;
/*     */ 
/*     */ public class MarshalFactory
/*     */ {
/*  49 */   private static Map marshallers = new HashMap();
/*  50 */   private static Map unmarshallers = new HashMap();
/*  51 */   private static Map classMarshallers = new HashMap();
/*  52 */   private static Map classUnmarshallers = new HashMap();
/*     */ 
/*  54 */   protected static final Logger log = Logger.getLogger(MarshalFactory.class);
/*     */ 
/*  56 */   private static final boolean isTrace = log.isTraceEnabled();
/*  57 */   private static final boolean isDebug = log.isDebugEnabled();
/*     */ 
/*     */   public static void addMarshaller(Class classType, Marshaller marshaller, UnMarshaller unMarshaller)
/*     */   {
/*  87 */     classMarshallers.put(classType, marshaller);
/*  88 */     classUnmarshallers.put(classType, unMarshaller);
/*     */   }
/*     */ 
/*     */   public static void addMarshaller(String dataType, Marshaller marshaller, UnMarshaller unMarshaller)
/*     */   {
/* 101 */     marshallers.put(dataType, marshaller);
/* 102 */     unmarshallers.put(dataType, unMarshaller);
/*     */   }
/*     */ 
/*     */   public static Marshaller getMarshaller(Class classType)
/*     */   {
/* 113 */     Marshaller marshaller = null;
/* 114 */     Object obj = classMarshallers.get(classType);
/* 115 */     if ((obj != null) && ((obj instanceof Marshaller)))
/*     */     {
/* 117 */       marshaller = (Marshaller)obj;
/*     */       try
/*     */       {
/* 121 */         marshaller = marshaller.cloneMarshaller();
/*     */       }
/*     */       catch (CloneNotSupportedException e)
/*     */       {
/* 125 */         log.warn("Could not clone " + marshaller);
/*     */       }
/*     */ 
/*     */     }
/* 130 */     else if (isTrace)
/*     */     {
/* 132 */       log.trace("Could not find marshaller for class type '" + classType + "'.  Object in collection is " + obj);
/*     */     }
/*     */ 
/* 136 */     return marshaller;
/*     */   }
/*     */ 
/*     */   public static Marshaller getMarshaller(Class classType, String serializationType)
/*     */   {
/* 147 */     Marshaller marshaller = getMarshaller(classType);
/* 148 */     if ((marshaller instanceof SerialMarshaller))
/*     */     {
/* 150 */       ((SerialMarshaller)marshaller).setSerializationType(serializationType);
/*     */     }
/* 152 */     return marshaller;
/*     */   }
/*     */ 
/*     */   public static UnMarshaller getUnMarshaller(Class classType)
/*     */   {
/* 163 */     UnMarshaller unmarshaller = null;
/* 164 */     Object obj = classUnmarshallers.get(classType);
/* 165 */     if ((obj != null) && ((obj instanceof UnMarshaller)))
/*     */     {
/* 167 */       unmarshaller = (UnMarshaller)obj;
/*     */       try
/*     */       {
/* 171 */         unmarshaller = unmarshaller.cloneUnMarshaller();
/*     */       }
/*     */       catch (CloneNotSupportedException e)
/*     */       {
/* 175 */         log.warn("Could not clone " + unmarshaller);
/*     */       }
/*     */ 
/*     */     }
/* 181 */     else if (isTrace)
/*     */     {
/* 183 */       log.trace("Could not find unmarshaller for class type '" + classType + "'.  Object in collection is " + obj);
/*     */     }
/*     */ 
/* 186 */     return unmarshaller;
/*     */   }
/*     */ 
/*     */   public static UnMarshaller getUnMarshaller(Class classType, String serializationType)
/*     */   {
/* 191 */     UnMarshaller unmarshaller = getUnMarshaller(classType);
/* 192 */     if ((unmarshaller instanceof SerializableUnMarshaller))
/*     */     {
/* 194 */       ((SerializableUnMarshaller)unmarshaller).setSerializationType(serializationType);
/*     */     }
/*     */ 
/* 197 */     return unmarshaller;
/*     */   }
/*     */ 
/*     */   public static Marshaller getMarshaller(String dataType)
/*     */   {
/* 208 */     Marshaller marshaller = null;
/* 209 */     Object obj = marshallers.get(dataType);
/* 210 */     if ((obj != null) && ((obj instanceof Marshaller)))
/*     */     {
/* 212 */       marshaller = (Marshaller)obj;
/*     */       try
/*     */       {
/* 216 */         marshaller = marshaller.cloneMarshaller();
/*     */       }
/*     */       catch (CloneNotSupportedException e)
/*     */       {
/* 220 */         log.warn("Could not clone " + marshaller);
/*     */       }
/*     */ 
/*     */     }
/* 226 */     else if (isTrace)
/*     */     {
/* 228 */       log.trace("Could not find marshaller for data type '" + dataType + "'.  Object in collection is " + obj);
/*     */     }
/*     */ 
/* 232 */     return marshaller;
/*     */   }
/*     */ 
/*     */   public static Marshaller getMarshaller(String dataType, String serializationType)
/*     */   {
/* 238 */     Marshaller marshaller = getMarshaller(dataType);
/* 239 */     if ((marshaller instanceof SerializableMarshaller))
/*     */     {
/* 241 */       ((SerializableMarshaller)marshaller).setSerializationType(serializationType);
/*     */     }
/* 243 */     return marshaller;
/*     */   }
/*     */ 
/*     */   public static UnMarshaller getUnMarshaller(String dataType, String serializationType)
/*     */   {
/* 249 */     UnMarshaller unmarshaller = getUnMarshaller(dataType);
/* 250 */     if ((unmarshaller instanceof SerializableUnMarshaller))
/*     */     {
/* 252 */       ((SerializableUnMarshaller)unmarshaller).setSerializationType(serializationType);
/*     */     }
/*     */ 
/* 255 */     return unmarshaller;
/*     */   }
/*     */ 
/*     */   public static UnMarshaller getUnMarshaller(String dataType)
/*     */   {
/* 267 */     UnMarshaller unmarshaller = null;
/* 268 */     Object obj = unmarshallers.get(dataType);
/* 269 */     if ((obj != null) && ((obj instanceof UnMarshaller)))
/*     */     {
/* 271 */       unmarshaller = (UnMarshaller)obj;
/*     */       try
/*     */       {
/* 275 */         unmarshaller = unmarshaller.cloneUnMarshaller();
/*     */       }
/*     */       catch (CloneNotSupportedException e)
/*     */       {
/* 279 */         log.warn("Could not clone " + unmarshaller);
/*     */       }
/*     */ 
/*     */     }
/* 284 */     else if (isTrace)
/*     */     {
/* 286 */       log.trace("Could not find unmarshaller for data type '" + dataType + "'.  Object in collection is " + obj);
/*     */     }
/*     */ 
/* 290 */     return unmarshaller;
/*     */   }
/*     */ 
/*     */   public static Marshaller getMarshaller(InvokerLocator locator, ClassLoader classLoader)
/*     */   {
/* 307 */     String serializationType = locator.findSerializationType();
/* 308 */     Marshaller marshaller = null;
/* 309 */     if (locator != null)
/*     */     {
/* 311 */       Map params = locator.getParameters();
/* 312 */       if (params != null)
/*     */       {
/* 315 */         String dataType = (String)params.get("datatype");
/* 316 */         if (dataType == null)
/*     */         {
/* 318 */           dataType = (String)params.get("dataType");
/*     */         }
/* 320 */         if (dataType != null)
/*     */         {
/* 322 */           marshaller = getMarshaller(dataType);
/*     */         }
/* 324 */         if (marshaller == null)
/*     */         {
/* 326 */           if (isTrace)
/*     */           {
/* 328 */             log.trace("Could not look up marshaller by data type ('" + dataType + "').  Will try to load dynamically.");
/*     */           }
/*     */ 
/* 332 */           String marshallerFQN = (String)params.get("marshaller");
/* 333 */           marshaller = loadMarshaller(marshallerFQN);
/* 334 */           if (marshaller != null)
/*     */           {
/* 336 */             if (isTrace)
/*     */             {
/* 338 */               log.trace("Found marshaller by loading locally.");
/*     */             }
/*     */ 
/* 341 */             String unmarshallerFQN = (String)params.get("unmarshaller");
/* 342 */             UnMarshaller unmarshaller = loadUnMarshaller(unmarshallerFQN);
/* 343 */             if (unmarshaller != null)
/*     */             {
/* 345 */               addMarshaller(dataType, marshaller, unmarshaller);
/*     */             }
/*     */           }
/*     */         }
/* 349 */         if ((marshaller == null) && (isTrace))
/*     */         {
/* 351 */           log.trace("Tried to find marshaller from locator by both data type and class name but was unsuccessful.  Will try to load it from remote server.");
/*     */         }
/*     */ 
/* 355 */         if ((marshaller == null) && (dataType != null))
/*     */         {
/* 357 */           InvokerLocator loaderLocator = MarshallLoaderFactory.convertLocator(locator);
/* 358 */           if (loaderLocator != null)
/*     */           {
/* 360 */             marshaller = MarshallerLoaderClient.getMarshaller(loaderLocator, dataType, classLoader);
/* 361 */             UnMarshaller unmarshaller = MarshallerLoaderClient.getUnMarshaller(loaderLocator, dataType, classLoader);
/* 362 */             if (unmarshaller != null)
/*     */             {
/* 364 */               unmarshaller.setClassLoader(classLoader);
/*     */             }
/* 366 */             if (isDebug)
/*     */             {
/* 368 */               log.debug("Remotely loaded marshaller: " + marshaller);
/* 369 */               log.debug("Remotely loaded unmarshaller: " + unmarshaller);
/*     */             }
/* 371 */             if ((marshaller != null) && (unmarshaller != null))
/*     */             {
/* 373 */               addMarshaller(dataType, marshaller, unmarshaller);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 380 */     if (marshaller != null)
/*     */     {
/*     */       try
/*     */       {
/* 384 */         marshaller = marshaller.cloneMarshaller();
/*     */       }
/*     */       catch (CloneNotSupportedException e)
/*     */       {
/* 388 */         log.warn("Could not clone " + marshaller);
/*     */       }
/*     */     }
/*     */ 
/* 392 */     if ((marshaller instanceof SerialMarshaller))
/*     */     {
/* 394 */       ((SerialMarshaller)marshaller).setSerializationType(serializationType);
/*     */     }
/* 396 */     return marshaller;
/*     */   }
/*     */ 
/*     */   private static Marshaller loadMarshaller(String marshallerFQN)
/*     */   {
/* 401 */     Marshaller marshaller = null;
/* 402 */     if (marshallerFQN != null)
/*     */     {
/*     */       try
/*     */       {
/* 406 */         Class marshallerClass = Class.forName(marshallerFQN);
/* 407 */         marshaller = (Marshaller)marshallerClass.newInstance();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 411 */         log.warn("Found marshaller fully qualified class name within locator parameters, but was unable to load class: " + marshallerFQN);
/*     */       }
/*     */     }
/*     */ 
/* 415 */     return marshaller;
/*     */   }
/*     */ 
/*     */   public static UnMarshaller getUnMarshaller(InvokerLocator locator, ClassLoader classLoader)
/*     */   {
/* 432 */     String serializationType = locator.findSerializationType();
/* 433 */     UnMarshaller unmarshaller = null;
/* 434 */     if (locator != null)
/*     */     {
/* 436 */       Map params = locator.getParameters();
/* 437 */       if (params != null)
/*     */       {
/* 440 */         String dataType = (String)params.get("datatype");
/* 441 */         if (dataType == null)
/*     */         {
/* 443 */           dataType = (String)params.get("dataType");
/*     */         }
/* 445 */         if (dataType != null)
/*     */         {
/* 447 */           unmarshaller = getUnMarshaller(dataType);
/*     */         }
/* 449 */         if (unmarshaller == null)
/*     */         {
/* 451 */           if (isTrace)
/*     */           {
/* 453 */             log.trace("Could not find unmarshaller by data type ('" + dataType + "').  Will try to load dynamically.");
/*     */           }
/*     */ 
/* 457 */           String unmarshallerFQN = (String)params.get("unmarshaller");
/* 458 */           unmarshaller = loadUnMarshaller(unmarshallerFQN);
/* 459 */           if (unmarshaller != null)
/*     */           {
/* 461 */             String marshallerFQN = (String)params.get("marshaller");
/* 462 */             Marshaller marshaller = loadMarshaller(marshallerFQN);
/* 463 */             if (marshaller != null)
/*     */             {
/* 465 */               addMarshaller(dataType, marshaller, unmarshaller);
/*     */             }
/*     */           }
/*     */         }
/* 469 */         if ((isTrace) && (unmarshaller == null))
/*     */         {
/* 471 */           log.trace("Tried to find unmarshaller from locator by both data type and class name but was unsuccessful.");
/*     */         }
/*     */ 
/* 474 */         if ((unmarshaller == null) && (dataType != null))
/*     */         {
/* 476 */           InvokerLocator loaderLocator = MarshallLoaderFactory.convertLocator(locator);
/* 477 */           unmarshaller = MarshallerLoaderClient.getUnMarshaller(loaderLocator, dataType, classLoader);
/* 478 */           if (unmarshaller != null)
/*     */           {
/* 480 */             unmarshaller.setClassLoader(classLoader);
/*     */           }
/* 482 */           Marshaller marshaller = MarshallerLoaderClient.getMarshaller(loaderLocator, dataType, classLoader);
/* 483 */           if (isTrace)
/*     */           {
/* 485 */             log.trace("Remotely loaded marshaller: " + marshaller);
/* 486 */             log.trace("Remotely loaded unmarshaller: " + unmarshaller);
/*     */           }
/* 488 */           if ((marshaller != null) && (unmarshaller != null))
/*     */           {
/* 490 */             addMarshaller(dataType, marshaller, unmarshaller);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 496 */     if (unmarshaller != null)
/*     */     {
/*     */       try
/*     */       {
/* 500 */         unmarshaller = unmarshaller.cloneUnMarshaller();
/*     */       }
/*     */       catch (CloneNotSupportedException e)
/*     */       {
/* 504 */         log.warn("Could not clone " + unmarshaller);
/*     */       }
/*     */     }
/* 507 */     if ((unmarshaller instanceof SerializableUnMarshaller))
/*     */     {
/* 509 */       ((SerializableUnMarshaller)unmarshaller).setSerializationType(serializationType);
/*     */     }
/* 511 */     return unmarshaller;
/*     */   }
/*     */ 
/*     */   private static UnMarshaller loadUnMarshaller(String unmarshallerFQN)
/*     */   {
/* 516 */     UnMarshaller unmarshaller = null;
/* 517 */     if (unmarshallerFQN != null)
/*     */     {
/*     */       try
/*     */       {
/* 521 */         Class unmarshallerClass = Class.forName(unmarshallerFQN);
/* 522 */         unmarshaller = (UnMarshaller)unmarshallerClass.newInstance();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 526 */         log.error("Found unmarshaller fully qualified class name within locator parameters, but was unable to load class: " + unmarshallerFQN, e);
/*     */       }
/*     */     }
/*     */ 
/* 530 */     return unmarshaller;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  64 */       marshallers.put("serializable", new SerializableMarshaller());
/*  65 */       unmarshallers.put("serializable", new SerializableUnMarshaller());
/*  66 */       marshallers.put("http", new HTTPMarshaller());
/*  67 */       unmarshallers.put("http", new HTTPUnMarshaller());
/*  68 */       marshallers.put("rmi", new RMIMarshaller());
/*  69 */       unmarshallers.put("rmi", new RMIUnMarshaller());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  73 */       log.error("Could not statically load default marshallers.", e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.marshal.MarshalFactory
 * JD-Core Version:    0.6.0
 */