/*     */ package org.jboss.remoting.marshal;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class MarshallLoaderFactory
/*     */ {
/*  38 */   protected static final Logger log = Logger.getLogger(MarshallLoaderFactory.class);
/*     */ 
/*     */   public static Connector createMarshallLoader(InvokerLocator locator)
/*     */   {
/*  50 */     Connector marshallerConnector = null;
/*     */     try
/*     */     {
/*  53 */       marshallerConnector = new MarshallLoaderConnector();
/*  54 */       marshallerConnector.setInvokerLocator(locator.getLocatorURI());
/*  55 */       marshallerConnector.start();
/*     */ 
/*  57 */       MarshallerLoaderHandler loader = new MarshallerLoaderHandler();
/*  58 */       marshallerConnector.addInvocationHandler("loader", loader);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  62 */       log.error("Can not create marshaller loader.", e);
/*  63 */       if (marshallerConnector != null)
/*     */       {
/*     */         try
/*     */         {
/*  67 */           marshallerConnector.stop();
/*  68 */           marshallerConnector.destroy();
/*     */         }
/*     */         catch (Exception e1)
/*     */         {
/*  72 */           log.error("Error cleaning up marshaller loader connector.", e1);
/*     */         }
/*     */       }
/*     */     }
/*  76 */     return marshallerConnector;
/*     */   }
/*     */ 
/*     */   public static InvokerLocator convertLocator(InvokerLocator locator)
/*     */   {
/*  89 */     InvokerLocator loaderLocator = null;
/*     */ 
/*  91 */     if (locator != null)
/*     */     {
/*  93 */       Map params = locator.getParameters();
/*  94 */       if (params != null)
/*     */       {
/*  96 */         String sPort = (String)params.get("loaderport");
/*  97 */         if (sPort != null)
/*     */         {
/*     */           try
/*     */           {
/* 101 */             int port = Integer.parseInt(sPort);
/*     */ 
/* 104 */             String transport = "socket";
/* 105 */             String host = locator.getHost();
/* 106 */             String path = locator.getPath();
/* 107 */             Map metadata = new HashMap();
/* 108 */             metadata.putAll(locator.getParameters());
/*     */ 
/* 110 */             metadata.remove("loaderport");
/* 111 */             metadata.remove("marshaller");
/* 112 */             metadata.remove("unmarshaller");
/* 113 */             metadata.remove("datatype");
/* 114 */             metadata.remove("dataType");
/* 115 */             loaderLocator = new InvokerLocator(transport, host, port, path, metadata);
/*     */           }
/*     */           catch (NumberFormatException e)
/*     */           {
/* 119 */             log.error("Got loader port (" + sPort + ") from locator uri, but was not an number.");
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 124 */     return loaderLocator;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.marshal.MarshallLoaderFactory
 * JD-Core Version:    0.6.0
 */