/*     */ package org.jboss.remoting.marshal.encryption;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.util.Map;
/*     */ import javax.crypto.Cipher;
/*     */ import javax.crypto.CipherInputStream;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ import org.jboss.remoting.marshal.VersionedUnMarshaller;
/*     */ import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;
/*     */ import org.jboss.remoting.serialization.SerializationManager;
/*     */ import org.jboss.remoting.serialization.SerializationStreamFactory;
/*     */ 
/*     */ public class EncryptingUnMarshaller extends SerializableUnMarshaller
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   public static final String DATATYPE = "encrypt";
/*     */   private UnMarshaller wrappedUnMarshaller;
/*  68 */   private String cipherAlgorithm = "DES";
/*     */ 
/*  70 */   private Cipher cipher = EncryptionManager.getCipher(2, this.cipherAlgorithm);
/*     */ 
/*     */   public EncryptingUnMarshaller()
/*     */   {
/*     */   }
/*     */ 
/*     */   public EncryptingUnMarshaller(UnMarshaller unMarshaller)
/*     */   {
/*  89 */     this.wrappedUnMarshaller = unMarshaller;
/*     */   }
/*     */ 
/*     */   public void setCipherAlgorithm(String algo)
/*     */   {
/*  99 */     this.cipherAlgorithm = algo;
/* 100 */     this.cipher = EncryptionManager.getCipher(2, this.cipherAlgorithm);
/*     */   }
/*     */ 
/*     */   public Object read(InputStream inputStream, Map metadata, int version)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 116 */     if (this.cipher == null)
/* 117 */       throw new IllegalStateException("Cipher is null for algo=" + this.cipherAlgorithm);
/* 118 */     CipherInputStream cis = new CipherInputStream(inputStream, this.cipher);
/* 119 */     SerializationManager sm = SerializationStreamFactory.getManagerInstance(getSerializationType());
/* 120 */     ObjectInputStream ois = sm.createRegularInput(cis);
/*     */ 
/* 122 */     Object obj = null;
/* 123 */     if (this.wrappedUnMarshaller != null)
/*     */     {
/* 125 */       if ((this.wrappedUnMarshaller instanceof VersionedUnMarshaller)) {
/* 126 */         return ((VersionedUnMarshaller)this.wrappedUnMarshaller).read(ois, metadata, version);
/*     */       }
/* 128 */       obj = this.wrappedUnMarshaller.read(ois, metadata);
/*     */     }
/*     */     else
/*     */     {
/* 132 */       obj = super.read(ois, metadata, version);
/*     */     }
/* 134 */     return obj;
/*     */   }
/*     */ 
/*     */   public UnMarshaller cloneUnMarshaller()
/*     */     throws CloneNotSupportedException
/*     */   {
/* 145 */     EncryptingUnMarshaller um = new EncryptingUnMarshaller(this.wrappedUnMarshaller);
/* 146 */     um.setCipherAlgorithm(this.cipherAlgorithm);
/* 147 */     return um;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.marshal.encryption.EncryptingUnMarshaller
 * JD-Core Version:    0.6.0
 */