/*    */ package org.jboss.remoting.marshal.encryption;
/*    */ 
/*    */ import java.io.FileOutputStream;
/*    */ import java.io.ObjectOutput;
/*    */ import java.io.ObjectOutputStream;
/*    */ import java.security.Key;
/*    */ import javax.crypto.KeyGenerator;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class KeyGeneratorUtil
/*    */ {
/* 42 */   protected static final Logger log = Logger.getLogger(KeyGeneratorUtil.class);
/*    */ 
/*    */   public void genKeys() throws Exception
/*    */   {
/* 46 */     getKey("DES");
/* 47 */     getKey("DESede");
/* 48 */     getKey("AES");
/* 49 */     getKey("RC4");
/* 50 */     getKey("Blowfish");
/*    */   }
/*    */ 
/*    */   private Key getKey(String algo)
/*    */   {
/* 55 */     Key key = null;
/*    */     try
/*    */     {
/* 58 */       KeyGenerator gen = KeyGenerator.getInstance(algo);
/* 59 */       key = gen.generateKey();
/* 60 */       serializeToFile(key, algo);
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 64 */       log.error(e.getMessage(), e);
/*    */     }
/* 66 */     return key;
/*    */   }
/*    */ 
/*    */   private void serializeToFile(Key key, String algo) throws Exception
/*    */   {
/* 71 */     ObjectOutput out = new ObjectOutputStream(new FileOutputStream(algo + ".key"));
/* 72 */     out.writeObject(key);
/* 73 */     out.close();
/*    */   }
/*    */ 
/*    */   public static void main(String[] args)
/*    */   {
/* 78 */     KeyGeneratorUtil u = new KeyGeneratorUtil();
/*    */     try
/*    */     {
/* 81 */       u.genKeys();
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 85 */       e.printStackTrace();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.marshal.encryption.KeyGeneratorUtil
 * JD-Core Version:    0.6.0
 */