/*     */ package org.jboss.remoting.network;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.detection.ServerInvokerMetadata;
/*     */ import org.jboss.remoting.ident.Identity;
/*     */ 
/*     */ public class NetworkInstance
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = -1745108606611832280L;
/*     */   private final Identity identity;
/*     */   private final ServerInvokerMetadata[] serverInvokers;
/*     */   private final InvokerLocator[] locators;
/*     */   private final int hashCode;
/*     */ 
/*     */   public NetworkInstance(Identity identity, InvokerLocator[] locators)
/*     */   {
/*  47 */     this.identity = identity;
/*  48 */     this.locators = locators;
/*  49 */     this.hashCode = this.identity.hashCode();
/*  50 */     this.serverInvokers = null;
/*     */   }
/*     */ 
/*     */   public NetworkInstance(Identity identity, ServerInvokerMetadata[] serverInvokers)
/*     */   {
/*  55 */     this.identity = identity;
/*  56 */     this.locators = null;
/*  57 */     this.hashCode = this.identity.hashCode();
/*  58 */     this.serverInvokers = serverInvokers;
/*     */   }
/*     */ 
/*     */   public final Identity getIdentity()
/*     */   {
/*  63 */     return this.identity;
/*     */   }
/*     */ 
/*     */   public final InvokerLocator[] getLocators()
/*     */   {
/*  68 */     if (this.locators != null)
/*     */     {
/*  70 */       return this.locators;
/*     */     }
/*     */ 
/*  74 */     InvokerLocator[] locators = new InvokerLocator[this.serverInvokers.length];
/*  75 */     for (int x = 0; x < this.serverInvokers.length; x++)
/*     */     {
/*  77 */       locators[x] = this.serverInvokers[x].getInvokerLocator();
/*     */     }
/*  79 */     return locators;
/*     */   }
/*     */ 
/*     */   public final ServerInvokerMetadata[] getServerInvokers()
/*     */   {
/*  93 */     return this.serverInvokers;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  99 */     return "NetworkInstance [identity:" + this.identity + ",locator count:" + (this.serverInvokers == null ? 0 : this.serverInvokers.length) + "]";
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 104 */     return this.hashCode == obj.hashCode();
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 109 */     return this.hashCode;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.network.NetworkInstance
 * JD-Core Version:    0.6.0
 */