/*     */ package org.jboss.remoting.network;
/*     */ 
/*     */ import javax.management.Notification;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.detection.ServerInvokerMetadata;
/*     */ import org.jboss.remoting.ident.Identity;
/*     */ 
/*     */ public class NetworkNotification extends Notification
/*     */ {
/*     */   static final long serialVersionUID = 987487760197074685L;
/*     */   public static final String SERVER_ADDED = "jboss.network.server.added";
/*     */   public static final String SERVER_UPDATED = "jboss.network.server.updated";
/*     */   public static final String SERVER_REMOVED = "jboss.network.server.removed";
/*     */   public static final String DOMAIN_CHANGED = "jboss.network.domain.changed";
/*     */   private final Identity identity;
/*     */   private final ServerInvokerMetadata[] serverInvokers;
/*     */   private final InvokerLocator[] locators;
/*     */ 
/*     */   public NetworkNotification(ObjectName source, String type, Identity identity, ServerInvokerMetadata[] serverInvokers)
/*     */   {
/*  54 */     super(type, source, System.currentTimeMillis());
/*  55 */     this.identity = identity;
/*  56 */     this.serverInvokers = serverInvokers;
/*  57 */     this.locators = null;
/*     */   }
/*     */ 
/*     */   public NetworkNotification(ObjectName source, String type, Identity identity, InvokerLocator[] locators)
/*     */   {
/*  62 */     super(type, source, System.currentTimeMillis());
/*  63 */     this.identity = identity;
/*  64 */     this.serverInvokers = null;
/*  65 */     this.locators = locators;
/*     */   }
/*     */ 
/*     */   public final Identity getIdentity()
/*     */   {
/*  75 */     return this.identity;
/*     */   }
/*     */ 
/*     */   public final InvokerLocator[] getLocator()
/*     */   {
/*  85 */     if (this.locators != null)
/*     */     {
/*  87 */       return this.locators;
/*     */     }
/*     */ 
/*  91 */     InvokerLocator[] locators = new InvokerLocator[this.serverInvokers.length];
/*  92 */     for (int x = 0; x < this.serverInvokers.length; x++)
/*     */     {
/*  94 */       locators[x] = this.serverInvokers[x].getInvokerLocator();
/*     */     }
/*  96 */     return locators;
/*     */   }
/*     */ 
/*     */   public final ServerInvokerMetadata[] getServerInvokers()
/*     */   {
/* 109 */     return this.serverInvokers;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.network.NetworkNotification
 * JD-Core Version:    0.6.0
 */