/*     */ package org.jboss.remoting.samples.callback.acknowledgement;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.net.InetAddress;
/*     */ import java.net.UnknownHostException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.callback.Callback;
/*     */ import org.jboss.remoting.callback.HandleCallbackException;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ 
/*     */ public class CallbackAcknowledgeClient
/*     */ {
/*  51 */   private static String transport = "socket";
/*     */   private static String host;
/*  53 */   private static int port = 5401;
/*     */   private Client client;
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  66 */     if ((args != null) && (args.length == 2))
/*     */     {
/*  68 */       transport = args[0];
/*  69 */       port = Integer.parseInt(args[1]);
/*     */     }
/*     */     try
/*     */     {
/*  73 */       host = InetAddress.getLocalHost().getHostName();
/*     */     }
/*     */     catch (UnknownHostException e1)
/*     */     {
/*  77 */       System.err.println("cannot get local host name");
/*  78 */       return;
/*     */     }
/*  80 */     String locatorURI = transport + "://" + host + ":" + port;
/*  81 */     CallbackAcknowledgeClient acknowledgeClient = new CallbackAcknowledgeClient();
/*     */     try
/*     */     {
/*  84 */       acknowledgeClient.createRemotingClient(locatorURI);
/*     */ 
/*  86 */       acknowledgeClient.testPullCallbackAcknowledgements();
/*  87 */       acknowledgeClient.testPolledCallbackApplicationAcknowledgements();
/*  88 */       acknowledgeClient.testPolledCallbackRemotingAcknowledgements();
/*  89 */       acknowledgeClient.testPushCallbackApplicationAcknowledgements();
/*  90 */       acknowledgeClient.testPushCallbackRemotingAcknowledgements();
/*     */ 
/*  92 */       acknowledgeClient.disconnectRemotingClient();
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/*  96 */       e.printStackTrace();
/*     */     }
/*  98 */     System.out.println("done.");
/*     */   }
/*     */ 
/*     */   public void createRemotingClient(String locatorURI)
/*     */     throws Exception
/*     */   {
/* 104 */     this.client = new Client(new InvokerLocator(locatorURI));
/* 105 */     this.client.connect();
/*     */   }
/*     */ 
/*     */   public void disconnectRemotingClient()
/*     */   {
/* 111 */     if (this.client != null)
/* 112 */       this.client.disconnect();
/*     */   }
/*     */ 
/*     */   public void testPullCallbackAcknowledgements()
/*     */   {
/*     */     try
/*     */     {
/* 126 */       InvokerCallbackHandler callbackHandler = new NonAcknowledgingCallbackHandler();
/* 127 */       this.client.addListener(callbackHandler);
/*     */ 
/* 130 */       this.client.invoke("applicationAcknowledgements");
/*     */ 
/* 133 */       List callbacks = this.client.getCallbacks(callbackHandler);
/*     */ 
/* 136 */       ArrayList responses = new ArrayList(callbacks.size());
/* 137 */       Iterator it = callbacks.iterator();
/* 138 */       while (it.hasNext())
/*     */       {
/* 140 */         Callback callback = (Callback)it.next();
/* 141 */         System.out.println("received pull callback: " + callback.getParameter());
/* 142 */         responses.add(callback.getParameter() + ": acknowledged");
/*     */       }
/*     */ 
/* 146 */       this.client.acknowledgeCallbacks(callbackHandler, callbacks, responses);
/*     */ 
/* 149 */       this.client.removeListener(callbackHandler);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 153 */       System.out.println("failure: " + e.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void testPolledCallbackApplicationAcknowledgements()
/*     */   {
/*     */     try
/*     */     {
/* 170 */       InvokerCallbackHandler callbackHandler = new AcknowledgingCallbackHandler(this.client);
/* 171 */       HashMap metadata = new HashMap();
/* 172 */       metadata.put("callbackPollPeriod", "1000");
/* 173 */       this.client.addListener(callbackHandler, metadata);
/*     */ 
/* 176 */       this.client.invoke("applicationAcknowledgements");
/* 177 */       Thread.sleep(2000L);
/*     */ 
/* 180 */       this.client.removeListener(callbackHandler);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 184 */       System.out.println("failure: " + e.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void testPolledCallbackRemotingAcknowledgements()
/*     */   {
/*     */     try
/*     */     {
/* 200 */       InvokerCallbackHandler callbackHandler = new NonAcknowledgingCallbackHandler();
/* 201 */       HashMap metadata = new HashMap();
/* 202 */       metadata.put("callbackPollPeriod", "1000");
/* 203 */       this.client.addListener(callbackHandler, metadata);
/*     */ 
/* 206 */       this.client.invoke("remotingAcknowledgements");
/* 207 */       Thread.sleep(2000L);
/*     */ 
/* 210 */       this.client.removeListener(callbackHandler);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 214 */       System.out.println("failure: " + e.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void testPushCallbackApplicationAcknowledgements()
/*     */   {
/*     */     try
/*     */     {
/* 230 */       InvokerCallbackHandler callbackHandler = new AcknowledgingCallbackHandler(this.client);
/* 231 */       this.client.addListener(callbackHandler, null, null, true);
/*     */ 
/* 234 */       this.client.invoke("applicationAcknowledgements");
/*     */ 
/* 237 */       this.client.removeListener(callbackHandler);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 241 */       System.out.println("failure: " + e.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void testPushCallbackRemotingAcknowledgements()
/*     */   {
/*     */     try
/*     */     {
/* 255 */       InvokerCallbackHandler callbackHandler = new NonAcknowledgingCallbackHandler();
/* 256 */       this.client.addListener(callbackHandler, null, null, true);
/*     */ 
/* 259 */       this.client.invoke("remotingAcknowledgements");
/*     */ 
/* 262 */       this.client.removeListener(callbackHandler);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 266 */       System.out.println("failure: " + e.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   static class AcknowledgingCallbackHandler
/*     */     implements InvokerCallbackHandler
/*     */   {
/*     */     private Client client;
/*     */ 
/*     */     public AcknowledgingCallbackHandler(Client client)
/*     */     {
/* 286 */       this.client = client;
/*     */     }
/*     */ 
/*     */     public void handleCallback(Callback callback) throws HandleCallbackException
/*     */     {
/* 291 */       System.out.println("received push callback: " + callback.getParameter());
/* 292 */       Object response = callback.getParameter() + ": acknowledged";
/*     */       try
/*     */       {
/* 295 */         this.client.acknowledgeCallback(this, callback, response);
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/* 299 */         System.out.println("Unable to acknowledge callback: " + callback.getParameter());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static class NonAcknowledgingCallbackHandler
/*     */     implements InvokerCallbackHandler
/*     */   {
/*     */     public void handleCallback(Callback callback)
/*     */       throws HandleCallbackException
/*     */     {
/* 275 */       System.out.println("received push callback: " + callback.getParameter());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.callback.acknowledgement.CallbackAcknowledgeClient
 * JD-Core Version:    0.6.0
 */