/*    */ package org.jboss.remoting.samples.chat.client;
/*    */ 
/*    */ import java.awt.Dimension;
/*    */ import java.awt.Toolkit;
/*    */ import java.io.PrintStream;
/*    */ import javax.swing.UIManager;
/*    */ import org.jboss.remoting.samples.chat.utility.Debug;
/*    */ import org.jboss.remoting.samples.chat.utility.Parameters;
/*    */ 
/*    */ public class Chat extends CloseableFrame
/*    */ {
/* 21 */   boolean packFrame = false;
/*    */ 
/*    */   public Chat(String[] args)
/*    */   {
/* 26 */     for (int i = 0; i < args.length; i++)
/*    */     {
/* 28 */       System.out.println(args[i]);
/*    */     }
/* 30 */     Parameters.initParameters(args);
/*    */ 
/* 32 */     String debug = Parameters.getParameter("debug");
/* 33 */     if ((debug != null) && (debug.charAt(0) == 'y'))
/*    */     {
/* 35 */       Debug.turnOn();
/*    */     }
/*    */ 
/* 39 */     RemoteStrategy remoteStrategy = null;
/* 40 */     ChatFrame frame = null;
/*    */ 
/* 42 */     String remoteStrategyName = remoteStrategyName = Parameters.getParameter("remoteStrategy");
/* 43 */     if (remoteStrategyName == null) {
/* 44 */       remoteStrategyName = "chat.client.RemoteStrategyXmlRmi_Impl";
/*    */     }
/*    */     try
/*    */     {
/* 48 */       remoteStrategy = (RemoteStrategy)Class.forName(remoteStrategyName).newInstance();
/* 49 */       System.out.println("chat: created remote strategy: " + remoteStrategyName);
/*    */     }
/*    */     catch (Exception e) {
/* 52 */       System.out.println("chat: unable to create RemoteStrategyImpl: " + remoteStrategyName);
/* 53 */       System.out.println(e.toString());
/* 54 */       System.exit(-1);
/*    */     }
/*    */ 
/* 57 */     LocalStrategy localStrategy = new LocalStrategy(this, remoteStrategy);
/* 58 */     frame = new ChatFrame(localStrategy);
/* 59 */     frame.show();
/*    */ 
/* 63 */     if (this.packFrame) {
/* 64 */       frame.pack();
/*    */     }
/*    */     else {
/* 67 */       frame.validate();
/*    */     }
/*    */ 
/* 70 */     Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
/* 71 */     Dimension frameSize = frame.getSize();
/* 72 */     if (frameSize.height > screenSize.height) {
/* 73 */       frameSize.height = screenSize.height;
/*    */     }
/* 75 */     if (frameSize.width > screenSize.width) {
/* 76 */       frameSize.width = screenSize.width;
/*    */     }
/* 78 */     frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
/* 79 */     frame.setVisible(true);
/*    */   }
/*    */ 
/*    */   public static void main(String[] args)
/*    */   {
/*    */     try {
/* 85 */       UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
/*    */     }
/*    */     catch (Exception e) {
/* 88 */       e.printStackTrace();
/*    */     }
/* 90 */     new Chat(args);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.client.Chat
 * JD-Core Version:    0.6.0
 */