/*     */ package org.jboss.remoting.samples.chat.client;
/*     */ 
/*     */ import java.awt.Dimension;
/*     */ import java.awt.Font;
/*     */ import java.awt.GridBagConstraints;
/*     */ import java.awt.GridBagLayout;
/*     */ import java.awt.Insets;
/*     */ import java.awt.event.ActionEvent;
/*     */ import java.awt.event.WindowEvent;
/*     */ import java.io.PrintStream;
/*     */ import javax.swing.JButton;
/*     */ import javax.swing.JLabel;
/*     */ import javax.swing.JPanel;
/*     */ import org.jboss.remoting.samples.chat.exceptions.ConnectionException;
/*     */ 
/*     */ public class ChatFrame extends CloseableFrame
/*     */ {
/*     */   JPanel contentPane;
/*  45 */   JLabel statusBar = new JLabel();
/*  46 */   JLabel LeChat = new JLabel();
/*  47 */   JButton ListButton = new JButton();
/*  48 */   JButton CreateButton = new JButton();
/*  49 */   JButton ExitButton = new JButton();
/*  50 */   GridBagLayout gridBagLayout1 = new GridBagLayout();
/*     */   private ConnectionStrategy cs;
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*     */     try
/*     */     {
/*  34 */       ChatFrame frame = new ChatFrame(new DummyConnectionStrategy());
/*  35 */       frame.setDefaultCloseOperation(3);
/*  36 */       frame.show();
/*     */     }
/*     */     catch (ConnectionException ce)
/*     */     {
/*  40 */       System.out.println("unable to create chat frame");
/*     */     }
/*     */   }
/*     */ 
/*     */   public ChatFrame(ConnectionStrategy cs)
/*     */   {
/*  56 */     enableEvents(64L);
/*  57 */     this.cs = cs;
/*     */     try {
/*  59 */       jbInit();
/*     */     }
/*     */     catch (Exception e) {
/*  62 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void jbInit() throws Exception {
/*  67 */     this.contentPane = ((JPanel)getContentPane());
/*  68 */     this.contentPane.setLayout(this.gridBagLayout1);
/*  69 */     setSize(new Dimension(400, 300));
/*  70 */     setTitle("Le Chat");
/*  71 */     this.statusBar.setText(" ");
/*  72 */     this.LeChat.setFont(new Font("Serif", 1, 36));
/*  73 */     this.LeChat.setHorizontalAlignment(0);
/*  74 */     this.LeChat.setHorizontalTextPosition(0);
/*  75 */     this.LeChat.setText("Le Chat");
/*  76 */     this.ListButton.setFont(new Font("SansSerif", 1, 14));
/*  77 */     this.ListButton.setText("List");
/*  78 */     this.ListButton.addActionListener(new ChatFrame_ListButton_actionAdapter(this));
/*  79 */     this.CreateButton.setFont(new Font("SansSerif", 1, 14));
/*  80 */     this.CreateButton.setText("Create");
/*  81 */     this.CreateButton.addActionListener(new ChatFrame_CreateButton_actionAdapter(this));
/*  82 */     this.ExitButton.setFont(new Font("SansSerif", 1, 14));
/*  83 */     this.ExitButton.setText("Exit");
/*  84 */     this.ExitButton.addActionListener(new ChatFrame_ExitButton_actionAdapter(this));
/*     */ 
/*  86 */     this.contentPane.add(this.statusBar, new GridBagConstraints(0, 2, 3, 1, 0.0D, 0.0D, 17, 0, new Insets(80, 0, 0, 0), 397, 0));
/*     */ 
/*  88 */     this.contentPane.add(this.LeChat, new GridBagConstraints(0, 0, 3, 1, 0.0D, 0.0D, 17, 0, new Insets(106, 80, 0, 85), 111, -10));
/*     */ 
/*  90 */     this.contentPane.add(this.ListButton, new GridBagConstraints(0, 1, 1, 1, 0.0D, 0.0D, 10, 0, new Insets(38, 57, 0, 0), 14, -4));
/*     */ 
/*  92 */     this.contentPane.add(this.ExitButton, new GridBagConstraints(2, 1, 1, 1, 0.0D, 0.0D, 10, 0, new Insets(36, 24, 0, 64), 12, -4));
/*     */ 
/*  94 */     this.contentPane.add(this.CreateButton, new GridBagConstraints(1, 1, 1, 1, 0.0D, 0.0D, 10, 0, new Insets(38, 24, 0, 0), 4, -4));
/*     */ 
/*  97 */     center();
/*  98 */     pack();
/*     */   }
/*     */ 
/*     */   protected void processWindowEvent(WindowEvent e)
/*     */   {
/* 103 */     super.processWindowEvent(e);
/* 104 */     if (e.getID() == 201)
/* 105 */       System.exit(0);
/*     */   }
/*     */ 
/*     */   void ListButton_actionPerformed(ActionEvent e)
/*     */   {
/*     */     try
/*     */     {
/* 112 */       this.cs.list();
/*     */     }
/*     */     catch (ConnectionException ce)
/*     */     {
/* 116 */       System.out.println("list button catches exception:");
/* 117 */       System.out.println(ce);
/*     */     }
/*     */   }
/*     */ 
/*     */   void CreateButton_actionPerformed(ActionEvent e)
/*     */   {
/*     */     try {
/* 124 */       this.cs.create();
/*     */     }
/*     */     catch (ConnectionException ce)
/*     */     {
/* 128 */       System.out.println("create button catches exception:");
/* 129 */       System.out.println(ce);
/*     */     }
/*     */   }
/*     */ 
/*     */   void ExitButton_actionPerformed(ActionEvent e) {
/* 134 */     TalkFrame.exit();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.client.ChatFrame
 * JD-Core Version:    0.6.0
 */