/*     */ package org.jboss.remoting.samples.chat.client;
/*     */ 
/*     */ import java.awt.Container;
/*     */ import java.awt.Dimension;
/*     */ import java.awt.Font;
/*     */ import java.awt.GridBagConstraints;
/*     */ import java.awt.GridBagLayout;
/*     */ import java.awt.Insets;
/*     */ import java.awt.event.ActionEvent;
/*     */ import java.io.PrintStream;
/*     */ import java.util.ArrayList;
/*     */ import javax.swing.JButton;
/*     */ import javax.swing.JList;
/*     */ import javax.swing.JScrollPane;
/*     */ import javax.swing.JViewport;
/*     */ import javax.swing.ListModel;
/*     */ import org.jboss.remoting.samples.chat.exceptions.ConnectionException;
/*     */ import org.jboss.remoting.samples.chat.exceptions.ListConnectionException;
/*     */ 
/*     */ public class ListFrame extends CloseableFrame
/*     */ {
/*  35 */   JButton joinButton = new JButton();
/*  36 */   JButton getInfoButton = new JButton();
/*  37 */   JButton closeButton = new JButton();
/*  38 */   JButton exitButton = new JButton();
/*     */   private ListConnectionStrategy lcs;
/*     */   private ArrayList chatRoomInfo;
/*  42 */   JScrollPane jScrollPane1 = new JScrollPane();
/*  43 */   JList chatRoomList = new JList();
/*  44 */   GridBagLayout gridBagLayout1 = new GridBagLayout();
/*     */ 
/*     */   public ListFrame(ListConnectionStrategy lcs, ArrayList chatRoomInfo, Closeable parent)
/*     */   {
/*  52 */     super(parent);
/*  53 */     this.chatRoomInfo = chatRoomInfo;
/*  54 */     this.lcs = lcs;
/*     */     try
/*     */     {
/*  57 */       jbInit();
/*     */     }
/*     */     catch (Exception e) {
/*  60 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void jbInit() throws Exception
/*     */   {
/*  66 */     getContentPane().setLayout(this.gridBagLayout1);
/*  67 */     this.joinButton.setFont(new Font("SansSerif", 1, 12));
/*  68 */     this.joinButton.setMaximumSize(new Dimension(77, 25));
/*  69 */     this.joinButton.setMinimumSize(new Dimension(77, 25));
/*  70 */     this.joinButton.setText("Join");
/*  71 */     this.joinButton.addActionListener(new ListFrame_joinButton_actionAdapter(this));
/*  72 */     this.getInfoButton.setText("Get info");
/*  73 */     this.getInfoButton.addActionListener(new ListFrame_getInfoButton_actionAdapter(this));
/*  74 */     this.getInfoButton.setFont(new Font("SansSerif", 1, 12));
/*  75 */     this.getInfoButton.setMinimumSize(new Dimension(77, 25));
/*  76 */     this.closeButton.setText("Close");
/*  77 */     this.closeButton.addActionListener(new ListFrame_closeButton_actionAdapter(this));
/*  78 */     this.closeButton.setFont(new Font("SansSerif", 1, 12));
/*  79 */     this.closeButton.setMaximumSize(new Dimension(77, 25));
/*  80 */     this.closeButton.setMinimumSize(new Dimension(77, 25));
/*  81 */     this.closeButton.setFocusPainted(true);
/*  82 */     this.exitButton.setText("Exit");
/*  83 */     this.exitButton.addActionListener(new ListFrame_exitButton_actionAdapter(this));
/*  84 */     this.exitButton.setFont(new Font("SansSerif", 1, 12));
/*  85 */     this.exitButton.setMaximumSize(new Dimension(77, 25));
/*  86 */     this.exitButton.setMinimumSize(new Dimension(77, 25));
/*  87 */     setTitle("Current chat rooms");
/*     */ 
/*  89 */     this.chatRoomList = makeChatRoomList(this.chatRoomInfo);
/*     */ 
/*  91 */     this.chatRoomList.setSelectionMode(0);
/*  92 */     getContentPane().add(this.exitButton, new GridBagConstraints(3, 1, 1, 1, 0.0D, 0.0D, 10, 0, new Insets(36, 7, 22, 11), 40, 0));
/*     */ 
/*  94 */     getContentPane().add(this.closeButton, new GridBagConstraints(2, 1, 1, 1, 0.0D, 0.0D, 10, 0, new Insets(35, 21, 22, 0), 16, 0));
/*     */ 
/*  96 */     getContentPane().add(this.joinButton, new GridBagConstraints(0, 1, 1, 1, 0.0D, 0.0D, 10, 0, new Insets(36, 9, 22, 0), 32, 0));
/*     */ 
/*  98 */     getContentPane().add(this.getInfoButton, new GridBagConstraints(1, 1, 1, 1, 0.0D, 0.0D, 10, 0, new Insets(33, 6, 22, 0), 0, 4));
/*     */ 
/* 100 */     getContentPane().add(this.jScrollPane1, new GridBagConstraints(1, 0, 2, 1, 1.0D, 1.0D, 10, 1, new Insets(57, 21, 0, 12), -106, 27));
/*     */ 
/* 102 */     this.jScrollPane1.getViewport().add(this.chatRoomList, null);
/*     */ 
/* 104 */     pack();
/* 105 */     center();
/*     */   }
/*     */ 
/*     */   protected JList makeChatRoomList(ArrayList chatRoomInfo)
/*     */   {
/* 110 */     String[] chats = new String[chatRoomInfo.size()];
/*     */ 
/* 112 */     for (int i = 0; i < chatRoomInfo.size(); i++)
/*     */     {
/* 114 */       chats[i] = ((ChatInfo)chatRoomInfo.get(i)).get_description();
/* 115 */       if (chats[i].equals("")) {
/* 116 */         chats[i] = "*no name*";
/*     */       }
/*     */     }
/* 119 */     JList chatList = new JList(chats);
/* 120 */     chatList.setSelectedIndex(0);
/*     */ 
/* 122 */     return chatList;
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*     */     try
/*     */     {
/* 129 */       ChatMember chatMember0 = new ChatMember();
/* 130 */       ChatMember chatMember1 = new ChatMember();
/* 131 */       ChatMember chatMember2 = new ChatMember();
/* 132 */       chatMember0.set_name("m1");
/* 133 */       chatMember1.set_name("m2");
/* 134 */       chatMember2.set_name("m3");
/* 135 */       ChatInfo chatInfo0 = new ChatInfo();
/* 136 */       ChatInfo chatInfo1 = new ChatInfo();
/* 137 */       ChatInfo chatInfo2 = new ChatInfo();
/* 138 */       chatInfo0.set_currentMembers(0);
/* 139 */       chatInfo0.set_description("Lord of the Rings");
/* 140 */       chatInfo0.set_owner(chatMember0);
/* 141 */       chatInfo1.set_currentMembers(1);
/* 142 */       chatInfo1.set_description("Cat's Cradle");
/* 143 */       chatInfo1.set_owner(chatMember1);
/* 144 */       chatInfo2.set_currentMembers(2);
/* 145 */       chatInfo2.set_description("Siddhartha");
/* 146 */       chatInfo2.set_owner(chatMember2);
/*     */ 
/* 148 */       ArrayList chats = new ArrayList(3);
/* 149 */       chats.add(chatInfo0);
/* 150 */       chats.add(chatInfo1);
/* 151 */       chats.add(chatInfo2);
/*     */ 
/* 157 */       ListFrame frame = new ListFrame(new DummyListConnectionStrategy(), chats, null);
/*     */ 
/* 162 */       frame.show();
/*     */     }
/*     */     catch (ListConnectionException lce) {
/* 165 */       System.out.println("ListFrameTest: unable to create chat frame");
/*     */     }
/*     */   }
/*     */ 
/*     */   void joinButton_actionPerformed(ActionEvent e)
/*     */   {
/*     */     try
/*     */     {
/* 173 */       notifyOnClose(this);
/* 174 */       if (this.chatRoomList.getModel().getSize() <= this.chatRoomList.getSelectedIndex())
/*     */       {
/* 176 */         System.out.println("there are no chat rooms to join");
/* 177 */         return;
/*     */       }
/* 179 */       ChatInfo chatInfo = (ChatInfo)this.chatRoomInfo.get(this.chatRoomList.getSelectedIndex());
/* 180 */       this.lcs.getId(chatInfo);
/*     */     }
/*     */     catch (ConnectionException ce)
/*     */     {
/* 184 */       System.out.println("Join button catches exception:");
/* 185 */       System.out.println(ce);
/*     */     }
/*     */   }
/*     */ 
/*     */   void getInfoButton_actionPerformed(ActionEvent e)
/*     */   {
/*     */     try {
/* 192 */       notifyOnClose(this);
/* 193 */       if (this.chatRoomList.getModel().getSize() <= this.chatRoomList.getSelectedIndex()) {
/* 194 */         System.out.println("there are no chat rooms");
/* 195 */         return;
/*     */       }
/*     */ 
/* 198 */       this.lcs.getInfo(this.chatRoomInfo, this.chatRoomList.getSelectedIndex());
/*     */     }
/*     */     catch (ListConnectionException lce)
/*     */     {
/* 202 */       System.out.println("Info button catches exception:");
/* 203 */       System.out.println(lce);
/*     */     }
/*     */   }
/*     */ 
/*     */   void closeButton_actionPerformed(ActionEvent e) {
/* 208 */     notifyOnClose(this);
/*     */   }
/*     */ 
/*     */   void exitButton_actionPerformed(ActionEvent e) {
/* 212 */     System.exit(0);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.client.ListFrame
 * JD-Core Version:    0.6.0
 */