/*    */ package org.jboss.remoting.samples.chat.server;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.remoting.callback.Callback;
/*    */ import org.jboss.remoting.callback.HandleCallbackException;
/*    */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*    */ import org.jboss.remoting.invocation.RemoteInvocation;
/*    */ import org.jboss.remoting.samples.chat.utility.ReadWriteArrayList;
/*    */ import org.jboss.remoting.samples.chat.utility.ShutDownGate;
/*    */ 
/*    */ public class CallbackThread extends Thread
/*    */ {
/* 24 */   protected static final Logger log = Logger.getLogger(CallbackThread.class);
/*    */   private InvokerCallbackHandler callbackHandler;
/*    */   private ShutDownGate shutDownGate;
/*    */   private boolean memberLeaving;
/*    */   private ReadWriteArrayList messages;
/*    */   private int backChatSize;
/*    */ 
/*    */   public CallbackThread(InvokerCallbackHandler callbackHandler, ShutDownGate shutDownGate, ReadWriteArrayList messages)
/*    */   {
/* 36 */     this.callbackHandler = callbackHandler;
/* 37 */     this.memberLeaving = false;
/* 38 */     this.shutDownGate = shutDownGate;
/* 39 */     this.messages = messages;
/*    */ 
/* 41 */     this.backChatSize = messages.size();
/* 42 */     ArrayList backChat = new ArrayList(this.backChatSize);
/* 43 */     backChat = messages.copy();
/* 44 */     RemoteInvocation invocation = new RemoteInvocation("sendMultiple", new Object[] { backChat });
/* 45 */     Callback callback = new Callback(invocation);
/*    */     try
/*    */     {
/* 49 */       callbackHandler.handleCallback(callback);
/*    */     }
/*    */     catch (HandleCallbackException e)
/*    */     {
/* 53 */       log.error(e);
/*    */     }
/*    */   }
/*    */ 
/*    */   public void setMemberLeaving()
/*    */   {
/* 59 */     this.memberLeaving = true;
/*    */   }
/*    */ 
/*    */   public void run()
/*    */   {
/* 64 */     int i = this.backChatSize;
/*    */ 
/* 66 */     while ((!this.shutDownGate.isShuttingDown()) && (!this.memberLeaving))
/*    */     {
/* 68 */       RemoteInvocation invocation = new RemoteInvocation("send", new Object[] { this.messages.get(i) });
/* 69 */       Callback callback = new Callback(invocation);
/*    */       try
/*    */       {
/* 73 */         this.callbackHandler.handleCallback(callback);
/*    */       }
/*    */       catch (HandleCallbackException e)
/*    */       {
/* 77 */         log.error(e);
/*    */       }
/*    */ 
/* 80 */       i++;
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.server.CallbackThread
 * JD-Core Version:    0.6.0
 */