/*    */ package org.jboss.remoting.samples.chat.server;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.ObjectInputStream;
/*    */ import java.io.Serializable;
/*    */ import java.util.ArrayList;
/*    */ import java.util.Collection;
/*    */ import java.util.Collections;
/*    */ import java.util.HashSet;
/*    */ import java.util.Hashtable;
/*    */ import java.util.Iterator;
/*    */ import org.jboss.remoting.samples.chat.client.ChatInfo;
/*    */ import org.jboss.remoting.samples.chat.client.ChatMember;
/*    */ import org.jboss.remoting.samples.chat.exceptions.NameInUseException;
/*    */ import org.jboss.remoting.samples.chat.utility.ReadWriteArrayList;
/*    */ 
/*    */ public class ExtendedChatInfo
/*    */   implements Serializable
/*    */ {
/*    */   private static final long serialVersionUID = 3L;
/*    */   private ChatInfo chatInfo;
/*    */   private ReadWriteArrayList messages;
/*    */   private Collection members;
/*    */   private transient Hashtable threadMap;
/*    */   private transient Collection chatReceivers;
/*    */ 
/*    */   public ExtendedChatInfo(ChatInfo chatInfo)
/*    */   {
/* 38 */     this.chatInfo = chatInfo;
/* 39 */     this.messages = new ReadWriteArrayList();
/* 40 */     this.members = Collections.synchronizedCollection(new HashSet());
/* 41 */     this.threadMap = new Hashtable();
/* 42 */     this.chatReceivers = Collections.synchronizedCollection(new HashSet());
/*    */   }
/*    */ 
/*    */   private void readObject(ObjectInputStream in)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 48 */     in.defaultReadObject();
/* 49 */     this.threadMap = new Hashtable();
/* 50 */     this.chatReceivers = Collections.synchronizedCollection(new HashSet());
/*    */   }
/*    */ 
/*    */   public ChatInfo getChatInfo() {
/* 54 */     return this.chatInfo;
/*    */   }
/*    */   public Collection getMembers() {
/* 57 */     return this.members;
/*    */   }
/*    */   public ReadWriteArrayList getMessages() {
/* 60 */     return this.messages;
/*    */   }
/*    */   public Collection getChatReceivers() {
/* 63 */     return this.chatReceivers;
/*    */   }
/*    */   public CallbackThread getChatReceiverThread(ChatMember member) {
/* 66 */     return (CallbackThread)this.threadMap.get(member.get_name());
/*    */   }
/*    */ 
/*    */   public void addMember(ChatMember member) throws NameInUseException
/*    */   {
/* 71 */     String name = member.get_name();
/*    */ 
/* 73 */     if (this.members.contains(name)) {
/* 74 */       throw new NameInUseException();
/*    */     }
/* 76 */     this.members.add(name);
/*    */   }
/*    */ 
/*    */   public void removeMember(ChatMember member)
/*    */   {
/* 81 */     String name = member.get_name();
/* 82 */     this.threadMap.remove(name);
/* 83 */     this.members.remove(name);
/*    */   }
/*    */ 
/*    */   public void addMessages(ArrayList messages)
/*    */   {
/* 89 */     Iterator it = messages.iterator();
/* 90 */     while (it.hasNext())
/*    */     {
/* 92 */       this.messages.add(it.next());
/*    */     }
/*    */   }
/*    */ 
/*    */   public void addMessage(String message)
/*    */   {
/* 98 */     this.messages.add(message);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.server.ExtendedChatInfo
 * JD-Core Version:    0.6.0
 */