/*     */ package org.jboss.remoting.samples.chat.utility;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.servlet.ServletConfig;
/*     */ 
/*     */ public class Parameters
/*     */ {
/*  30 */   static Hashtable parameterValues = new Hashtable();
/*  31 */   static Hashtable primaryParameterValues = new Hashtable();
/*  32 */   static Hashtable defaultParameterValues = new Hashtable();
/*     */ 
/*     */   public static void initParameters(String[] args)
/*     */   {
/*  52 */     for (int i = 0; i < args.length; i++)
/*     */     {
/*  54 */       int mark = args[i].indexOf('=');
/*  55 */       if (mark < 0)
/*     */         continue;
/*  57 */       primaryParameterValues.put(args[i].substring(0, mark), args[i].substring(mark + 1));
/*     */     }
/*     */ 
/*  61 */     getSecondaryParameterSources();
/*     */   }
/*     */ 
/*     */   public static void initParameters(ServletConfig servletConfig)
/*     */   {
/*  73 */     Enumeration e = servletConfig.getInitParameterNames();
/*     */ 
/*  75 */     while (e.hasMoreElements())
/*     */     {
/*  77 */       String key = (String)e.nextElement();
/*  78 */       primaryParameterValues.put(key, servletConfig.getInitParameter(key));
/*     */     }
/*     */ 
/*  81 */     getSecondaryParameterSources();
/*     */   }
/*     */ 
/*     */   private static void getSecondaryParameterSources()
/*     */   {
/*  96 */     String configurationFilePath = "chat.conf";
/*     */ 
/*  98 */     if (primaryParameterValues.containsKey("chat.conf")) {
/*  99 */       configurationFilePath = (String)primaryParameterValues.get("chat.conf");
/*     */     }
/* 101 */     File configurationFile = new File(configurationFilePath);
/*     */ 
/* 104 */     if (configurationFile.exists())
/*     */     {
/*     */       try
/*     */       {
/* 108 */         FileInputStream fis = new FileInputStream(configurationFile);
/* 109 */         Properties properties = new Properties();
/* 110 */         properties.load(fis);
/* 111 */         Enumeration e = properties.propertyNames();
/*     */ 
/* 113 */         while (e.hasMoreElements())
/*     */         {
/* 115 */           String key = (String)e.nextElement();
/* 116 */           parameterValues.put(key, properties.getProperty(key));
/* 117 */           System.out.println(key + ":" + properties.getProperty(key));
/*     */         }
/*     */       }
/*     */       catch (FileNotFoundException fnfe)
/*     */       {
/* 122 */         System.err.println("configuration file not found: " + configurationFilePath);
/* 123 */         System.err.println("using default properties");
/*     */       }
/*     */       catch (IOException ioe)
/*     */       {
/* 127 */         System.err.println("error reading configuration file: " + configurationFilePath);
/* 128 */         System.err.println("using default properties");
/* 129 */         System.out.println(ioe.getMessage());
/*     */       }
/*     */ 
/* 132 */       String debug = getParameter("debug");
/*     */ 
/* 134 */       if (debug.charAt(0) == 'y')
/*     */       {
/* 136 */         System.out.println("properties:");
/* 137 */         Iterator it = parameterValues.keySet().iterator();
/* 138 */         while (it.hasNext())
/*     */         {
/* 140 */           String key = (String)it.next();
/* 141 */           System.out.println("  " + key + ": " + parameterValues.get(key));
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 147 */     Iterator it = primaryParameterValues.keySet().iterator();
/* 148 */     while (it.hasNext())
/*     */     {
/* 150 */       Object key = it.next();
/* 151 */       parameterValues.put(key, primaryParameterValues.get(key));
/*     */     }
/*     */   }
/*     */ 
/*     */   public static String getParameter(String name)
/*     */   {
/* 166 */     return getParameter(name, null);
/*     */   }
/*     */ 
/*     */   public static String getParameter(String name, String defaultValue)
/*     */   {
/* 179 */     String value = null;
/*     */ 
/* 181 */     value = (String)parameterValues.get(name);
/*     */ 
/* 183 */     if (value == null) {
/* 184 */       value = System.getProperty(name);
/*     */     }
/* 186 */     if (value == null) {
/* 187 */       value = (String)defaultParameterValues.get(name);
/*     */     }
/* 189 */     if (value == null) {
/* 190 */       value = defaultValue;
/*     */     }
/* 192 */     return value;
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 200 */     initParameters(args);
/* 201 */     System.out.println("clientUri: " + getParameter("clientUri"));
/* 202 */     System.out.println("serverUri: " + getParameter("serverUri"));
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  36 */     defaultParameterValues.put("serverUri", "http://localhost:8000");
/*  37 */     defaultParameterValues.put("clientUri", "http://localhost:8002");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.utility.Parameters
 * JD-Core Version:    0.6.0
 */