/*    */ package org.jboss.remoting.samples.chat.utility;
/*    */ 
/*    */ import java.io.PrintStream;
/*    */ import java.io.Serializable;
/*    */ import org.jboss.remoting.samples.chat.exceptions.ShuttingDownException;
/*    */ 
/*    */ public class ShutDownGate
/*    */   implements Serializable
/*    */ {
/*    */   private static final long serialVersionUID = 2L;
/*    */   private int numberOfUsers;
/*    */   private boolean shuttingDown;
/*    */ 
/*    */   public ShutDownGate()
/*    */   {
/* 25 */     reset();
/*    */   }
/*    */ 
/*    */   public void reset()
/*    */   {
/* 30 */     this.numberOfUsers = 0;
/* 31 */     this.shuttingDown = false;
/*    */   }
/*    */ 
/*    */   public synchronized void check() throws ShuttingDownException
/*    */   {
/* 36 */     if (this.shuttingDown == true)
/* 37 */       throw new ShuttingDownException();
/*    */   }
/*    */ 
/*    */   public synchronized boolean isShuttingDown()
/*    */   {
/* 42 */     return this.shuttingDown;
/*    */   }
/*    */ 
/*    */   public synchronized void enter() throws ShuttingDownException
/*    */   {
/* 47 */     if (this.shuttingDown == true)
/* 48 */       throw new ShuttingDownException();
/* 49 */     this.numberOfUsers += 1;
/*    */   }
/*    */ 
/*    */   public synchronized void leave()
/*    */   {
/* 54 */     if (this.numberOfUsers <= 0) {
/* 55 */       throw new Error("ShutDownGate: number of Users <= 0");
/*    */     }
/* 57 */     if (--this.numberOfUsers == 0)
/* 58 */       notifyAll();
/*    */   }
/*    */ 
/*    */   public synchronized void shutDown()
/*    */   {
/* 63 */     this.shuttingDown = true;
/*    */ 
/* 65 */     while (this.numberOfUsers > 0)
/*    */       try {
/* 67 */         System.out.println("shutdown(): numberOfUsers == " + this.numberOfUsers);
/* 68 */         wait();
/*    */       }
/*    */       catch (InterruptedException ie)
/*    */       {
/*    */       }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.utility.ShutDownGate
 * JD-Core Version:    0.6.0
 */