/*     */ package org.jboss.remoting.samples.multiplex;
/*     */ 
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.Socket;
/*     */ import org.jboss.remoting.transport.multiplex.VirtualServerSocket;
/*     */ import org.jboss.remoting.transport.multiplex.VirtualSocket;
/*     */ 
/*     */ public class PrimeScenarioExampleClient
/*     */ {
/*     */   public void runPrimeScenario()
/*     */   {
/*     */     try
/*     */     {
/*  50 */       Socket v1 = new VirtualSocket("localhost", 5555);
/*     */ 
/*  53 */       new AsynchronousThread(v1).start();
/*     */ 
/*  56 */       ObjectOutputStream oos = new ObjectOutputStream(v1.getOutputStream());
/*  57 */       ObjectInputStream ois = new ObjectInputStream(v1.getInputStream());
/*  58 */       oos.writeObject(new Integer(3));
/*  59 */       Integer i1 = (Integer)ois.readObject();
/*  60 */       System.out.println("synch: " + i1);
/*  61 */       v1.close();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  65 */       e.printStackTrace();
/*  66 */       System.exit(1);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 110 */     new PrimeScenarioExampleClient().runPrimeScenario();
/*     */   }
/*     */ 
/*     */   class AsynchronousThread extends Thread
/*     */   {
/*     */     private Socket virtualSocket;
/*     */ 
/*     */     AsynchronousThread(Socket virtualSocket)
/*     */     {
/*  77 */       this.virtualSocket = virtualSocket;
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       try
/*     */       {
/*  85 */         ServerSocket serverSocket = new VirtualServerSocket(this.virtualSocket.getLocalPort());
/*     */ 
/*  88 */         serverSocket.setSoTimeout(10000);
/*  89 */         Socket v4 = serverSocket.accept();
/*  90 */         ObjectInputStream ois = new ObjectInputStream(v4.getInputStream());
/*     */ 
/*  93 */         v4.setSoTimeout(10000);
/*  94 */         Object o = ois.readObject();
/*  95 */         System.out.println("asynch: " + (Integer)o);
/*  96 */         serverSocket.close();
/*  97 */         v4.close();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 101 */         e.printStackTrace();
/* 102 */         System.exit(1);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.multiplex.PrimeScenarioExampleClient
 * JD-Core Version:    0.6.0
 */