/*    */ package org.jboss.remoting.samples.transporter.clustered.client;
/*    */ 
/*    */ import java.io.PrintStream;
/*    */ import org.jboss.remoting.samples.transporter.basic.Address;
/*    */ import org.jboss.remoting.samples.transporter.basic.Customer;
/*    */ import org.jboss.remoting.samples.transporter.basic.CustomerProcessor;
/*    */ import org.jboss.remoting.samples.transporter.clustered.server.SocketServer;
/*    */ import org.jboss.remoting.transporter.TransporterClient;
/*    */ 
/*    */ public class Client
/*    */ {
/* 36 */   private String locatorURI = SocketServer.locatorURI;
/*    */ 
/* 38 */   private CustomerProcessor customerProcessor = null;
/*    */ 
/*    */   public void makeClientCall() throws Exception
/*    */   {
/* 42 */     Customer customer = createCustomer();
/*    */ 
/* 44 */     System.out.println("Customer to be processed: " + customer);
/* 45 */     Customer processedCustomer = this.customerProcessor.processCustomer(customer);
/* 46 */     System.out.println("Customer is now: " + processedCustomer);
/*    */   }
/*    */ 
/*    */   public void getCustomerProcessor()
/*    */     throws Exception
/*    */   {
/* 53 */     this.customerProcessor = ((CustomerProcessor)TransporterClient.createTransporterClient(this.locatorURI, CustomerProcessor.class, true));
/*    */   }
/*    */ 
/*    */   private Customer createCustomer()
/*    */   {
/* 58 */     Customer cust = new Customer();
/* 59 */     cust.setFirstName("Bob");
/* 60 */     cust.setLastName("Smith");
/* 61 */     Address addr = new Address();
/* 62 */     addr.setStreet("101 Oak Stree");
/* 63 */     addr.setCity("Atlanta");
/* 64 */     addr.setZip(30249);
/* 65 */     cust.setAddr(addr);
/*    */ 
/* 67 */     return cust;
/*    */   }
/*    */ 
/*    */   public static void main(String[] args)
/*    */   {
/* 72 */     Client client = new Client();
/*    */     try
/*    */     {
/* 75 */       client.getCustomerProcessor();
/*    */       while (true)
/*    */       {
/*    */         try
/*    */         {
/* 80 */           client.makeClientCall();
/* 81 */           Thread.currentThread(); Thread.sleep(5000L);
/*    */ 
/* 86 */           continue;
/*    */         }
/*    */         catch (Exception e)
/*    */         {
/* 85 */           e.printStackTrace();
/*    */         }
/*    */       }
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 91 */       e.printStackTrace();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.transporter.clustered.client.Client
 * JD-Core Version:    0.6.0
 */