/*    */ package org.jboss.remoting.samples.transporter.proxy.client;
/*    */ 
/*    */ import java.io.PrintStream;
/*    */ import org.jboss.remoting.samples.transporter.proxy.Address;
/*    */ import org.jboss.remoting.samples.transporter.proxy.Customer;
/*    */ import org.jboss.remoting.samples.transporter.proxy.CustomerProcessor;
/*    */ import org.jboss.remoting.samples.transporter.proxy.ICustomer;
/*    */ import org.jboss.remoting.transporter.TransporterClient;
/*    */ 
/*    */ public class Client
/*    */ {
/* 36 */   private String locatorURI = "socket://localhost:5400";
/*    */ 
/*    */   public void makeClientCall() throws Exception
/*    */   {
/* 40 */     Customer customer = createCustomer();
/*    */ 
/* 42 */     CustomerProcessor customerProcessor = (CustomerProcessor)TransporterClient.createTransporterClient(this.locatorURI, CustomerProcessor.class);
/*    */ 
/* 44 */     System.out.println("Customer to be processed: " + customer);
/* 45 */     ICustomer processedCustomer = customerProcessor.processCustomer(customer);
/*    */ 
/* 50 */     System.out.println("Customer is now: " + processedCustomer);
/*    */ 
/* 52 */     TransporterClient.destroyTransporterClient(customerProcessor);
/*    */   }
/*    */ 
/*    */   private Customer createCustomer()
/*    */   {
/* 59 */     Customer cust = new Customer();
/* 60 */     cust.setFirstName("Bob");
/* 61 */     cust.setLastName("Smith");
/* 62 */     Address addr = new Address();
/* 63 */     addr.setStreet("101 Oak Street");
/* 64 */     addr.setCity("Atlanta");
/* 65 */     addr.setState("GA");
/* 66 */     addr.setZip(30249);
/* 67 */     cust.setAddr(addr);
/*    */ 
/* 69 */     return cust;
/*    */   }
/*    */ 
/*    */   public static void main(String[] args)
/*    */   {
/* 74 */     Client client = new Client();
/*    */     try
/*    */     {
/* 77 */       client.makeClientCall();
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 81 */       e.printStackTrace();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.transporter.proxy.client.Client
 * JD-Core Version:    0.6.0
 */