package org.jboss.remoting.security;

import java.io.IOException;
import java.net.URL;
import java.security.Provider;
import java.security.SecureRandom;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;

public abstract interface SSLSocketBuilderMBean
{
  public abstract void setUseSSLServerSocketFactory(boolean paramBoolean);

  public abstract boolean getUseSSLServerSocketFactory();

  public abstract void setUseSSLSocketFactory(boolean paramBoolean);

  public abstract boolean getUseSSLSocketFactory();

  public abstract ServerSocketFactory createSSLServerSocketFactory()
    throws IOException;

  public abstract ServerSocketFactory createSSLServerSocketFactory(CustomSSLServerSocketFactory paramCustomSSLServerSocketFactory)
    throws IOException;

  public abstract SocketFactory createSSLSocketFactory()
    throws IOException;

  public abstract SocketFactory createSSLSocketFactory(CustomSSLSocketFactory paramCustomSSLSocketFactory)
    throws IOException;

  public abstract SSLContext getServerSocketFactorySSLContext();

  public abstract SSLContext getSocketFactorySSLContext();

  public abstract String getSecureSocketProtocol();

  public abstract void setSecureSocketProtocol(String paramString);

  public abstract Provider getProvider();

  public abstract void setProvider(Provider paramProvider);

  public abstract String getProviderName();

  public abstract void setProviderName(String paramString);

  public abstract SecureRandom getSecureRandom();

  public abstract void setSecureRandom(SecureRandom paramSecureRandom);

  public abstract URL getKeyStore();

  public abstract String getKeyStoreURL();

  public abstract void setKeyStoreURL(String paramString);

  public abstract void setKeyStore(URL paramURL);

  public abstract String getKeyStoreType();

  public abstract void setKeyStoreType(String paramString);

  public abstract String getKeyStoreAlgorithm();

  public abstract void setKeyStoreAlgorithm(String paramString);

  public abstract void setKeyStorePassword(String paramString);

  public abstract URL getTrustStore();

  public abstract String getTrustStoreURL();

  public abstract void setTrustStoreURL(String paramString);

  public abstract void setTrustStore(URL paramURL);

  public abstract String getTrustStoreType();

  public abstract void setTrustStoreType(String paramString);

  public abstract String getTrustStoreAlgorithm();

  public abstract void setTrustStoreAlgorithm(String paramString);

  public abstract void setTrustStorePassword(String paramString);

  public abstract String getKeyAlias();

  public abstract void setKeyAlias(String paramString);

  public abstract void setKeyPassword(String paramString);

  public abstract boolean isSocketUseClientMode();

  public abstract boolean isServerSocketUseClientMode();

  public abstract void setSocketUseClientMode(boolean paramBoolean);

  public abstract void setServerSocketUseClientMode(boolean paramBoolean);

  public abstract boolean isClientAuthModeNone();

  public abstract boolean isClientAuthModeWant();

  public abstract boolean isClientAuthModeNeed();

  public abstract String getClientAuthMode();

  public abstract void setClientAuthMode(String paramString);

  public abstract boolean isServerAuthMode();

  public abstract void setServerAuthMode(boolean paramBoolean);

  public abstract Object clone();

  public abstract void create()
    throws Exception;

  public abstract void start()
    throws Exception;

  public abstract void stop();

  public abstract void destroy();
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.security.SSLSocketBuilderMBean
 * JD-Core Version:    0.6.0
 */