/*    */ package org.jboss.remoting.serialization;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.io.ObjectInputStream;
/*    */ import java.io.ObjectOutputStream;
/*    */ import java.io.OutputStream;
/*    */ import org.jboss.remoting.Version;
/*    */ 
/*    */ public abstract class SerializationManager
/*    */ {
/*    */   public ObjectInputStream createRegularInput(InputStream input)
/*    */     throws IOException
/*    */   {
/* 46 */     return createInput(input, Thread.currentThread().getContextClassLoader());
/*    */   }
/*    */ 
/*    */   public abstract ObjectInputStream createInput(InputStream paramInputStream, ClassLoader paramClassLoader) throws IOException;
/*    */ 
/*    */   public abstract ObjectOutputStream createOutput(OutputStream paramOutputStream) throws IOException;
/*    */ 
/*    */   public abstract IMarshalledValue createdMarshalledValue(Object paramObject) throws IOException;
/*    */ 
/*    */   public void sendObject(ObjectOutputStream output, Object dataObject) throws IOException
/*    */   {
/* 60 */     int version = Version.getDefaultVersion();
/* 61 */     sendObject(output, dataObject, version);
/*    */   }
/*    */ 
/*    */   public abstract void sendObject(ObjectOutputStream paramObjectOutputStream, Object paramObject, int paramInt)
/*    */     throws IOException;
/*    */ 
/*    */   public abstract IMarshalledValue createMarshalledValueForClone(Object paramObject)
/*    */     throws IOException;
/*    */ 
/*    */   public Object receiveObject(InputStream input, ClassLoader customClassLoader)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 76 */     int version = Version.getDefaultVersion();
/* 77 */     return receiveObject(input, customClassLoader, version);
/*    */   }
/*    */ 
/*    */   public abstract Object receiveObject(InputStream paramInputStream, ClassLoader paramClassLoader, int paramInt)
/*    */     throws IOException, ClassNotFoundException;
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.serialization.SerializationManager
 * JD-Core Version:    0.6.0
 */