/*     */ package org.jboss.remoting.serialization;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.serialization.impl.java.JavaEncryptionSerializationManager;
/*     */ import org.jboss.remoting.serialization.impl.java.JavaSerializationManager;
/*     */ import org.jboss.remoting.serialization.impl.jboss.JBossEncryptionSerializationManager;
/*     */ 
/*     */ public class SerializationStreamFactory
/*     */   implements SerializationStreamFactoryMBean
/*     */ {
/*  45 */   protected static final Logger log = Logger.getLogger(SerializationStreamFactory.class);
/*  46 */   private static Map managers = new HashMap();
/*     */   public static final String DEFAULT = "default";
/*     */   public static final String JAVA = "java";
/*     */   public static final String JBOSS = "jboss";
/*     */   public static final String JAVA_ENCRYPT = "javaencrypt";
/*     */   public static final String JBOSS_ENCRYPT = "jbossencrypt";
/*     */ 
/*     */   public static void setManagerClassName(String className)
/*     */     throws ClassNotFoundException, IllegalAccessException, InstantiationException
/*     */   {
/* 110 */     setManagerClassName("default", className);
/*     */   }
/*     */ 
/*     */   public static void setManagerClassName(String key, String className)
/*     */     throws ClassNotFoundException, IllegalAccessException, InstantiationException
/*     */   {
/* 120 */     loadObjectManagerClass(key, className);
/*     */   }
/*     */ 
/*     */   public String getManager()
/*     */   {
/* 126 */     return getManager("default");
/*     */   }
/*     */ 
/*     */   public String getManager(String key)
/*     */   {
/* 131 */     SerializationManager manager = (SerializationManager)managers.get(key);
/* 132 */     if (manager == null)
/*     */     {
/* 134 */       return null;
/*     */     }
/*     */ 
/* 138 */     return manager.getClass().getName();
/*     */   }
/*     */ 
/*     */   public void setManager(String manager)
/*     */     throws Exception
/*     */   {
/* 144 */     setManager("default", manager);
/*     */   }
/*     */ 
/*     */   public void setManager(String key, String manager) throws Exception
/*     */   {
/* 149 */     setManagerClassName(key, manager);
/*     */   }
/*     */ 
/*     */   private static void loadObjectManagerClass(String key, String managerClassName)
/*     */     throws ClassNotFoundException, IllegalAccessException, InstantiationException
/*     */   {
/* 158 */     Class managerClass = ClassLoaderUtility.loadClass(SerializationStreamFactory.class, managerClassName);
/* 159 */     SerializationManager manager = (SerializationManager)managerClass.newInstance();
/*     */ 
/* 161 */     if (managers.get(key) != null)
/*     */     {
/* 163 */       managers.remove(key);
/*     */     }
/* 165 */     managers.put(key, manager);
/*     */   }
/*     */ 
/*     */   public static SerializationManager getManagerInstance(String key)
/*     */     throws IOException
/*     */   {
/* 177 */     if (key == null)
/*     */     {
/* 179 */       key = "java";
/*     */     }
/* 181 */     SerializationManager manager = (SerializationManager)managers.get(key);
/*     */ 
/* 183 */     if (manager == null)
/*     */     {
/* 185 */       throw new IOException("Unknown serialization type: " + key);
/*     */     }
/* 187 */     return manager;
/*     */   }
/*     */ 
/*     */   public static SerializationManager getManagerInstance() throws IOException
/*     */   {
/* 192 */     return getManagerInstance("default");
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  59 */       String managerClassName = System.getProperty("SERIALIZATION", JavaSerializationManager.class.getName());
/*  60 */       setManagerClassName("default", managerClassName);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  64 */       log.error(e.getMessage(), e);
/*     */     }
/*     */     try
/*     */     {
/*  68 */       setManagerClassName("java", JavaSerializationManager.class.getName());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  72 */       log.error(e.getMessage(), e);
/*     */     }
/*     */     try
/*     */     {
/*  76 */       setManagerClassName("jboss", "org.jboss.remoting.serialization.impl.jboss.JBossSerializationManager");
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/*  80 */       log.debug("Could not load JBoss Serialization.  Use Java Serialization default.");
/*  81 */       log.trace(e);
/*     */     }
/*     */     try
/*     */     {
/*  85 */       setManagerClassName("javaencrypt", JavaEncryptionSerializationManager.class.getName());
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/*  89 */       log.debug("Could not load Java Encrypted Serialization.  Use Java Serialization default.");
/*  90 */       log.trace(e);
/*     */     }
/*     */     try
/*     */     {
/*  94 */       setManagerClassName("jbossencrypt", JBossEncryptionSerializationManager.class.getName());
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/*  98 */       log.debug("Could not load JBoss Encrypted Serialization.  Use Java Serialization default.");
/*  99 */       log.trace(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.serialization.SerializationStreamFactory
 * JD-Core Version:    0.6.0
 */