/*     */ package org.jboss.remoting.serialization.impl.java;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.util.Arrays;
/*     */ import org.jboss.remoting.serialization.RemotingMarshalledValue;
/*     */ 
/*     */ public class JavaMarshalledValue extends RemotingMarshalledValue
/*     */   implements Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = -1527598981234110311L;
/*     */   private byte[] serializedForm;
/*     */   private int hashCode;
/*     */ 
/*     */   public JavaMarshalledValue()
/*     */   {
/*     */   }
/*     */ 
/*     */   public JavaMarshalledValue(Object obj)
/*     */     throws IOException
/*     */   {
/*  73 */     ByteArrayOutputStream baos = new ByteArrayOutputStream();
/*  74 */     MarshalledValueOutputStream mvos = new MarshalledValueOutputStream(baos);
/*  75 */     mvos.writeObject(obj);
/*  76 */     mvos.flush();
/*  77 */     this.serializedForm = baos.toByteArray();
/*  78 */     mvos.close();
/*     */ 
/*  80 */     int hash = 0;
/*  81 */     for (int i = 0; i < this.serializedForm.length; i++)
/*     */     {
/*  83 */       hash = 31 * hash + this.serializedForm[i];
/*     */     }
/*     */ 
/*  86 */     this.hashCode = hash;
/*     */   }
/*     */ 
/*     */   public Object get()
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  92 */     if (this.serializedForm == null)
/*     */     {
/*  94 */       return null;
/*     */     }
/*     */ 
/*  97 */     ByteArrayInputStream bais = new ByteArrayInputStream(this.serializedForm);
/*  98 */     MarshalledValueInputStream mvis = new MarshalledValueInputStream(bais);
/*  99 */     Object retValue = mvis.readObject();
/* 100 */     mvis.close();
/* 101 */     return retValue;
/*     */   }
/*     */ 
/*     */   public byte[] toByteArray()
/*     */   {
/* 106 */     return this.serializedForm;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 111 */     int size = this.serializedForm != null ? this.serializedForm.length : 0;
/* 112 */     return size;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 122 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 127 */     if (this == obj)
/*     */     {
/* 129 */       return true;
/*     */     }
/*     */ 
/* 132 */     boolean equals = false;
/* 133 */     if ((obj instanceof JavaMarshalledValue))
/*     */     {
/* 135 */       JavaMarshalledValue mv = (JavaMarshalledValue)obj;
/* 136 */       if (this.serializedForm == mv.serializedForm)
/*     */       {
/* 138 */         equals = true;
/*     */       }
/*     */       else
/*     */       {
/* 142 */         equals = Arrays.equals(this.serializedForm, mv.serializedForm);
/*     */       }
/*     */     }
/* 145 */     return equals;
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 162 */     int length = in.readInt();
/* 163 */     this.serializedForm = null;
/* 164 */     if (length > 0)
/*     */     {
/* 166 */       this.serializedForm = new byte[length];
/* 167 */       in.readFully(this.serializedForm);
/*     */     }
/* 169 */     this.hashCode = in.readInt();
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 188 */     int length = this.serializedForm != null ? this.serializedForm.length : 0;
/* 189 */     out.writeInt(length);
/* 190 */     if (length > 0)
/*     */     {
/* 192 */       out.write(this.serializedForm);
/*     */     }
/* 194 */     out.writeInt(this.hashCode);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.serialization.impl.java.JavaMarshalledValue
 * JD-Core Version:    0.6.0
 */