/*    */ package org.jboss.remoting.serialization.impl.jboss;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.io.ObjectOutputStream;
/*    */ import java.io.Serializable;
/*    */ import javax.crypto.SealedObject;
/*    */ import org.jboss.remoting.InvocationRequest;
/*    */ import org.jboss.remoting.InvocationResponse;
/*    */ import org.jboss.remoting.marshal.encryption.EncryptionUtil;
/*    */ 
/*    */ public class JBossEncryptionSerializationManager extends JBossSerializationManager
/*    */ {
/*    */   public Object receiveObject(InputStream inputStream, ClassLoader customClassLoader)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 47 */     Object object = super.receiveObject(inputStream, customClassLoader);
/* 48 */     if ((object instanceof InvocationResponse))
/*    */     {
/* 50 */       InvocationResponse ir = (InvocationResponse)object;
/* 51 */       Object obj = ir.getResult();
/* 52 */       if ((obj instanceof SealedObject))
/*    */       {
/*    */         try
/*    */         {
/* 56 */           object = new InvocationResponse(ir.getSessionId(), EncryptionUtil.unsealObject((SealedObject)obj), ir.isException(), ir.getPayload());
/*    */         }
/*    */         catch (Exception e)
/*    */         {
/* 62 */           e.printStackTrace();
/*    */         }
/*    */       }
/*    */     }
/* 66 */     return object;
/*    */   }
/*    */ 
/*    */   public void sendObject(ObjectOutputStream oos, Object dataObject) throws IOException
/*    */   {
/* 71 */     if ((dataObject instanceof InvocationRequest))
/*    */     {
/* 73 */       InvocationRequest ir = (InvocationRequest)dataObject;
/* 74 */       Object obj = ir.getParameter();
/* 75 */       if ((obj instanceof Serializable))
/*    */       {
/*    */         try
/*    */         {
/* 79 */           ir.setParameter(EncryptionUtil.sealObject((Serializable)obj));
/*    */         }
/*    */         catch (Exception e)
/*    */         {
/* 83 */           e.printStackTrace();
/*    */         }
/*    */       }
/*    */     }
/* 87 */     super.sendObject(oos, dataObject);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.serialization.impl.jboss.JBossEncryptionSerializationManager
 * JD-Core Version:    0.6.0
 */