/*     */ package org.jboss.remoting.transport;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.security.SecureRandom;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class PortUtil
/*     */ {
/*  40 */   private static final Logger log = Logger.getLogger(PortUtil.class);
/*     */   private static final int MIN_UNPRIVILEGED_PORT = 1024;
/*     */   private static final int MAX_LEGAL_PORT = 65535;
/*  44 */   private static int portCounter = 0;
/*  45 */   private static int retryMax = 50;
/*     */ 
/*     */   public static boolean checkPort(int p, String host)
/*     */   {
/*  60 */     boolean available = true;
/*  61 */     ServerSocket socket = null;
/*     */     try
/*     */     {
/*  64 */       InetAddress inetAddress = InetAddress.getByName(host);
/*  65 */       socket = new ServerSocket(p, 0, inetAddress);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*  69 */       log.debug("port " + p + " already in use.  Will try another.");
/*  70 */       available = false;
/*     */     }
/*     */     finally
/*     */     {
/*  74 */       if (socket != null)
/*     */       {
/*     */         try
/*     */         {
/*  78 */           socket.close();
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*  86 */     return available;
/*     */   }
/*     */ 
/*     */   public static int findFreePort(String host)
/*     */     throws IOException
/*     */   {
/*  97 */     Integer port = null;
/*  98 */     int tryCount = 0;
/*  99 */     while ((port == null) && (tryCount < retryMax))
/*     */     {
/* 101 */       port = getFreePort(host);
/* 102 */       if (port != null)
/*     */       {
/* 105 */         if (!checkPort(port.intValue(), host))
/*     */         {
/* 107 */           port = null;
/*     */         }
/*     */       }
/* 110 */       tryCount++;
/*     */     }
/* 112 */     if (tryCount >= retryMax)
/*     */     {
/* 114 */       throw new IOException("Can not find a free port for use.");
/*     */     }
/* 116 */     return port.intValue();
/*     */   }
/*     */ 
/*     */   private static Integer getFreePort(String host)
/*     */   {
/* 121 */     int p = getNextPort();
/*     */ 
/* 123 */     if (checkPort(p, host))
/*     */     {
/* 125 */       return new Integer(p);
/*     */     }
/*     */ 
/* 129 */     return null;
/*     */   }
/*     */ 
/*     */   private static synchronized int getNextPort()
/*     */   {
/* 135 */     if (portCounter < 65535) {
/* 136 */       return portCounter++;
/*     */     }
/* 138 */     portCounter = 1024;
/* 139 */     return 65535;
/*     */   }
/*     */ 
/*     */   public static int getRandomStartingPort()
/*     */   {
/* 144 */     Object o = new Object();
/* 145 */     String os = o.toString();
/* 146 */     os = os.substring(17);
/* 147 */     int n = Integer.parseInt(os, 16);
/* 148 */     int p = Math.abs(new SecureRandom(String.valueOf(System.currentTimeMillis() + n).getBytes()).nextInt(2000)) + 2000;
/* 149 */     return p;
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*     */     try
/*     */     {
/* 156 */       System.out.println("port - " + findFreePort("localhost"));
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 160 */       ex.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  49 */     portCounter = getRandomStartingPort();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.PortUtil
 * JD-Core Version:    0.6.0
 */