/*     */ package org.jboss.remoting.transport.http.ssl;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.util.Map;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerInvocationHandler;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import javax.net.ServerSocketFactory;
/*     */ import javax.net.ssl.SSLServerSocketFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.security.ServerSocketFactoryMBean;
/*     */ import org.jboss.remoting.transport.http.HTTPServerInvoker;
/*     */ 
/*     */ /** @deprecated */
/*     */ public class HTTPSServerInvoker extends HTTPServerInvoker
/*     */ {
/*  52 */   private static final Logger log = Logger.getLogger(HTTPSServerInvoker.class);
/*     */ 
/*  54 */   protected ServerSocketFactory serverSocketFactory = null;
/*     */ 
/*     */   public HTTPSServerInvoker(InvokerLocator locator)
/*     */   {
/*  58 */     super(locator);
/*     */   }
/*     */ 
/*     */   public HTTPSServerInvoker(InvokerLocator locator, Map configuration)
/*     */   {
/*  63 */     super(locator, configuration);
/*     */   }
/*     */ 
/*     */   protected ServerSocket createServerSocket(int serverBindPort, int backlog, InetAddress bindAddress) throws IOException
/*     */   {
/*  68 */     ServerSocket svrSocket = null;
/*     */ 
/*  70 */     Map props = getConfiguration();
/*     */ 
/*  77 */     if (this.serverSocketFactory != null)
/*     */     {
/*  79 */       svrSocket = this.serverSocketFactory.createServerSocket(serverBindPort, backlog, bindAddress);
/*     */     }
/*  92 */     else if (props.get("serverSocketFactory") != null)
/*     */     {
/*     */       try
/*     */       {
/*  96 */         String serverSocketFactoryString = (String)props.get("serverSocketFactory");
/*  97 */         if (serverSocketFactoryString != null)
/*     */         {
/*  99 */           MBeanServer server = getMBeanServer();
/* 100 */           ObjectName serverSocketFactoryObjName = new ObjectName(serverSocketFactoryString);
/* 101 */           if (server != null)
/*     */           {
/*     */             try
/*     */             {
/* 105 */               ServerSocketFactoryMBean serverSocketFactory = (ServerSocketFactoryMBean)MBeanServerInvocationHandler.newProxyInstance(server, serverSocketFactoryObjName, ServerSocketFactoryMBean.class, false);
/*     */ 
/* 109 */               svrSocket = serverSocketFactory.createServerSocket(serverBindPort, backlog, bindAddress);
/*     */             }
/*     */             catch (Exception e)
/*     */             {
/* 113 */               log.error("Error creating mbean proxy for server socket factory for object name: " + serverSocketFactoryObjName, e);
/* 114 */               throw new IOException("Error createing custom server socket factory.");
/*     */             }
/*     */           }
/*     */           else
/*     */           {
/* 119 */             log.error("The 'serverSocketFactory' attribute was set with a value, but the MBeanServer reference is null.");
/* 120 */             throw new IOException("Error creating custom server socket factory.  The invoker does not have a reference to the mbean server.");
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (MalformedObjectNameException e)
/*     */       {
/* 126 */         log.error("Error setting the server socket factory due to the attibute value passed not being a valid ObjectName.", e);
/* 127 */         throw new IOException("Error creating custom server socket factory.  The attributed value passed is not a valid object name.");
/*     */       }
/*     */       catch (NullPointerException e)
/*     */       {
/* 131 */         log.error("Error setting the server socket factory due to null pointer exception.", e);
/* 132 */         throw new IOException("Error creating custom server socket factory.");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 137 */     if (svrSocket == null)
/*     */     {
/* 139 */       log.debug("Creating default server socket.");
/* 140 */       this.serverSocketFactory = SSLServerSocketFactory.getDefault();
/* 141 */       svrSocket = this.serverSocketFactory.createServerSocket(serverBindPort, backlog, bindAddress);
/*     */     }
/*     */ 
/* 144 */     log.debug("Created server socket: " + svrSocket);
/*     */ 
/* 146 */     return svrSocket;
/*     */   }
/*     */ 
/*     */   public void setServerSocketFactory(ServerSocketFactory serverSocketFactory)
/*     */   {
/* 159 */     this.serverSocketFactory = serverSocketFactory;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.http.ssl.HTTPSServerInvoker
 * JD-Core Version:    0.6.0
 */