/*     */ package org.jboss.remoting.transport.multiplex;
/*     */ 
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class Multiplex
/*     */ {
/*  48 */   private static Logger log = Logger.getLogger(Multiplex.class);
/*     */   public static final String SERVER_MULTIPLEX_ID = "serverMultiplexId";
/*     */   public static final String CLIENT_MULTIPLEX_ID = "clientMultiplexId";
/*     */   public static final String MULTIPLEX_CONNECT_PORT = "multiplexConnectPort";
/*     */   public static final String MULTIPLEX_CONNECT_HOST = "multiplexConnectHost";
/*     */   public static final String MULTIPLEX_BIND_HOST = "multiplexBindHost";
/*     */   public static final String MULTIPLEX_BIND_PORT = "multiplexBindPort";
/*     */   public static final String MAX_ACCEPT_ERRORS = "multiplex.maxAcceptErrors";
/*     */   public static final int MAX_ACCEPT_ERRORS_DEFAULT = 10;
/*     */   public static final String STATIC_THREADS_MONITOR_PERIOD = "multiplex.staticThreadsMonitorPeriod";
/*     */   public static final String SHUTDOWN_REQUEST_TIMEOUT = "multiplex.shutdownRequestTimeout";
/*     */   public static final String SHUTDOWN_REFUSALS_MAXIMUM = "multiplex.shutdownRefusalsMaximum";
/*     */   public static final String SHUTDOWN_MONITOR_PERIOD = "multiplex.shutdownMonitorPeriod";
/*     */   public static final int STATIC_THREADS_MONITOR_PERIOD_DEFAULT = 5000;
/*     */   public static final int SHUTDOWN_REQUEST_TIMEOUT_DEFAULT = 5000;
/*     */   public static final int SHUTDOWN_REFUSALS_MAXIMUM_DEFAULT = 5;
/*     */   public static final int SHUTDOWN_MONITOR_PERIOD_DEFAULT = 1000;
/*     */   public static final String INPUT_BUFFER_SIZE = "multiplex.inputBufferSize";
/*     */   public static final String INPUT_MAX_ERRORS = "multiplex.inputMaxErrors";
/*     */   public static final int INPUT_BUFFER_SIZE_DEFAULT = 4096;
/*     */   public static final int INPUT_MAX_ERRORS_DEFAULT = 3;
/*     */   public static final String OUTPUT_MESSAGE_POOL_SIZE = "multiplex.outputMessagePoolSize";
/*     */   public static final String OUTPUT_MESSAGE_SIZE = "multiplex.outputMessageSize";
/*     */   public static final String OUTPUT_MAX_CHUNK_SIZE = "multiplex.outputMaxChunkSize";
/*     */   public static final String OUTPUT_MAX_TIME_SLICE = "multiplex.outputMaxTimeSlice";
/*     */   public static final String OUTPUT_MAX_DATA_SLICE = "multiplex.outputMaxDataSlice";
/*     */   public static final String OUTPUT_MAX_ERRORS = "multiplex.outputMaxErrors";
/*     */   public static final int OUTPUT_MESSAGE_POOL_SIZE_DEFAULT = 1024;
/*     */   public static final int OUTPUT_MESSAGE_SIZE_DEFAULT = 256;
/*     */   public static final int OUTPUT_MAX_CHUNK_SIZE_DEFAULT = 2048;
/*     */   public static final int OUTPUT_MAX_TIME_SLICE_DEFAULT = 500;
/*     */   public static final int OUTPUT_MAX_DATA_SLICE_DEFAULT = 16384;
/*     */   public static final int OUTPUT_MAX_ERRORS_DEFAULT = 3;
/*     */   public static final String SOCKET_FACTORY = "multiplex.SocketFactory";
/*     */   public static final String SERVER_SOCKET_FACTORY = "multiplex.ServerSocketFactory";
/*     */   public static final String SSL_HANDSHAKE_LISTENER = "multiplex.SSLHandshakeListener";
/*     */ 
/*     */   public static int getOneParameter(Map configuration, String name, String key, int defaultValue)
/*     */   {
/* 143 */     if (configuration.containsKey(key))
/*     */     {
/* 145 */       Object obj = configuration.get(key);
/* 146 */       if ((obj instanceof Integer))
/*     */       {
/* 148 */         return ((Integer)obj).intValue();
/*     */       }
/* 150 */       if ((obj instanceof String))
/*     */       {
/*     */         try
/*     */         {
/* 154 */           return Integer.parseInt((String)obj);
/*     */         }
/*     */         catch (NumberFormatException e)
/*     */         {
/* 158 */           log.error("invalid value for " + name + ": using default: " + defaultValue);
/* 159 */           return defaultValue;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 164 */       log.error("invalid value for " + name + ": using default: " + defaultValue);
/* 165 */       return defaultValue;
/*     */     }
/*     */ 
/* 169 */     return defaultValue;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.Multiplex
 * JD-Core Version:    0.6.0
 */