/*      */ package org.jboss.remoting.transport.multiplex;
/*      */ 
/*      */ import java.io.EOFException;
/*      */ import java.io.IOException;
/*      */ import java.net.InetAddress;
/*      */ import java.net.InetSocketAddress;
/*      */ import java.net.ServerSocket;
/*      */ import java.net.Socket;
/*      */ import java.net.SocketException;
/*      */ import java.net.SocketTimeoutException;
/*      */ import java.util.Collection;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import javax.net.ServerSocketFactory;
/*      */ import javax.net.ssl.HandshakeCompletedEvent;
/*      */ import javax.net.ssl.HandshakeCompletedListener;
/*      */ import javax.net.ssl.SSLHandshakeException;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.remoting.InvokerLocator;
/*      */ import org.jboss.remoting.InvokerRegistry;
/*      */ import org.jboss.remoting.ServerInvocationHandler;
/*      */ import org.jboss.remoting.ServerInvoker;
/*      */ import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
/*      */ import org.jboss.remoting.transport.PortUtil;
/*      */ import org.jboss.remoting.transport.multiplex.utility.AddressPair;
/*      */ import org.jboss.remoting.transport.socket.SocketServerInvoker;
/*      */ import org.jboss.remoting.transport.socket.SocketServerInvoker.ServerSocketRefresh;
/*      */ import org.jboss.remoting.util.socket.HandshakeRepeater;
/*      */ 
/*      */ public class MultiplexServerInvoker extends SocketServerInvoker
/*      */   implements Runnable, VirtualSocket.DisconnectListener
/*      */ {
/*   68 */   protected static final Logger log = Logger.getLogger(MultiplexServerInvoker.class);
/*      */ 
/*   70 */   private static boolean trace = log.isTraceEnabled();
/*      */ 
/*   72 */   private static Map socketGroupMap = new HashMap();
/*   73 */   private static Map addressPairMap = new HashMap();
/*      */   private static HandshakeCompletedEvent handshakeCompletedEvent;
/*   76 */   private boolean isVirtual = false;
/*      */   private Map virtualServerInvokers;
/*      */   private Socket connectPrimingSocket;
/*      */   private SocketGroupInfo socketGroupInfo;
/*      */   private AddressPair addressPair;
/*      */   private String bindHost;
/*      */   private int bindPort;
/*      */   private int originalBindPort;
/*      */   private InetAddress bindAddress;
/*      */   private InetSocketAddress connectSocketAddress;
/*   86 */   private boolean readyToStart = true;
/*   87 */   private boolean needsSocketGroupConfiguration = true;
/*      */   private boolean cleanedUp;
/*      */   private boolean hasMaster;
/*      */   private int errorCount;
/*      */   private int staticThreadsMonitorPeriod;
/*      */   private int shutdownRequestTimeout;
/*      */   private int shutdownRefusalsMaximum;
/*      */   private int shutdownMonitorPeriod;
/*      */   private int inputBufferSize;
/*      */   private int inputMaxErrors;
/*      */   private int outputMessagePoolSize;
/*      */   private int outputMessageSize;
/*      */   private int outputMaxChunkSize;
/*      */   private int outputMaxTimeSlice;
/*      */   private int outputMaxDataSlice;
/*      */   private int maxAcceptErrors;
/*      */   private String serverMultiplexId;
/*      */   private String multiplexConnectHost;
/*      */   private int multiplexConnectPort;
/*      */   private boolean multiplexConnectPortIsSet;
/*      */ 
/*      */   public static Map getAddressPairMap()
/*      */   {
/*  173 */     return addressPairMap;
/*      */   }
/*      */ 
/*      */   public static Map getSocketGroupMap()
/*      */   {
/*  178 */     return socketGroupMap;
/*      */   }
/*      */ 
/*      */   public MultiplexServerInvoker(InvokerLocator locator)
/*      */   {
/*  190 */     super(locator);
/*      */ 
/*  192 */     this.virtualServerInvokers = new HashMap();
/*      */   }
/*      */ 
/*      */   public MultiplexServerInvoker(InvokerLocator locator, Map configuration)
/*      */   {
/*  201 */     super(locator, configuration);
/*      */ 
/*  203 */     this.virtualServerInvokers = new HashMap();
/*      */   }
/*      */ 
/*      */   protected MultiplexServerInvoker(InvokerLocator locator, Map configuration, ServerSocket serverSocket, Socket socket, Map virtualServerInvokers)
/*      */   {
/*  214 */     super(locator, configuration);
/*  215 */     this.serverSocket = serverSocket;
/*  216 */     this.connectPrimingSocket = socket;
/*  217 */     this.virtualServerInvokers = virtualServerInvokers;
/*  218 */     this.isVirtual = true;
/*  219 */     this.needsSocketGroupConfiguration = false;
/*  220 */     ((VirtualSocket)this.connectPrimingSocket).addDisconnectListener(this);
/*      */     try
/*      */     {
/*  224 */       getParameters();
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  228 */       log.error(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected String getDefaultDataType()
/*      */   {
/*  240 */     return "serializable";
/*      */   }
/*      */ 
/*      */   public void start()
/*      */     throws IOException
/*      */   {
/*  246 */     if (this.readyToStart)
/*  247 */       finishStart();
/*      */   }
/*      */ 
/*      */   public void run()
/*      */   {
/*  253 */     if (trace)
/*      */     {
/*  255 */       log.trace("Started execution of method run");
/*      */     }
/*  257 */     SocketServerInvoker.ServerSocketRefresh thread = new SocketServerInvoker.ServerSocketRefresh(this);
/*  258 */     thread.setDaemon(true);
/*  259 */     thread.start();
/*      */     try
/*      */     {
/*  263 */       while (this.running)
/*      */       {
/*      */         try
/*      */         {
/*  267 */           if (trace)
/*      */           {
/*  269 */             log.trace("Socket is going to be accepted");
/*      */           }
/*  271 */           thread.release();
/*  272 */           Socket socket = this.serverSocket.accept();
/*  273 */           if (trace)
/*      */           {
/*  275 */             log.trace("Accepted: " + socket);
/*      */           }
/*  277 */           processInvocation(socket);
/*      */         }
/*      */         catch (SocketException e)
/*      */         {
/*  281 */           if (("Socket is closed".equals(e.getMessage())) || ("Socket closed".equals(e.getMessage())))
/*      */           {
/*  284 */             log.info("socket is closed: stopping thread");
/*      */ 
/*  286 */             if (this.hasMaster) {
/*  287 */               stop();
/*      */             }
/*      */ 
/*  354 */             thread.interrupt(); return;
/*      */           }
/*  290 */           if (++this.errorCount > this.maxAcceptErrors)
/*      */           {
/*  292 */             log.error("maximum accept errors exceeded: stopping thread");
/*      */ 
/*  294 */             if (this.hasMaster) {
/*  295 */               stop();
/*      */             }
/*      */ 
/*  354 */             thread.interrupt(); return;
/*      */           }
/*  300 */           log.info(e);
/*      */         }
/*      */         catch (SocketTimeoutException e)
/*      */         {
/*  305 */           if (this.running)
/*      */           {
/*  309 */             if ((this.connectPrimingSocket != null) && (((VirtualSocket)this.connectPrimingSocket).hasReceivedDisconnectMessage()))
/*      */             {
/*  311 */               log.info("Client has closed: stopping thread");
/*      */ 
/*  313 */               if (this.hasMaster) {
/*  314 */                 stop();
/*      */               }
/*      */ 
/*  354 */               thread.interrupt(); return;
/*      */             }
/*      */           }
/*      */         }
/*      */         catch (EOFException e)
/*      */         {
/*  321 */           log.info("end of file exception: stopping thread");
/*      */ 
/*  323 */           if (this.hasMaster) {
/*  324 */             stop();
/*      */           }
/*      */ 
/*  354 */           thread.interrupt(); return;
/*      */         }
/*      */         catch (SSLHandshakeException e)
/*      */         {
/*  329 */           log.info("SSLHandshakeException", e);
/*      */         }
/*      */         catch (Throwable ex)
/*      */         {
/*  333 */           if (this.running)
/*      */           {
/*  335 */             log.error("Failed to accept socket connection", ex);
/*  336 */             if (++this.errorCount > this.maxAcceptErrors)
/*      */             {
/*  338 */               log.error("maximum accept errors exceeded: stopping");
/*      */ 
/*  340 */               if (this.hasMaster) {
/*  341 */                 stop();
/*      */               }
/*      */ 
/*  354 */               thread.interrupt(); return;
/*      */             }
/*      */           }
/*      */           else
/*      */           {
/*  347 */             log.info(ex);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*  354 */       thread.interrupt();
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isSafeToShutdown()
/*      */   {
/*  361 */     return (this.connectPrimingSocket == null) || (((VirtualSocket)this.connectPrimingSocket).hasReceivedDisconnectMessage());
/*      */   }
/*      */ 
/*      */   public void notifyDisconnected(VirtualSocket virtualSocket)
/*      */   {
/*  367 */     if (virtualSocket != this.connectPrimingSocket)
/*      */     {
/*  369 */       log.error("notified about disconnection of unrecognized virtual socket");
/*  370 */       return;
/*      */     }
/*      */ 
/*  373 */     log.debug("remote peer socket has closed: stopping");
/*  374 */     stop();
/*      */   }
/*      */ 
/*      */   public void stop()
/*      */   {
/*  383 */     if (!this.running) {
/*  384 */       cleanup();
/*      */     }
/*  386 */     super.stop();
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/*  392 */     if (this.isVirtual)
/*      */     {
/*  394 */       VirtualServerSocket vss = (VirtualServerSocket)this.serverSocket;
/*  395 */       if (vss != null) {
/*  396 */         return "MultiplexServerInvoker[virtual:" + vss.getInetAddress() + ":" + vss.getLocalPort() + "->" + vss.getRemoteAddress() + ":" + vss.getRemotePort() + "]";
/*      */       }
/*      */ 
/*  402 */       return "MultiplexServerInvoker[virtual]";
/*      */     }
/*      */ 
/*  405 */     if (this.serverSocket != null) {
/*  406 */       return "MultiplexServerInvoker[master:" + this.serverSocket.getInetAddress() + ":" + this.serverSocket.getLocalPort() + "]";
/*      */     }
/*      */ 
/*  410 */     return "MultiplexServerInvoker[master]";
/*      */   }
/*      */ 
/*      */   protected void setup()
/*      */     throws Exception
/*      */   {
/*  416 */     this.originalBindPort = getLocator().getPort();
/*  417 */     super.setup();
/*  418 */     getParameters();
/*  419 */     setBindingInfo();
/*      */ 
/*  425 */     if (!this.configuration.isEmpty())
/*      */     {
/*  427 */       if (this.needsSocketGroupConfiguration)
/*      */       {
/*      */         try
/*      */         {
/*  431 */           configureSocketGroupParameters(this.configuration);
/*      */         }
/*      */         catch (IOException e)
/*      */         {
/*  435 */           log.error("error configuring socket group parameters", e);
/*  436 */           cleanup();
/*  437 */           throw e;
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void finishStart()
/*      */     throws IOException
/*      */   {
/*  450 */     log.debug("entering finishStart()");
/*      */ 
/*  452 */     if (isStarted()) {
/*  453 */       return;
/*      */     }
/*  455 */     if ((this.socketGroupInfo != null) && (this.connectSocketAddress == null))
/*      */     {
/*  457 */       InetAddress connectAddress = this.socketGroupInfo.getConnectAddress();
/*  458 */       int connectPort = this.socketGroupInfo.getConnectPort();
/*  459 */       this.connectSocketAddress = new InetSocketAddress(connectAddress, connectPort);
/*      */     }
/*      */ 
/*  462 */     if ((this.socketGroupInfo != null) && (this.addressPair == null))
/*      */     {
/*  464 */       String connectHost = this.socketGroupInfo.getConnectAddress().getHostName();
/*  465 */       int connectPort = this.socketGroupInfo.getConnectPort();
/*  466 */       this.addressPair = new AddressPair(connectHost, connectPort, this.bindHost, this.bindPort);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  471 */       super.start();
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*  475 */       log.error("Error starting MultiplexServerInvoker.", e);
/*  476 */       cleanup();
/*      */     }
/*      */ 
/*  479 */     if (this.running)
/*  480 */       log.debug("MultiplexServerInvoker started.");
/*      */   }
/*      */ 
/*      */   protected void resetLocator(int bindPort)
/*      */   {
/*  493 */     this.bindPort = bindPort;
/*  494 */     InvokerLocator newLocator = new InvokerLocator(this.locator.getProtocol(), this.locator.getHost(), bindPort, this.locator.getPath(), this.locator.getParameters());
/*      */ 
/*  500 */     InvokerRegistry.updateServerInvokerLocator(this.locator, newLocator);
/*  501 */     this.locator = newLocator;
/*      */   }
/*      */ 
/*      */   protected void configureSocketGroupParameters(Map parameters)
/*      */     throws IOException
/*      */   {
/*  507 */     log.debug("entering configureSocketGroupParameters()");
/*  508 */     log.debug(this.locator);
/*      */ 
/*  510 */     synchronized (SocketGroupInfo.class)
/*      */     {
/*  512 */       if (this.serverMultiplexId != null)
/*      */       {
/*  514 */         this.socketGroupInfo = ((SocketGroupInfo)getSocketGroupMap().get(this.serverMultiplexId));
/*  515 */         if (this.socketGroupInfo != null)
/*      */         {
/*  517 */           rule1();
/*  518 */           return;
/*      */         }
/*      */       }
/*      */ 
/*  522 */       if ((this.multiplexConnectHost != null) && (!this.multiplexConnectPortIsSet)) {
/*  523 */         throw new IOException("multiplexConnectHost != null and multiplexConnectPort is not set");
/*      */       }
/*  525 */       if ((this.multiplexConnectHost == null) && (this.multiplexConnectPortIsSet)) {
/*  526 */         throw new IOException("multiplexConnectHost == null and multiplexConnectPort is set");
/*      */       }
/*      */ 
/*  529 */       if (this.multiplexConnectHost != null)
/*      */       {
/*  531 */         rule2(this.multiplexConnectHost, this.multiplexConnectPort);
/*  532 */         return;
/*      */       }
/*      */ 
/*  536 */       if (this.serverMultiplexId != null)
/*      */       {
/*  538 */         rule3();
/*  539 */         return;
/*      */       }
/*      */ 
/*  543 */       rule4();
/*      */     }
/*      */   }
/*      */ 
/*      */   protected static void createPrimingSocket(SocketGroupInfo socketGroupInfo, String connectHost, int connectPort, Map configuration, int timeout)
/*      */     throws IOException
/*      */   {
/*  553 */     createPrimingSocket(socketGroupInfo, connectHost, connectPort, null, -1, configuration, timeout);
/*      */   }
/*      */ 
/*      */   protected static void createPrimingSocket(SocketGroupInfo socketGroupInfo, String connectHost, int connectPort, InetAddress bindAddress, int bindPort, Map configuration, int timeout)
/*      */     throws IOException
/*      */   {
/*  563 */     log.debug("entering createPrimingSocket()");
/*      */ 
/*  565 */     boolean needed = true;
/*  566 */     InetSocketAddress csa = new InetSocketAddress(connectHost, connectPort);
/*  567 */     InetSocketAddress bsa = null;
/*      */ 
/*  569 */     if (bindAddress != null)
/*      */     {
/*  571 */       bsa = new InetSocketAddress(bindAddress, bindPort);
/*  572 */       needed = !MultiplexingManager.checkForShareableManagerByAddressPair(bsa, csa);
/*      */     }
/*      */     else
/*      */     {
/*  576 */       needed = !MultiplexingManager.checkForShareableManager(csa);
/*      */     }
/*      */ 
/*  579 */     if (socketGroupInfo != null) {
/*  580 */       socketGroupInfo.setPrimingSocketNeeded(needed);
/*      */     }
/*  582 */     if (!needed)
/*      */     {
/*  584 */       log.debug("priming socket is not necessary");
/*  585 */       return;
/*      */     }
/*      */ 
/*  592 */     Object obj = configuration.get("handshakeCompletedListener");
/*  593 */     HandshakeCompletedListener externalListener = null;
/*  594 */     HandshakeRepeater internalListener = null;
/*  595 */     if ((obj != null) && ((obj instanceof HandshakeCompletedListener)))
/*      */     {
/*  597 */       externalListener = (HandshakeCompletedListener)obj;
/*  598 */       internalListener = new HandshakeRepeater(new InternalHandshakeListener());
/*  599 */       configuration.put("multiplex.SSLHandshakeListener", internalListener);
/*      */     }
/*      */ 
/*  602 */     VirtualSocket socket = new VirtualSocket(configuration);
/*      */ 
/*  604 */     if (bindAddress != null)
/*  605 */       socket.connect(csa, bsa, timeout);
/*      */     else {
/*  607 */       socket.connect(csa, timeout);
/*      */     }
/*  609 */     MultiplexingManager manager = socket.getManager();
/*      */ 
/*  611 */     if (externalListener != null)
/*      */     {
/*  613 */       if (manager.getHandshakeCompletedEvent() != null)
/*      */       {
/*  615 */         externalListener.handshakeCompleted(manager.getHandshakeCompletedEvent());
/*      */       }
/*      */       else
/*      */       {
/*  619 */         internalListener.waitForHandshake();
/*  620 */         externalListener.handshakeCompleted(handshakeCompletedEvent);
/*      */       }
/*      */     }
/*      */ 
/*  624 */     if (!manager.waitForRemoteServerSocketRegistered()) {
/*  625 */       throw new IOException("error waiting for remote server socket to be registered");
/*      */     }
/*  627 */     if (socketGroupInfo != null) {
/*  628 */       socketGroupInfo.setPrimingSocket(socket);
/*      */     }
/*  630 */     log.debug("created priming socket: " + socket.getLocalSocketId());
/*      */   }
/*      */ 
/*      */   protected String getThreadName(int i)
/*      */   {
/*  636 */     String virtualTag = this.isVirtual ? "v" : "m";
/*  637 */     return "MultiplexServerInvoker#" + i + virtualTag + "-" + this.serverSocket.toString();
/*      */   }
/*      */ 
/*      */   protected void processInvocation(Socket socket)
/*      */     throws Exception
/*      */   {
/*  643 */     if (this.isVirtual) {
/*  644 */       super.processInvocation(socket);
/*      */     }
/*      */     else {
/*  647 */       log.debug("creating VSS");
/*  648 */       ServerSocket ss = new VirtualServerSocket((VirtualSocket)socket, this.configuration);
/*  649 */       ss.setSoTimeout(getTimeout());
/*  650 */       MultiplexServerInvoker si = new MultiplexServerInvoker(this.locator, this.configuration, ss, socket, this.virtualServerInvokers);
/*  651 */       si.hasMaster = true;
/*  652 */       si.clientCallbackListener = this.clientCallbackListener;
/*  653 */       si.handlers = this.handlers;
/*  654 */       si.setMBeanServer(getMBeanServer());
/*  655 */       si.setServerSocketFactory(getServerSocketFactory());
/*  656 */       si.setSocketFactory(this.socketFactory);
/*  657 */       synchronized (this.virtualServerInvokers)
/*      */       {
/*  659 */         this.virtualServerInvokers.put(socket.getRemoteSocketAddress(), si);
/*      */       }
/*  661 */       si.connectionNotifier = this.connectionNotifier;
/*  662 */       si.create();
/*  663 */       si.start();
/*  664 */       log.debug("created virtual MultiplexServerInvoker: " + si);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void cleanup()
/*      */   {
/*  672 */     if (this.running)
/*      */     {
/*  674 */       super.cleanup();
/*      */     }
/*      */ 
/*  678 */     if (this.cleanedUp) {
/*  679 */       return;
/*      */     }
/*  681 */     this.cleanedUp = true;
/*      */ 
/*  683 */     if (this.isVirtual)
/*      */     {
/*  685 */       if (this.connectPrimingSocket != null)
/*      */       {
/*  687 */         log.debug("connect priming != null");
/*      */ 
/*  691 */         Object key = this.connectPrimingSocket.getRemoteSocketAddress();
/*  692 */         synchronized (this.virtualServerInvokers)
/*      */         {
/*  694 */           if (this.virtualServerInvokers.containsKey(key)) {
/*  695 */             this.virtualServerInvokers.remove(key);
/*      */           }
/*      */         }
/*      */         try
/*      */         {
/*  700 */           log.debug("MultiplexServerInvoker: closing connect priming socket");
/*  701 */           this.connectPrimingSocket.close();
/*      */         }
/*      */         catch (IOException e)
/*      */         {
/*  705 */           log.error("Error closing connect priming socket during cleanup upon stopping", e);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  710 */         log.debug("connect priming socket == null");
/*      */       }
/*      */ 
/*  714 */       Iterator it = this.handlers.values().iterator();
/*      */ 
/*  716 */       if (it.hasNext())
/*      */       {
/*  718 */         log.debug("removing callback handlers");
/*  719 */         ServerInvocationHandler defaultHandler = (ServerInvocationHandler)it.next();
/*  720 */         ServerInvocationHandler handler = null;
/*  721 */         ServerInvokerCallbackHandler callbackHandler = null;
/*  722 */         it = this.callbackHandlers.values().iterator();
/*      */ 
/*  724 */         while (it.hasNext())
/*      */         {
/*  726 */           callbackHandler = (ServerInvokerCallbackHandler)it.next();
/*  727 */           String subsystem = callbackHandler.getSubsystem();
/*      */ 
/*  729 */           if (subsystem == null)
/*  730 */             handler = defaultHandler;
/*      */           else {
/*  732 */             handler = (ServerInvocationHandler)this.handlers.get(subsystem.toUpperCase());
/*      */           }
/*  734 */           handler.removeListener(callbackHandler);
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  741 */       Iterator it = null;
/*  742 */       synchronized (this.virtualServerInvokers)
/*      */       {
/*  744 */         it = new HashMap(this.virtualServerInvokers).values().iterator();
/*      */       }
/*      */ 
/*  747 */       while (it.hasNext())
/*      */       {
/*  749 */         ServerInvoker serverInvoker = (ServerInvoker)it.next();
/*  750 */         it.remove();
/*  751 */         serverInvoker.stop();
/*      */       }
/*      */     }
/*      */ 
/*  755 */     if (this.socketGroupInfo != null)
/*      */     {
/*  757 */       synchronized (SocketGroupInfo.class)
/*      */       {
/*  759 */         this.socketGroupInfo.removeServerInvoker(this);
/*  760 */         VirtualSocket ps = null;
/*      */ 
/*  762 */         if (this.socketGroupInfo.getClientInvokers().isEmpty())
/*      */         {
/*  764 */           log.debug("invoker group shutting down: " + this.socketGroupInfo.getSocketGroupId());
/*      */ 
/*  766 */           if ((ps = this.socketGroupInfo.getPrimingSocket()) != null)
/*      */           {
/*  773 */             ps.getManager().unregisterShareable();
/*      */ 
/*  775 */             log.debug("MultiplexServerInvoker: closing bind priming socket");
/*      */             try
/*      */             {
/*  778 */               ps.close();
/*      */             }
/*      */             catch (IOException e)
/*      */             {
/*  782 */               log.error("Error closing bind priming socket during cleanup upon stopping", e);
/*      */             }
/*      */           }
/*      */ 
/*  786 */           this.serverMultiplexId = this.socketGroupInfo.getSocketGroupId();
/*  787 */           log.debug("serverMultiplexId: " + this.serverMultiplexId);
/*  788 */           if (this.serverMultiplexId != null)
/*      */           {
/*  790 */             getSocketGroupMap().remove(this.serverMultiplexId);
/*  791 */             log.debug("removed serverMultiplexId: " + this.serverMultiplexId);
/*  792 */             log.debug("socketGroupInfo: " + getSocketGroupMap().get(this.serverMultiplexId));
/*      */           }
/*      */ 
/*  796 */           if (this.addressPair != null)
/*      */           {
/*  798 */             getAddressPairMap().remove(this.addressPair);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected ServerSocket createServerSocket(int bindPort, int backlog, InetAddress bindAddress)
/*      */     throws IOException
/*      */   {
/*  850 */     if (this.serverSocket != null) {
/*  851 */       return this.serverSocket;
/*      */     }
/*  853 */     ServerSocket svrSocket = null;
/*      */ 
/*  855 */     if (this.isVirtual)
/*      */     {
/*  857 */       InetSocketAddress bindSocketAddress = new InetSocketAddress(bindAddress, this.bindPort);
/*  858 */       svrSocket = new VirtualServerSocket(this.connectSocketAddress, bindSocketAddress, getTimeout(), this.configuration);
/*  859 */       svrSocket.setSoTimeout(getTimeout());
/*      */ 
/*  861 */       if (this.socketGroupInfo != null) {
/*  862 */         this.socketGroupInfo.setPrimingSocketNeeded(false);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  867 */       ServerSocketFactory ssf = getServerSocketFactory();
/*  868 */       if ((ssf != null) && (!ssf.getClass().equals(ServerSocketFactory.getDefault().getClass())))
/*      */       {
/*  870 */         this.configuration.put("multiplex.ServerSocketFactory", ssf);
/*      */       }
/*  872 */       svrSocket = new MasterServerSocket(bindPort, backlog, bindAddress, this.configuration);
/*      */     }
/*      */ 
/*  875 */     log.debug("Created " + svrSocket.getClass() + ": " + svrSocket);
/*  876 */     return svrSocket;
/*      */   }
/*      */ 
/*      */   protected void rule1()
/*      */     throws IOException
/*      */   {
/*  882 */     log.debug("server rule 1");
/*      */ 
/*  887 */     InetAddress socketGroupBindAddress = this.socketGroupInfo.getBindAddress();
/*  888 */     int socketGroupBindPort = this.socketGroupInfo.getBindPort();
/*      */ 
/*  890 */     if ((socketGroupBindAddress != null) && (!socketGroupBindAddress.equals(this.bindAddress)))
/*      */     {
/*  892 */       String message = "socket group bind address (" + socketGroupBindAddress + ") does not match bind address (" + this.bindAddress + ")";
/*      */ 
/*  894 */       log.error(message);
/*  895 */       this.socketGroupInfo = null;
/*  896 */       throw new IOException(message);
/*      */     }
/*      */ 
/*  899 */     if ((socketGroupBindPort > 0) && (this.originalBindPort > 0) && (socketGroupBindPort != this.bindPort))
/*      */     {
/*  901 */       String message = "socket group bind port (" + socketGroupBindPort + ") does not match bind port (" + this.bindPort + ")";
/*      */ 
/*  903 */       log.error(message);
/*  904 */       this.socketGroupInfo = null;
/*  905 */       throw new IOException(message);
/*      */     }
/*      */ 
/*  908 */     if (this.originalBindPort <= 0)
/*      */     {
/*  910 */       if (socketGroupBindPort > 0) {
/*  911 */         this.bindPort = socketGroupBindPort;
/*      */       }
/*      */       else {
/*  914 */         this.bindPort = PortUtil.findFreePort(this.bindHost);
/*  915 */         socketGroupBindPort = this.bindPort;
/*      */       }
/*      */ 
/*  919 */       InvokerLocator newLocator = new InvokerLocator(this.locator.getProtocol(), this.locator.getHost(), this.bindPort, this.locator.getPath(), this.locator.getParameters());
/*      */ 
/*  921 */       InvokerRegistry.updateServerInvokerLocator(this.locator, newLocator);
/*  922 */       this.locator = newLocator;
/*      */     }
/*      */ 
/*  925 */     this.isVirtual = true;
/*  926 */     InetAddress connectAddress = this.socketGroupInfo.getConnectAddress();
/*  927 */     int connectPort = this.socketGroupInfo.getConnectPort();
/*  928 */     this.connectSocketAddress = new InetSocketAddress(connectAddress, connectPort);
/*  929 */     this.socketGroupInfo.setBindAddress(this.bindAddress);
/*  930 */     this.socketGroupInfo.setBindPort(this.bindPort);
/*  931 */     this.socketGroupInfo.setServerInvoker(this);
/*      */ 
/*  933 */     Iterator it = this.socketGroupInfo.getClientInvokers().iterator();
/*  934 */     while (it.hasNext())
/*      */     {
/*  936 */       ((MultiplexClientInvoker)it.next()).finishStart();
/*      */     }
/*      */ 
/*  939 */     this.readyToStart = true;
/*      */ 
/*  941 */     if (this.socketGroupInfo.getPrimingSocket() == null)
/*      */     {
/*  943 */       this.socketFactory = createSocketFactory(this.configuration);
/*  944 */       if (this.socketFactory != null) {
/*  945 */         this.configuration.put("multiplex.SocketFactory", this.socketFactory);
/*      */       }
/*  947 */       createPrimingSocket(this.socketGroupInfo, connectAddress.getHostName(), connectPort, this.bindAddress, this.bindPort, this.configuration, getTimeout());
/*      */     }
/*      */ 
/*  952 */     String connectHost = connectAddress.getHostName();
/*  953 */     this.addressPair = new AddressPair(connectHost, connectPort, this.bindHost, this.bindPort);
/*  954 */     addressPairMap.put(this.addressPair, this.socketGroupInfo);
/*      */   }
/*      */ 
/*      */   protected void rule2(String connectHost, int connectPort)
/*      */     throws IOException
/*      */   {
/*  961 */     log.debug("server rule 2");
/*  962 */     this.isVirtual = true;
/*      */ 
/*  964 */     this.connectSocketAddress = new InetSocketAddress(connectHost, connectPort);
/*  965 */     this.addressPair = new AddressPair(connectHost, connectPort, this.bindHost, this.bindPort);
/*  966 */     this.socketGroupInfo = ((SocketGroupInfo)addressPairMap.get(this.addressPair));
/*      */ 
/*  970 */     if (this.socketGroupInfo != null)
/*      */     {
/*  973 */       if (this.serverMultiplexId != null)
/*      */       {
/*  975 */         String socketGroupSocketGroupId = this.socketGroupInfo.getSocketGroupId();
/*      */ 
/*  977 */         if ((socketGroupSocketGroupId != null) && (socketGroupSocketGroupId != this.serverMultiplexId))
/*      */         {
/*  979 */           String message = "socket group multiplexId (" + socketGroupSocketGroupId + ") does not match multiplexId (" + this.serverMultiplexId + ")";
/*      */ 
/*  981 */           log.error(message);
/*  982 */           this.socketGroupInfo = null;
/*  983 */           throw new IOException(message);
/*      */         }
/*      */ 
/*  986 */         if (socketGroupSocketGroupId == null)
/*      */         {
/*  988 */           this.socketGroupInfo.setSocketGroupId(this.serverMultiplexId);
/*  989 */           getSocketGroupMap().put(this.serverMultiplexId, this.socketGroupInfo);
/*      */         }
/*      */       }
/*      */ 
/*  993 */       this.socketGroupInfo.setBindAddress(this.bindAddress);
/*  994 */       this.socketGroupInfo.setBindPort(this.bindPort);
/*  995 */       this.socketGroupInfo.setServerInvoker(this);
/*  996 */       this.readyToStart = true;
/*  997 */       return;
/*      */     }
/*      */ 
/* 1000 */     this.socketGroupInfo = new SocketGroupInfo();
/* 1001 */     this.socketGroupInfo.setBindAddress(this.bindAddress);
/* 1002 */     this.socketGroupInfo.setBindPort(this.bindPort);
/* 1003 */     this.socketGroupInfo.setServerInvoker(this);
/*      */ 
/* 1007 */     InetAddress connectAddress = InetAddress.getByName(connectHost);
/* 1008 */     this.socketGroupInfo.setConnectAddress(connectAddress);
/* 1009 */     this.socketGroupInfo.setConnectPort(connectPort);
/*      */ 
/* 1011 */     this.socketFactory = createSocketFactory(this.configuration);
/* 1012 */     if (this.socketFactory != null) {
/* 1013 */       this.configuration.put("multiplex.SocketFactory", this.socketFactory);
/*      */     }
/* 1015 */     createPrimingSocket(this.socketGroupInfo, connectHost, connectPort, this.bindAddress, this.bindPort, this.configuration, getTimeout());
/*      */ 
/* 1017 */     addressPairMap.put(this.addressPair, this.socketGroupInfo);
/*      */ 
/* 1019 */     if (this.serverMultiplexId != null)
/*      */     {
/* 1021 */       this.socketGroupInfo.setSocketGroupId(this.serverMultiplexId);
/* 1022 */       socketGroupMap.put(this.serverMultiplexId, this.socketGroupInfo);
/*      */     }
/*      */ 
/* 1025 */     this.readyToStart = true;
/*      */   }
/*      */ 
/*      */   protected void rule3()
/*      */     throws IOException
/*      */   {
/* 1031 */     log.debug("server rule 3");
/* 1032 */     this.socketGroupInfo = new SocketGroupInfo();
/* 1033 */     this.socketGroupInfo.setSocketGroupId(this.serverMultiplexId);
/* 1034 */     this.socketGroupInfo.setServerInvoker(this);
/* 1035 */     this.socketGroupInfo.setBindAddress(this.bindAddress);
/* 1036 */     this.socketGroupInfo.setBindPort(this.bindPort);
/* 1037 */     socketGroupMap.put(this.serverMultiplexId, this.socketGroupInfo);
/* 1038 */     this.isVirtual = true;
/* 1039 */     this.readyToStart = false;
/*      */   }
/*      */ 
/*      */   protected void rule4()
/*      */   {
/* 1045 */     log.debug("server rule 4");
/* 1046 */     this.isVirtual = false;
/* 1047 */     this.readyToStart = true;
/*      */   }
/*      */ 
/*      */   protected void refreshServerSocket()
/*      */     throws IOException
/*      */   {
/* 1053 */     super.refreshServerSocket();
/*      */   }
/*      */ 
/*      */   public ServerSocket getServerSocket()
/*      */   {
/* 1064 */     return this.serverSocket;
/*      */   }
/*      */ 
/*      */   public MultiplexServerInvoker getServerInvoker(InetSocketAddress address)
/*      */   {
/* 1074 */     synchronized (this.virtualServerInvokers)
/*      */     {
/* 1076 */       return (MultiplexServerInvoker)this.virtualServerInvokers.get(address);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Collection getServerInvokers()
/*      */   {
/* 1087 */     synchronized (this.virtualServerInvokers)
/*      */     {
/* 1089 */       return this.virtualServerInvokers.values();
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void setBindingInfo() throws IOException
/*      */   {
/* 1095 */     String originalUri = getLocator().getOriginalURI();
/* 1096 */     String pastProtocol = originalUri.substring(originalUri.indexOf("://") + 3);
/* 1097 */     int colon = pastProtocol.indexOf(":");
/* 1098 */     int slash = pastProtocol.indexOf("/");
/* 1099 */     String originalHost = null;
/* 1100 */     int originalPort = 0;
/*      */ 
/* 1102 */     if (colon != -1)
/*      */     {
/* 1104 */       originalHost = pastProtocol.substring(0, colon).trim();
/*      */ 
/* 1106 */       if (slash > -1)
/*      */       {
/* 1108 */         originalPort = Integer.parseInt(pastProtocol.substring(colon + 1, slash));
/*      */       }
/*      */       else
/*      */       {
/* 1112 */         originalPort = Integer.parseInt(pastProtocol.substring(colon + 1));
/*      */       }
/*      */ 
/*      */     }
/* 1117 */     else if (slash > -1)
/*      */     {
/* 1119 */       originalHost = pastProtocol.substring(0, slash).trim();
/*      */     }
/*      */     else
/*      */     {
/* 1123 */       originalHost = pastProtocol.substring(0).trim();
/*      */     }
/*      */ 
/* 1127 */     this.bindHost = getServerBindAddress();
/* 1128 */     this.bindPort = getServerBindPort();
/* 1129 */     this.bindAddress = InetAddress.getByName(this.bindHost);
/*      */   }
/*      */ 
/*      */   protected void getParameters()
/*      */     throws Exception
/*      */   {
/* 1135 */     if (this.configuration != null) {
/* 1136 */       this.maxAcceptErrors = Multiplex.getOneParameter(this.configuration, "maxAcceptErrors", "multiplex.maxAcceptErrors", 10);
/*      */     }
/*      */ 
/* 1142 */     if (this.configuration != null) {
/* 1143 */       this.serverMultiplexId = ((String)this.configuration.get("serverMultiplexId"));
/*      */     }
/* 1145 */     if (this.configuration != null) {
/* 1146 */       this.multiplexConnectHost = ((String)this.configuration.get("multiplexConnectHost"));
/*      */     }
/* 1148 */     Object value = this.configuration.get("multiplexConnectPort");
/* 1149 */     if (value != null)
/*      */     {
/* 1151 */       if ((value instanceof String))
/*      */       {
/*      */         try
/*      */         {
/* 1155 */           this.multiplexConnectPort = Integer.parseInt((String)value);
/* 1156 */           this.multiplexConnectPortIsSet = true;
/*      */         }
/*      */         catch (NumberFormatException e)
/*      */         {
/* 1160 */           String errorMessage = "number format error for multiplexConnectPort: " + (String)value;
/* 1161 */           log.error(errorMessage);
/* 1162 */           throw new IOException(errorMessage);
/*      */         }
/*      */       }
/* 1165 */       else if ((value instanceof Integer))
/*      */       {
/* 1167 */         this.multiplexConnectPort = ((Integer)this.configuration.get("multiplexConnectPort")).intValue();
/* 1168 */         this.multiplexConnectPortIsSet = true;
/*      */       }
/*      */       else
/*      */       {
/* 1172 */         String errorMessage = "invalid object passed for multiplexConnectPort: " + value;
/* 1173 */         log.error(errorMessage);
/* 1174 */         throw new IOException(errorMessage);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getInputBufferSize()
/*      */   {
/* 1185 */     return this.inputBufferSize;
/*      */   }
/*      */ 
/*      */   public void setInputBufferSize(int inputBufferSize)
/*      */   {
/* 1191 */     this.inputBufferSize = inputBufferSize;
/* 1192 */     if (this.configuration != null)
/* 1193 */       this.configuration.put("multiplex.inputBufferSize", new Integer(inputBufferSize));
/*      */   }
/*      */ 
/*      */   public int getInputMaxErrors()
/*      */   {
/* 1199 */     return this.inputMaxErrors;
/*      */   }
/*      */ 
/*      */   public void setInputMaxErrors(int inputMaxErrors)
/*      */   {
/* 1205 */     this.inputMaxErrors = inputMaxErrors;
/* 1206 */     if (this.configuration != null)
/* 1207 */       this.configuration.put("multiplex.inputMaxErrors", new Integer(inputMaxErrors));
/*      */   }
/*      */ 
/*      */   public int getMaxAcceptErrors()
/*      */   {
/* 1213 */     return this.maxAcceptErrors;
/*      */   }
/*      */ 
/*      */   public void setMaxAcceptErrors(int maxAcceptErrors)
/*      */   {
/* 1219 */     this.maxAcceptErrors = maxAcceptErrors;
/* 1220 */     if (this.configuration != null)
/* 1221 */       this.configuration.put("multiplex.maxAcceptErrors", new Integer(maxAcceptErrors));
/*      */   }
/*      */ 
/*      */   public String getMultiplexConnectHost()
/*      */   {
/* 1227 */     return this.multiplexConnectHost;
/*      */   }
/*      */ 
/*      */   public int getMultiplexConnectPort()
/*      */   {
/* 1243 */     return this.multiplexConnectPort;
/*      */   }
/*      */ 
/*      */   public int getOutputMaxChunkSize()
/*      */   {
/* 1258 */     return this.outputMaxChunkSize;
/*      */   }
/*      */ 
/*      */   public void setOutputMaxChunkSize(int outputMaxChunkSize)
/*      */   {
/* 1264 */     this.outputMaxChunkSize = outputMaxChunkSize;
/* 1265 */     if (this.configuration != null)
/* 1266 */       this.configuration.put("multiplex.outputMaxChunkSize", new Integer(outputMaxChunkSize));
/*      */   }
/*      */ 
/*      */   public int getOutputMaxDataSlice()
/*      */   {
/* 1272 */     return this.outputMaxDataSlice;
/*      */   }
/*      */ 
/*      */   public void setOutputMaxDataSlice(int outputMaxDataSlice)
/*      */   {
/* 1278 */     this.outputMaxDataSlice = outputMaxDataSlice;
/* 1279 */     if (this.configuration != null)
/* 1280 */       this.configuration.put("multiplex.outputMaxDataSlice", new Integer(outputMaxDataSlice));
/*      */   }
/*      */ 
/*      */   public int getOutputMaxTimeSlice()
/*      */   {
/* 1286 */     return this.outputMaxTimeSlice;
/*      */   }
/*      */ 
/*      */   public void setOutputMaxTimeSlice(int outputMaxTimeSlice)
/*      */   {
/* 1292 */     this.outputMaxTimeSlice = outputMaxTimeSlice;
/* 1293 */     if (this.configuration != null)
/* 1294 */       this.configuration.put("multiplex.outputMaxTimeSlice", new Integer(outputMaxTimeSlice));
/*      */   }
/*      */ 
/*      */   public int getOutputMessagePoolSize()
/*      */   {
/* 1300 */     return this.outputMessagePoolSize;
/*      */   }
/*      */ 
/*      */   public void setOutputMessagePoolSize(int outputMessagePoolSize)
/*      */   {
/* 1306 */     this.outputMessagePoolSize = outputMessagePoolSize;
/* 1307 */     if (this.configuration != null)
/* 1308 */       this.configuration.put("multiplex.outputMessagePoolSize", new Integer(outputMessagePoolSize));
/*      */   }
/*      */ 
/*      */   public int getOutputMessageSize()
/*      */   {
/* 1314 */     return this.outputMessageSize;
/*      */   }
/*      */ 
/*      */   public void setOutputMessageSize(int outputMessageSize)
/*      */   {
/* 1320 */     this.outputMessageSize = outputMessageSize;
/* 1321 */     if (this.configuration != null)
/* 1322 */       this.configuration.put("multiplex.outputMessageSize", new Integer(outputMessageSize));
/*      */   }
/*      */ 
/*      */   public String getServerMultiplexId()
/*      */   {
/* 1328 */     return this.serverMultiplexId;
/*      */   }
/*      */ 
/*      */   public int getShutdownMonitorPeriod()
/*      */   {
/* 1343 */     return this.shutdownMonitorPeriod;
/*      */   }
/*      */ 
/*      */   public void setShutdownMonitorPeriod(int shutdownMonitorPeriod)
/*      */   {
/* 1349 */     this.shutdownMonitorPeriod = shutdownMonitorPeriod;
/* 1350 */     if (this.configuration != null)
/* 1351 */       this.configuration.put("multiplex.shutdownMonitorPeriod", new Integer(shutdownMonitorPeriod));
/*      */   }
/*      */ 
/*      */   public int getShutdownRefusalsMaximum()
/*      */   {
/* 1357 */     return this.shutdownRefusalsMaximum;
/*      */   }
/*      */ 
/*      */   public void setShutdownRefusalsMaximum(int shutdownRefusalsMaximum)
/*      */   {
/* 1363 */     this.shutdownRefusalsMaximum = shutdownRefusalsMaximum;
/* 1364 */     if (this.configuration != null)
/* 1365 */       this.configuration.put("multiplex.shutdownRefusalsMaximum", new Integer(shutdownRefusalsMaximum));
/*      */   }
/*      */ 
/*      */   public int getShutdownRequestTimeout()
/*      */   {
/* 1371 */     return this.shutdownRequestTimeout;
/*      */   }
/*      */ 
/*      */   public void setShutdownRequestTimeout(int shutdownRequestTimeout)
/*      */   {
/* 1377 */     this.shutdownRequestTimeout = shutdownRequestTimeout;
/* 1378 */     if (this.configuration != null)
/* 1379 */       this.configuration.put("multiplex.shutdownRequestTimeout", new Integer(shutdownRequestTimeout));
/*      */   }
/*      */ 
/*      */   public int getStaticThreadsMonitorPeriod()
/*      */   {
/* 1385 */     return this.staticThreadsMonitorPeriod;
/*      */   }
/*      */ 
/*      */   public void setStaticThreadsMonitorPeriod(int staticThreadsMonitorPeriod)
/*      */   {
/* 1391 */     this.staticThreadsMonitorPeriod = staticThreadsMonitorPeriod;
/* 1392 */     if (this.configuration != null)
/* 1393 */       this.configuration.put("multiplex.staticThreadsMonitorPeriod", new Integer(staticThreadsMonitorPeriod));
/*      */   }
/*      */ 
/*      */   protected static class InternalHandshakeListener
/*      */     implements HandshakeCompletedListener
/*      */   {
/*      */     public void handshakeCompleted(HandshakeCompletedEvent event)
/*      */     {
/* 1535 */       MultiplexServerInvoker.access$002(event);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static class SocketGroupInfo
/*      */   {
/*      */     private String socketGroupId;
/* 1403 */     private Set clientInvokers = new HashSet();
/*      */     private MultiplexServerInvoker serverInvoker;
/*      */     private boolean primingSocketNeeded;
/*      */     private VirtualSocket primingSocket;
/*      */     private InetAddress connectAddress;
/*      */     private int connectPort;
/*      */     private InetAddress bindAddress;
/*      */     private int bindPort;
/*      */ 
/*      */     public InetAddress getBindAddress()
/*      */     {
/* 1414 */       return this.bindAddress;
/*      */     }
/*      */ 
/*      */     public void setBindAddress(InetAddress bindAddress)
/*      */     {
/* 1419 */       this.bindAddress = bindAddress;
/*      */     }
/*      */ 
/*      */     public int getBindPort()
/*      */     {
/* 1424 */       return this.bindPort;
/*      */     }
/*      */ 
/*      */     public void setBindPort(int bindPort)
/*      */     {
/* 1429 */       this.bindPort = bindPort;
/*      */     }
/*      */ 
/*      */     public Set getClientInvokers()
/*      */     {
/* 1434 */       return this.clientInvokers;
/*      */     }
/*      */ 
/*      */     public void addClientInvoker(MultiplexClientInvoker clientInvoker)
/*      */     {
/* 1439 */       this.clientInvokers.add(clientInvoker);
/*      */     }
/*      */ 
/*      */     public void removeClientInvoker(MultiplexClientInvoker clientInvoker)
/*      */     {
/* 1444 */       this.clientInvokers.remove(clientInvoker);
/*      */     }
/*      */ 
/*      */     public InetAddress getConnectAddress()
/*      */     {
/* 1449 */       return this.connectAddress;
/*      */     }
/*      */ 
/*      */     public void setConnectAddress(InetAddress connectAddress)
/*      */     {
/* 1454 */       this.connectAddress = connectAddress;
/*      */     }
/*      */ 
/*      */     public int getConnectPort()
/*      */     {
/* 1459 */       return this.connectPort;
/*      */     }
/*      */ 
/*      */     public void setConnectPort(int connectPort)
/*      */     {
/* 1464 */       this.connectPort = connectPort;
/*      */     }
/*      */ 
/*      */     public boolean getPrimingSocketNeeded()
/*      */     {
/* 1469 */       return this.primingSocketNeeded;
/*      */     }
/*      */ 
/*      */     public void setPrimingSocketNeeded(boolean primingSocketNeeded)
/*      */     {
/* 1474 */       this.primingSocketNeeded = primingSocketNeeded;
/*      */     }
/*      */ 
/*      */     public VirtualSocket getPrimingSocket()
/*      */     {
/* 1479 */       return this.primingSocket;
/*      */     }
/*      */ 
/*      */     public void setPrimingSocket(VirtualSocket primingSocket)
/*      */     {
/* 1484 */       this.primingSocket = primingSocket;
/*      */     }
/*      */ 
/*      */     public String getSocketGroupId()
/*      */     {
/* 1489 */       return this.socketGroupId;
/*      */     }
/*      */ 
/*      */     public void setSocketGroupId(String socketGroupId)
/*      */     {
/* 1494 */       this.socketGroupId = socketGroupId;
/*      */     }
/*      */ 
/*      */     public MultiplexServerInvoker getServerInvoker()
/*      */     {
/* 1499 */       return this.serverInvoker;
/*      */     }
/*      */ 
/*      */     public void removeServerInvoker(MultiplexServerInvoker serverInvoker)
/*      */     {
/* 1504 */       if (this.serverInvoker != serverInvoker)
/*      */       {
/* 1506 */         String message = "Attempt to remove unknown MultiplexServerInvoker: (" + this.bindAddress + "," + this.bindPort + ")->(" + this.connectAddress + "," + this.connectPort + ")";
/*      */ 
/* 1509 */         MultiplexServerInvoker.log.error(message);
/*      */       }
/*      */ 
/* 1512 */       this.serverInvoker = null;
/*      */     }
/*      */ 
/*      */     public void setServerInvoker(MultiplexServerInvoker serverInvoker) throws IOException
/*      */     {
/* 1517 */       if ((this.serverInvoker != null) && (serverInvoker != null))
/*      */       {
/* 1519 */         String message = "Second MultiplexServerInvoker attempting to join invoker group: (" + this.bindAddress + "," + this.bindPort + ")->(" + this.connectAddress + "," + this.connectPort + ")";
/*      */ 
/* 1522 */         MultiplexServerInvoker.log.error(message);
/* 1523 */         throw new IOException(message);
/*      */       }
/*      */ 
/* 1526 */       this.serverInvoker = serverInvoker;
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.MultiplexServerInvoker
 * JD-Core Version:    0.6.0
 */