/*     */ package org.jboss.remoting.transport.multiplex;
/*     */ 
/*     */ import java.io.EOFException;
/*     */ import java.io.IOException;
/*     */ import java.io.InterruptedIOException;
/*     */ import java.io.OutputStream;
/*     */ import java.net.Socket;
/*     */ import java.net.SocketTimeoutException;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.transport.multiplex.utility.StoppableThread;
/*     */ import org.jboss.remoting.transport.multiplex.utility.VirtualSelector;
/*     */ 
/*     */ public class Protocol
/*     */ {
/*  56 */   protected static final Logger log = Logger.getLogger(Protocol.class);
/*     */   public static final int MP_CONNECT = 0;
/*     */   public static final int MP_CONNECTED = 1;
/*     */   public static final int MP_VERIFY_CONNECTION = 2;
/*     */   public static final int MP_OUTPUT_SHUTDOWN = 4;
/*     */   public static final int MP_DISCONNECT = 5;
/*     */   public static final int MP_REGISTER_REMOTE_SERVER = 6;
/*     */   public static final int MP_UNREGISTER_REMOTE_SERVER = 7;
/*     */   public static final int MP_REQUEST_MANAGER_SHUTDOWN = 8;
/*     */   public static final int MP_ERROR = 9;
/*     */   public static final int MP_TRUE = 10;
/*     */   public static final int MP_FALSE = 11;
/*     */   private MultiplexingInputStream protocolInputStream;
/*     */   private MultiplexingOutputStream serverSocketOutputStream;
/*     */   private MultiplexingOutputStream protocolOutputStream;
/*     */   private boolean trace;
/*     */   private boolean debug;
/*     */   private boolean info;
/*     */ 
/*     */   public static BackChannelThread getBackChannelThread(VirtualSelector virtualSelector)
/*     */   {
/*  92 */     return new BackChannelThread(virtualSelector);
/*     */   }
/*     */ 
/*     */   public Protocol(MultiplexingManager manager)
/*     */     throws IOException
/*     */   {
/* 103 */     this.protocolInputStream = manager.getAnInputStream(SocketId.PROTOCOL_SOCKET_ID, null);
/* 104 */     this.protocolOutputStream = new MultiplexingOutputStream(manager, SocketId.BACKCHANNEL_SOCKET_ID);
/* 105 */     this.serverSocketOutputStream = new MultiplexingOutputStream(manager, SocketId.SERVER_SOCKET_ID);
/* 106 */     this.trace = log.isTraceEnabled();
/* 107 */     this.debug = log.isDebugEnabled();
/* 108 */     this.info = log.isInfoEnabled();
/*     */   }
/*     */ 
/*     */   public SocketId connect(MultiplexingInputStream is, SocketId socketId)
/*     */     throws IOException
/*     */   {
/* 120 */     return connect(is, socketId, 0);
/*     */   }
/*     */ 
/*     */   public SocketId connect(MultiplexingInputStream is, SocketId socketId, int timeout)
/*     */     throws IOException
/*     */   {
/* 133 */     log.debug("entering Protocol.connect()");
/* 134 */     long start = System.currentTimeMillis();
/* 135 */     int timeLeft = 0;
/* 136 */     int savedTimeout = is.getTimeout();
/*     */ 
/* 138 */     synchronized (this.serverSocketOutputStream)
/*     */     {
/* 140 */       this.serverSocketOutputStream.write(0);
/* 141 */       if (this.debug) log.debug("Protocol.connect(): wrote: CONNECT (0)");
/* 142 */       this.serverSocketOutputStream.writeInt(socketId.getPort());
/* 143 */       if (this.debug) log.debug("Protocol.connect(): wrote port: " + socketId.getPort());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 148 */       if ((timeout > 0) && 
/* 149 */         ((timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0)) {
/* 150 */         throw new SocketTimeoutException();
/*     */       }
/* 152 */       is.setTimeout(timeLeft);
/* 153 */       int messageType = is.read();
/* 154 */       if (this.debug) log.debug("Protocol.connect(): read message type: " + messageType);
/*     */ 
/* 156 */       switch (messageType)
/*     */       {
/*     */       case 1:
/* 159 */         if ((timeout > 0) && 
/* 160 */           ((timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0)) {
/* 161 */           throw new SocketTimeoutException("connect timed out");
/*     */         }
/* 163 */         is.setTimeout(timeLeft);
/* 164 */         int remotePort = is.readInt();
/* 165 */         if (this.debug) log.debug("Protocol.connect(): read port: " + remotePort);
/* 166 */         SocketId localSocketId = new SocketId(remotePort);
/*     */         return localSocketId;
/*     */       }
/* 169 */       log.error("Protocol.connect(): expecting a CONNECTED message: received: " + messageType);
/* 170 */       throw new IOException("Protocol.connect(): expecting a CONNECTED message: received: " + messageType);
/*     */     }
/*     */     catch (SocketTimeoutException e)
/*     */     {
/* 175 */       log.info("timeout in Protocol.connect()");
/* 176 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 180 */       log.error(e);
/* 181 */       StackTraceElement[] stes = e.getStackTrace();
/* 182 */       for (int i = 0; i < stes.length; i++)
/* 183 */         log.error(stes[i].toString());
/* 184 */       throw new IOException(e.getMessage());
/*     */     }
/*     */     finally
/*     */     {
/* 188 */       is.setTimeout(savedTimeout); } throw localObject2;
/*     */   }
/*     */ 
/*     */   public SocketId acceptConnect(MultiplexingInputStream is, int timeout)
/*     */     throws IOException
/*     */   {
/* 202 */     log.debug("entered acceptConnect()");
/* 203 */     long start = System.currentTimeMillis();
/* 204 */     int timeLeft = timeout;
/* 205 */     int savedTimeout = is.getTimeout();
/*     */     try
/*     */     {
/* 209 */       is.setTimeout(timeLeft);
/* 210 */       int messageType = is.read();
/* 211 */       if (this.debug) log.debug("Protocol.acceptConnect(): read message type: " + messageType);
/*     */ 
/* 213 */       switch (messageType)
/*     */       {
/*     */       case 0:
/* 216 */         if ((timeout > 0) && 
/* 217 */           ((timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0)) {
/* 218 */           throw new SocketTimeoutException();
/*     */         }
/* 220 */         is.setTimeout(timeLeft);
/* 221 */         int remotePort = is.readInt();
/* 222 */         if (this.debug) log.debug("Protocol.acceptConnect(): read port: " + remotePort);
/* 223 */         SocketId localSocketId = new SocketId(remotePort);
/*     */         return localSocketId;
/*     */       case -1:
/* 226 */         log.info("Protocol.acceptConnect(): end of file");
/* 227 */         throw new EOFException();
/*     */       }
/*     */ 
/* 230 */       log.error("Protocol.acceptConnect: expecting a CONNECT message: received: " + messageType);
/* 231 */       throw new IOException("Protocol.acceptConnect: expecting a CONNECT message: received: " + messageType);
/*     */     }
/*     */     catch (SocketTimeoutException e)
/*     */     {
/* 236 */       log.info("timeout in Protocol.acceptConnect()");
/* 237 */       throw e;
/*     */     }
/*     */     finally
/*     */     {
/* 241 */       is.setTimeout(savedTimeout); } throw localObject;
/*     */   }
/*     */ 
/*     */   public void answerConnect(MultiplexingOutputStream os, int port)
/*     */     throws IOException
/*     */   {
/* 254 */     os.write(1);
/* 255 */     if (this.debug) log.debug("Protocol.answerConnect(): wrote: CONNECTED (1)");
/* 256 */     os.writeInt(port);
/* 257 */     if (this.debug) log.debug("Protocol.answerConnect(): wrote port: " + port);
/*     */   }
/*     */ 
/*     */   public void notifyOutputShutdown(SocketId socketId)
/*     */   {
/* 267 */     int port = socketId.getPort();
/*     */     try
/*     */     {
/* 271 */       synchronized (this.protocolOutputStream)
/*     */       {
/* 273 */         this.protocolOutputStream.write(4, port);
/* 274 */         this.protocolOutputStream.writeInt(port, port);
/*     */       }
/*     */ 
/* 277 */       if (this.debug) log.debug("Protocol.notifyOutputShutdown(): wrote: OUTPUT_SHUTDOWN (4) for port: " + port);
/*     */     }
/*     */     catch (IOException ignored)
/*     */     {
/* 281 */       log.error("Protocol.notifyOutputShutdown(): unable to send MP_OUTPUT_SHUTDOWN message to port: " + port);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void disconnect(SocketId socketId)
/*     */   {
/* 292 */     int port = socketId.getPort();
/*     */     try
/*     */     {
/* 296 */       synchronized (this.protocolOutputStream)
/*     */       {
/* 298 */         this.protocolOutputStream.write(5, port);
/* 299 */         this.protocolOutputStream.writeInt(port, port);
/*     */       }
/*     */ 
/* 302 */       if (this.debug) log.debug("Protocol.disconnect(): wrote: DISCONNECT (1) for port: " + port);
/*     */     }
/*     */     catch (IOException ignored)
/*     */     {
/* 306 */       log.error("Protocol.disconnect(): unable to send DISCONNECT message to port: " + port);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void registerRemoteServerSocket(int timeout)
/*     */     throws IOException
/*     */   {
/* 316 */     int answer = 11;
/*     */ 
/* 318 */     synchronized (this.protocolInputStream)
/*     */     {
/* 320 */       synchronized (this.protocolOutputStream)
/*     */       {
/* 322 */         this.protocolOutputStream.write(6);
/*     */       }
/*     */ 
/* 325 */       if (this.debug) log.debug("Protocol.registerRemoteServerSocket(): wrote: REGISTER_REMOTE_SERVER (6)");
/* 326 */       this.protocolInputStream.setTimeout(timeout);
/* 327 */       answer = this.protocolInputStream.read();
/*     */     }
/*     */ 
/* 330 */     if (this.debug) log.debug("Protocol.registerRemoteServerSocket(): read: " + (answer == 10 ? "true" : "false"));
/*     */ 
/* 332 */     if (answer == 11)
/* 333 */       throw new IOException("unable to register remote socket");
/*     */   }
/*     */ 
/*     */   public void unregisterRemoteServerSocket()
/*     */   {
/* 342 */     log.debug("unregisterRemoteServerSocket()");
/*     */     try
/*     */     {
/* 346 */       synchronized (this.protocolOutputStream)
/*     */       {
/* 348 */         this.protocolOutputStream.write(7);
/*     */       }
/*     */ 
/* 351 */       if (this.debug) log.debug("Protocol.disconnect(): wrote: UNREGISTER_REMOTE_SERVER (7)");
/*     */     }
/*     */     catch (IOException ignored)
/*     */     {
/* 355 */       log.error("Protocol.unregisterRemoteServerSocket(): unable to send UNREGISTER_REMOTE_SERVER");
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean requestManagerShutdown(int timeout)
/*     */     throws IOException
/*     */   {
/*     */     int b;
/* 364 */     synchronized (this.protocolInputStream)
/*     */     {
/* 366 */       synchronized (this.protocolOutputStream)
/*     */       {
/* 368 */         this.protocolOutputStream.write(8, -1);
/*     */       }
/*     */ 
/* 371 */       if (this.debug) log.debug("Protocol.requestManagerShutdown(): wrote: REQUEST_MANAGER_SHUTDOWN (8)");
/* 372 */       this.protocolInputStream.setTimeout(timeout);
/* 373 */       b = this.protocolInputStream.read();
/*     */     }
/* 377 */     int b;
/* 376 */     boolean answer = b == 10;
/* 377 */     if (this.debug) log.debug("Protocol.requestManagerShutdown(): read: " + answer);
/* 378 */     return answer;
/*     */   }
/*     */ 
/*     */   static class BackChannelThread extends StoppableThread
/*     */   {
/*     */     VirtualSelector virtualSelector;
/*     */     VirtualSocket socket;
/*     */ 
/*     */     public BackChannelThread(VirtualSelector virtualSelector)
/*     */     {
/* 393 */       this.virtualSelector = virtualSelector;
/*     */     }
/*     */ 
/*     */     public void shutdown()
/*     */     {
/* 402 */       Protocol.log.debug("back channel thread: beginning shut down");
/* 403 */       super.shutdown();
/* 404 */       this.virtualSelector.close();
/* 405 */       interrupt();
/*     */     }
/*     */ 
/*     */     protected void doInit()
/*     */     {
/* 414 */       Protocol.log.debug("back channel thread starting");
/*     */     }
/*     */ 
/*     */     protected void doRun()
/*     */     {
/* 423 */       MultiplexingManager manager = null;
/*     */ 
/* 435 */       Map streamMap = this.virtualSelector.select();
/* 436 */       if (streamMap == null) {
/* 437 */         return;
/*     */       }
/* 439 */       Iterator it = streamMap.keySet().iterator();
/* 440 */       while (it.hasNext())
/*     */       {
/*     */         try
/*     */         {
/* 444 */           MultiplexingInputStream is = (MultiplexingInputStream)it.next();
/*     */ 
/* 446 */           if (is.available() == 0)
/*     */           {
/* 448 */             Protocol.log.debug("available == 0");
/* 449 */             this.virtualSelector.remove(is);
/* 450 */             continue;
/*     */           }
/*     */ 
/* 453 */           manager = (MultiplexingManager)streamMap.get(is);
/* 454 */           if (manager == null) {
/*     */             continue;
/*     */           }
/* 457 */           OutputStream os = manager.getBackchannelOutputStream();
/* 458 */           int messageType = is.read();
/* 459 */           Protocol.log.debug("back channel thread: read message type: " + messageType);
/*     */ 
/* 461 */           switch (messageType)
/*     */           {
/*     */           case 4:
/* 465 */             int port = is.readInt();
/* 466 */             if (Protocol.log.isDebugEnabled())
/* 467 */               Protocol.log.debug("back channel thread: read OUTPUT_SHUTDOWN for port: " + port);
/* 468 */             this.socket = manager.getSocketByLocalPort(new SocketId(port));
/*     */ 
/* 470 */             if (this.socket == null)
/*     */             {
/* 472 */               Protocol.log.info("back channel thread (OUTPUT_SHUTDOWN): unable to retrieve socket at port: " + port);
/*     */             }
/*     */             else
/*     */             {
/* 476 */               this.socket.handleRemoteOutputShutDown();
/*     */             }
/*     */ 
/* 479 */             break;
/*     */           case 5:
/* 483 */             int port = is.readInt();
/* 484 */             Protocol.log.debug("back channel thread: read DISCONNECT for port: " + port);
/* 485 */             this.socket = manager.getSocketByLocalPort(new SocketId(port));
/*     */ 
/* 487 */             if (this.socket == null)
/*     */             {
/* 489 */               Protocol.log.info("back channel thread (DISCONNECT): unable to retrieve socket at port: " + port);
/*     */             }
/*     */             else
/*     */             {
/* 493 */               this.socket.handleRemoteDisconnect();
/*     */             }
/*     */ 
/* 496 */             break;
/*     */           case 6:
/* 501 */             Protocol.log.debug("back channel thread: read REGISTER_REMOTE_SERVER");
/* 502 */             int answer = 10;
/*     */             try
/*     */             {
/* 506 */               manager.registerRemoteServerSocket();
/*     */             }
/*     */             catch (Exception e)
/*     */             {
/* 510 */               answer = 11;
/* 511 */               Protocol.log.info("back channel thread: unable to register remote server", e);
/*     */             }
/*     */ 
/* 514 */             os.write(answer);
/* 515 */             break;
/*     */           case 7:
/* 519 */             Protocol.log.debug("back channel thread: read UNREGISTER_REMOTE_SERVER");
/* 520 */             manager.unRegisterRemoteServerSocket();
/*     */ 
/* 522 */             break;
/*     */           case 8:
/* 526 */             Protocol.log.debug("back channel thread: read REQUEST_MANAGER_SHUTDOWN");
/* 527 */             int answer = manager.respondToShutdownRequest() ? 10 : 11;
/* 528 */             if (Protocol.log.isDebugEnabled()) Protocol.log.debug("back channel thread: writing " + answer);
/* 529 */             os.write(answer);
/* 530 */             break;
/*     */           default:
/* 533 */             Protocol.log.error("unexpected message type in back channel thread: " + messageType);
/*     */           }
/*     */         }
/*     */         catch (InterruptedIOException e)
/*     */         {
/* 538 */           if (isRunning())
/* 539 */             Protocol.log.error("back channel thread: i/o interruption", e);
/*     */           else
/* 541 */             Protocol.log.error("back channel thread: i/o interruption");
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 545 */           if (isRunning())
/*     */           {
/* 547 */             Protocol.log.error("back channel thread: i/o error: " + manager.getSocket().toString(), e);
/*     */           }
/*     */           else
/* 550 */             Protocol.log.error("back channel thread: i/o error");
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void doShutDown()
/*     */     {
/* 561 */       Protocol.log.debug("back channel thread shutting down");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.Protocol
 * JD-Core Version:    0.6.0
 */