/*     */ package org.jboss.remoting.transport.multiplex.utility;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class VirtualSelector
/*     */ {
/*  51 */   protected static final Logger log = Logger.getLogger(VirtualSelector.class);
/*  52 */   private Map attachmentMap = new HashMap();
/*  53 */   private Map readyMap = new HashMap();
/*  54 */   private Map readyMapCopy = new HashMap();
/*  55 */   private Set removableStreams = new HashSet();
/*     */ 
/*  57 */   private boolean open = true;
/*     */   private boolean closed;
/*     */   private boolean inUse;
/*     */ 
/*     */   public synchronized void register(GrowablePipedInputStream inputStream, Object attachment)
/*     */   {
/*  69 */     this.attachmentMap.put(inputStream, attachment);
/*     */   }
/*     */ 
/*     */   public synchronized void unregister(InputStream inputStream)
/*     */   {
/*  79 */     this.attachmentMap.remove(inputStream);
/*  80 */     this.readyMap.remove(inputStream);
/*  81 */     this.removableStreams.add(inputStream);
/*     */   }
/*     */ 
/*     */   public synchronized Map select()
/*     */   {
/*  94 */     if (this.closed) {
/*  95 */       return null;
/*     */     }
/*     */ 
/*  98 */     Iterator it = this.removableStreams.iterator();
/*  99 */     while (it.hasNext())
/*     */     {
/* 101 */       this.readyMapCopy.remove(it.next());
/*     */     }
/* 103 */     this.removableStreams.clear();
/*     */ 
/* 106 */     this.readyMapCopy.putAll(this.readyMap);
/* 107 */     this.readyMap.clear();
/*     */ 
/* 110 */     if (!this.readyMapCopy.isEmpty()) {
/* 111 */       return this.readyMapCopy;
/*     */     }
/*     */ 
/* 114 */     while ((this.readyMap.isEmpty()) && (this.open))
/*     */     {
/*     */       try
/*     */       {
/* 118 */         this.inUse = true;
/* 119 */         wait();
/*     */ 
/* 124 */         this.inUse = false;
/* 125 */         continue;
/*     */       }
/*     */       catch (InterruptedException ignored)
/*     */       {
/* 124 */         this.inUse = false;
/* 125 */         continue;
/*     */       }
/*     */       finally
/*     */       {
/* 124 */         this.inUse = false;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 129 */     if (this.readyMap.isEmpty())
/*     */     {
/* 131 */       log.debug("returning null");
/* 132 */       finishClose();
/* 133 */       return null;
/*     */     }
/*     */ 
/* 137 */     this.readyMapCopy.putAll(this.readyMap);
/* 138 */     this.readyMap.clear();
/* 139 */     return this.readyMapCopy;
/*     */   }
/*     */ 
/*     */   public boolean isOpen()
/*     */   {
/* 149 */     return this.open;
/*     */   }
/*     */ 
/*     */   public synchronized void close()
/*     */   {
/* 159 */     this.open = false;
/*     */ 
/* 161 */     if (this.inUse)
/* 162 */       notifyAll();
/*     */     else
/* 164 */       finishClose();
/*     */   }
/*     */ 
/*     */   public synchronized void addToReadyInputStreams(InputStream inputStream)
/*     */     throws IOException
/*     */   {
/* 176 */     if (!this.open) {
/* 177 */       throw new IOException("This VirtualSelector is closed.");
/*     */     }
/* 179 */     this.readyMap.put(inputStream, this.attachmentMap.get(inputStream));
/* 180 */     notifyAll();
/*     */   }
/*     */ 
/*     */   public synchronized void remove(InputStream inputStream)
/*     */     throws IOException
/*     */   {
/* 197 */     this.removableStreams.add(inputStream);
/*     */   }
/*     */ 
/*     */   public synchronized void waitUntilEmpty()
/*     */   {
/* 203 */     while (!this.readyMap.isEmpty())
/*     */     {
/*     */       try
/*     */       {
/* 207 */         log.debug("waiting until empty");
/* 208 */         wait();
/*     */       } catch (InterruptedException ignored) {
/*     */       }
/*     */     }
/* 212 */     log.debug("empty");
/*     */   }
/*     */ 
/*     */   protected void finishClose()
/*     */   {
/* 221 */     this.attachmentMap.clear();
/* 222 */     this.readyMap.clear();
/* 223 */     this.readyMapCopy.clear();
/* 224 */     this.removableStreams.clear();
/* 225 */     this.closed = true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.utility.VirtualSelector
 * JD-Core Version:    0.6.0
 */