/*     */ package org.jboss.remoting.transport.rmi;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.rmi.Remote;
/*     */ import java.rmi.RemoteException;
/*     */ import java.rmi.registry.LocateRegistry;
/*     */ import java.rmi.registry.Registry;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.AbstractInvoker;
/*     */ import org.jboss.remoting.CannotConnectException;
/*     */ import org.jboss.remoting.ConnectionFailedException;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.RemoteClientInvoker;
/*     */ import org.jboss.remoting.Version;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.MarshallerDecorator;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ import org.jboss.remoting.marshal.VersionedMarshaller;
/*     */ import org.jboss.remoting.marshal.rmi.RMIMarshaller;
/*     */ 
/*     */ public class RMIClientInvoker extends RemoteClientInvoker
/*     */ {
/*  59 */   private static final Logger log = Logger.getLogger(RMIClientInvoker.class);
/*  60 */   private static final boolean isTraceEnabled = log.isTraceEnabled();
/*     */   private RMIServerInvokerInf server;
/*  71 */   private boolean connected = false;
/*     */ 
/*     */   public RMIClientInvoker(InvokerLocator locator)
/*     */   {
/*  75 */     super(locator);
/*     */   }
/*     */ 
/*     */   public RMIClientInvoker(InvokerLocator locator, Map configuration)
/*     */   {
/*  80 */     super(locator, configuration);
/*     */   }
/*     */ 
/*     */   private int getRegistryPort(InvokerLocator locator)
/*     */   {
/*  86 */     int port = 3455;
/*     */ 
/*  89 */     Map params = locator.getParameters();
/*  90 */     if (params != null)
/*     */     {
/*  92 */       String value = (String)params.get("registryPort");
/*  93 */       if (value != null)
/*     */       {
/*     */         try
/*     */         {
/*  97 */           port = Integer.parseInt(value);
/*  98 */           log.debug("Using port " + port + " for rmi registry.");
/*     */         }
/*     */         catch (NumberFormatException e)
/*     */         {
/* 102 */           log.error("Can not set the RMIServerInvoker RMI registry to port " + value + ".  This is not a valid port number.");
/*     */         }
/*     */       }
/*     */     }
/* 106 */     return port;
/*     */   }
/*     */ 
/*     */   public void setServerStub(RMIServerInvokerInf server)
/*     */   {
/* 116 */     this.server = server;
/* 117 */     log.trace(this.server);
/*     */   }
/*     */ 
/*     */   public RMIServerInvokerInf getServerStub()
/*     */   {
/* 127 */     return this.server;
/*     */   }
/*     */ 
/*     */   protected void handleConnect()
/*     */     throws ConnectionFailedException
/*     */   {
/*     */     try
/*     */     {
/* 145 */       storeLocalConfig(this.configuration);
/* 146 */       String host = this.locator.getHost();
/* 147 */       int port = getRegistryPort(this.locator);
/* 148 */       Registry regsitry = LocateRegistry.getRegistry(host, port);
/* 149 */       Remote remoteObj = regsitry.lookup("remoting/RMIServerInvoker/" + this.locator.getPort());
/* 150 */       log.debug("Remote RMI Stub: " + remoteObj);
/* 151 */       setServerStub((RMIServerInvokerInf)remoteObj);
/* 152 */       this.connected = true;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 156 */       this.connected = false;
/* 157 */       log.debug("Error connecting RMI invoker client.", e);
/* 158 */       throw new CannotConnectException("Error connecting RMI invoker client", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void handleDisconnect()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected String getDefaultDataType()
/*     */   {
/* 174 */     return "rmi";
/*     */   }
/*     */ 
/*     */   protected void storeLocalConfig(Map config)
/*     */   {
/* 179 */     HashMap localConfig = new HashMap(config);
/*     */ 
/* 185 */     if ((this.socketFactory != null) && (!this.socketFactoryCreatedFromSSLParameters) && (AbstractInvoker.isCompleteSocketFactory(this.socketFactory)))
/*     */     {
/* 188 */       localConfig.put("customSocketFactory", this.socketFactory);
/*     */     }
/*     */ 
/* 191 */     RemotingRMIClientSocketFactory.addLocalConfiguration(this.locator, localConfig);
/*     */   }
/*     */ 
/*     */   protected Object transport(String sessionId, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller)
/*     */     throws IOException, ConnectionFailedException
/*     */   {
/* 197 */     if (this.server == null)
/*     */     {
/* 199 */       log.error("Server stub has not been set in RMI invoker client.  See previous errors for details.");
/*     */ 
/* 201 */       throw new CannotConnectException("Server stub has not been set.");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 206 */       Object payload = invocation;
/* 207 */       if ((marshaller != null) && (!(marshaller instanceof RMIMarshaller)))
/*     */       {
/* 209 */         if ((marshaller instanceof MarshallerDecorator))
/*     */         {
/* 211 */           payload = ((MarshallerDecorator)marshaller).addDecoration(payload);
/*     */         }
/*     */         else
/*     */         {
/* 215 */           ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
/* 216 */           if ((marshaller instanceof VersionedMarshaller))
/* 217 */             ((VersionedMarshaller)marshaller).write(payload, byteOut, Version.getDefaultVersion());
/*     */           else
/* 219 */             marshaller.write(payload, byteOut);
/* 220 */           ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
/* 221 */           ObjectInputStream ois = new ObjectInputStream(byteIn);
/*     */           try
/*     */           {
/* 225 */             byteOut.close();
/* 226 */             payload = ois.readObject();
/* 227 */             ois.close();
/*     */           }
/*     */           catch (ClassNotFoundException e)
/*     */           {
/* 231 */             log.error("Could not marshall invocation payload object " + payload, e);
/* 232 */             throw new IOException(e.getMessage());
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 238 */       Object response = this.server.transport(payload);
/*     */ 
/* 268 */       return response;
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/* 272 */       log.error(e);
/* 273 */     }throw new CannotConnectException("Error making invocation in RMI client invoker.", e);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.rmi.RMIClientInvoker
 * JD-Core Version:    0.6.0
 */