/*     */ package org.jboss.remoting.transport.rmi;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.rmi.NoSuchObjectException;
/*     */ import java.rmi.Remote;
/*     */ import java.rmi.RemoteException;
/*     */ import java.rmi.registry.LocateRegistry;
/*     */ import java.rmi.registry.Registry;
/*     */ import java.rmi.server.ExportException;
/*     */ import java.rmi.server.RMIClientSocketFactory;
/*     */ import java.rmi.server.RMIServerSocketFactory;
/*     */ import java.rmi.server.UnicastRemoteObject;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.net.SocketFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.marshal.MarshalFactory;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ import org.jboss.remoting.marshal.UnMarshallerDecorator;
/*     */ 
/*     */ public class RMIServerInvoker extends ServerInvoker
/*     */   implements RMIServerInvokerInf
/*     */ {
/*  60 */   private static final Logger log = Logger.getLogger(RMIServerInvoker.class);
/*     */   private Remote stub;
/*     */   public static final int BACKLOG_DEFAULT = 200;
/*     */   public static final int DEFAULT_REGISTRY_PORT = 3455;
/*     */   public static final String REGISTRY_PORT_KEY = "registryPort";
/*  79 */   private Marshaller marshaller = null;
/*  80 */   private UnMarshaller unmarshaller = null;
/*     */ 
/*     */   public RMIServerInvoker(InvokerLocator locator)
/*     */   {
/*  84 */     super(locator);
/*     */   }
/*     */ 
/*     */   public void start() throws IOException
/*     */   {
/*  89 */     super.start();
/*     */ 
/*  91 */     int bindPort = getServerBindPort();
/*  92 */     Registry registry = null;
/*     */     try
/*     */     {
/*  96 */       registry = getRegistry();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 100 */       throw new IOException(e.getMessage());
/*     */     }
/*     */ 
/* 104 */     String bindHost = getServerBindAddress();
/* 105 */     String clientConnectHost = getClientConnectAddress();
/*     */ 
/* 107 */     if (clientConnectHost == null)
/*     */     {
/* 109 */       clientConnectHost = bindHost;
/*     */     }
/*     */ 
/* 112 */     RMIServerSocketFactory ssf = new RemotingRMIServerSocketFactory(getServerSocketFactory(), 200, bindHost, getTimeout());
/* 113 */     RMIClientSocketFactory csf = getRMIClientSocketFactory(clientConnectHost);
/* 114 */     this.stub = UnicastRemoteObject.exportObject(this, bindPort, csf, ssf);
/*     */ 
/* 116 */     log.debug("Binding registry to remoting/RMIServerInvoker/" + bindPort);
/* 117 */     registry.rebind("remoting/RMIServerInvoker/" + bindPort, this);
/*     */ 
/* 119 */     this.unmarshaller = MarshalFactory.getUnMarshaller(getLocator(), getClass().getClassLoader());
/* 120 */     this.marshaller = MarshalFactory.getMarshaller(getLocator(), getClass().getClassLoader());
/*     */   }
/*     */ 
/*     */   protected RMIClientSocketFactory getRMIClientSocketFactory(String clientConnectHost)
/*     */   {
/* 127 */     HashMap remoteConfig = new HashMap(this.configuration);
/* 128 */     remoteConfig.remove("customServerSocketFactory");
/* 129 */     remoteConfig.remove("socketCreationClientListener");
/* 130 */     remoteConfig.remove("socketCreationServerListener");
/* 131 */     return new RemotingRMIClientSocketFactory(this.locator, clientConnectHost, getTimeout(), remoteConfig);
/*     */   }
/*     */ 
/*     */   protected SocketFactory getDefaultSocketFactory()
/*     */   {
/* 145 */     return null;
/*     */   }
/*     */ 
/*     */   public RMIServerInvoker(InvokerLocator locator, Map configuration)
/*     */   {
/* 151 */     super(locator, configuration);
/*     */   }
/*     */ 
/*     */   private Registry getRegistry() throws Exception
/*     */   {
/* 156 */     Registry registry = null;
/*     */ 
/* 158 */     int port = 3455;
/*     */ 
/* 161 */     Map params = getConfiguration();
/* 162 */     if (params != null)
/*     */     {
/* 164 */       String value = (String)params.get("registryPort");
/* 165 */       if (value != null)
/*     */       {
/*     */         try
/*     */         {
/* 169 */           port = Integer.parseInt(value);
/* 170 */           log.debug("Using port " + port + " for rmi registry.");
/*     */         }
/*     */         catch (NumberFormatException e)
/*     */         {
/* 174 */           throw new Exception("Can not set the RMIServerInvoker RMI registry to port " + value + ".  This is not a valid port number.");
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 181 */       log.debug("Creating registry for " + port);
/*     */ 
/* 183 */       registry = LocateRegistry.createRegistry(port);
/*     */     }
/*     */     catch (ExportException exportEx)
/*     */     {
/* 187 */       log.debug("Locating registry for " + port);
/*     */ 
/* 190 */       registry = LocateRegistry.getRegistry(port);
/*     */     }
/* 192 */     if (log.isTraceEnabled())
/*     */     {
/* 194 */       log.trace("Got registry: " + registry);
/*     */     }
/* 196 */     return registry;
/*     */   }
/*     */ 
/*     */   protected String getDefaultDataType()
/*     */   {
/* 201 */     return "serializable";
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 209 */     super.destroy();
/*     */     try
/*     */     {
/*     */       try
/*     */       {
/* 214 */         log.debug("unbinding remoting/RMIServerInvoker/" + this.locator.getPort() + " from registry running on port " + (this.locator.getPort() + 1));
/* 215 */         Registry registry = getRegistry();
/* 216 */         registry.unbind("remoting/RMIServerInvoker/" + this.locator.getPort());
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 220 */         log.error("Error unbinding RMIServerInvoker from RMI registry.", e);
/*     */       }
/*     */ 
/* 223 */       UnicastRemoteObject.unexportObject(this, true);
/*     */     }
/*     */     catch (NoSuchObjectException e)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void finalize()
/*     */     throws Throwable
/*     */   {
/* 234 */     destroy();
/* 235 */     super.finalize();
/*     */   }
/*     */ 
/*     */   public boolean isTransportBiDirectional()
/*     */   {
/* 245 */     return true;
/*     */   }
/*     */ 
/*     */   public final Remote getStub()
/*     */   {
/* 250 */     return this.stub;
/*     */   }
/*     */ 
/*     */   public Object transport(Object invocation)
/*     */     throws RemoteException, IOException
/*     */   {
/* 257 */     Object payload = invocation;
/* 258 */     if (this.unmarshaller != null)
/*     */     {
/* 260 */       if ((this.unmarshaller instanceof UnMarshallerDecorator))
/*     */       {
/* 262 */         payload = ((UnMarshallerDecorator)this.unmarshaller).removeDecoration(payload);
/*     */       }
/*     */       else
/*     */       {
/* 266 */         ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
/* 267 */         ObjectOutputStream oos = new ObjectOutputStream(byteOut);
/* 268 */         oos.writeObject(payload);
/* 269 */         oos.flush();
/*     */ 
/* 271 */         ByteArrayInputStream is = new ByteArrayInputStream(byteOut.toByteArray());
/*     */         try
/*     */         {
/* 275 */           oos.close();
/* 276 */           payload = this.unmarshaller.read(is, null);
/* 277 */           is.close();
/*     */         }
/*     */         catch (ClassNotFoundException e)
/*     */         {
/* 281 */           log.error("Could not unmarshall invocation request" + payload, e);
/* 282 */           throw new IOException(e.getMessage());
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 288 */     Object response = invoke(payload);
/*     */ 
/* 316 */     return response;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.rmi.RMIServerInvoker
 * JD-Core Version:    0.6.0
 */