/*     */ package org.jboss.remoting.transport.sslmultiplex;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.Map;
/*     */ import javax.net.ServerSocketFactory;
/*     */ import javax.net.SocketFactory;
/*     */ import javax.net.ssl.SSLServerSocketFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.security.CustomSSLServerSocketFactory;
/*     */ import org.jboss.remoting.security.SSLSocketBuilder;
/*     */ import org.jboss.remoting.security.SSLSocketBuilderMBean;
/*     */ import org.jboss.remoting.transport.multiplex.MultiplexServerInvoker;
/*     */ 
/*     */ public class SSLMultiplexServerInvoker extends MultiplexServerInvoker
/*     */ {
/*     */   public SSLMultiplexServerInvoker(InvokerLocator locator)
/*     */   {
/*  60 */     super(locator);
/*     */   }
/*     */ 
/*     */   public SSLMultiplexServerInvoker(InvokerLocator locator, Map configuration)
/*     */     throws IOException
/*     */   {
/*  70 */     super(locator, configuration);
/*     */   }
/*     */ 
/*     */   protected SocketFactory createSocketFactory(Map configuration)
/*     */   {
/*  79 */     SocketFactory socketFactory = null;
/*  80 */     if ((socketFactory = super.createSocketFactory(configuration)) != null) {
/*  81 */       return socketFactory;
/*     */     }
/*  83 */     ServerSocketFactory serverSocketFactory = getServerSocketFactory();
/*     */     try
/*     */     {
/*  87 */       if ((serverSocketFactory instanceof CustomSSLServerSocketFactory))
/*     */       {
/*  89 */         CustomSSLServerSocketFactory customServerSocketFactory = (CustomSSLServerSocketFactory)serverSocketFactory;
/*  90 */         SSLSocketBuilderMBean builder = customServerSocketFactory.getSSLSocketBuilder();
/*  91 */         boolean shouldUseDefault = builder.getUseSSLServerSocketFactory();
/*  92 */         builder.setUseSSLSocketFactory(shouldUseDefault);
/*  93 */         boolean useClientMode = builder.isServerSocketUseClientMode();
/*  94 */         builder.setSocketUseClientMode(useClientMode);
/*  95 */         return builder.createSSLSocketFactory();
/*     */       }
/*     */ 
/*  98 */       SSLSocketBuilder builder = new SSLSocketBuilder(configuration);
/*  99 */       return builder.createSSLSocketFactory();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 103 */       log.error("Error creating SSL Socket Factory for server invoker.", e);
/*     */     }
/* 105 */     return null;
/*     */   }
/*     */ 
/*     */   protected ServerSocketFactory getDefaultServerSocketFactory()
/*     */   {
/* 111 */     return SSLServerSocketFactory.getDefault();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.sslmultiplex.SSLMultiplexServerInvoker
 * JD-Core Version:    0.6.0
 */