/*     */ package org.jboss.remoting.transport.sslsocket;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.InetSocketAddress;
/*     */ import java.net.Socket;
/*     */ import java.util.Map;
/*     */ import javax.net.SocketFactory;
/*     */ import javax.net.ssl.HandshakeCompletedListener;
/*     */ import javax.net.ssl.SSLSocket;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.security.SSLSocketBuilder;
/*     */ import org.jboss.remoting.socketfactory.SocketFactoryWrapper;
/*     */ import org.jboss.remoting.transport.socket.SocketClientInvoker;
/*     */ import org.jboss.remoting.util.socket.HandshakeRepeater;
/*     */ 
/*     */ public class SSLSocketClientInvoker extends SocketClientInvoker
/*     */ {
/*  46 */   private static final Logger log = Logger.getLogger(SSLSocketClientInvoker.class);
/*  47 */   private static final boolean isTraceEnabled = log.isTraceEnabled();
/*     */ 
/*     */   public SSLSocketClientInvoker(InvokerLocator locator) throws IOException
/*     */   {
/*  51 */     super(locator);
/*     */     try
/*     */     {
/*  54 */       setup();
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*  58 */       log.error("Error setting up ssl socket client invoker.", ex);
/*  59 */       throw new RuntimeException(ex.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   public SSLSocketClientInvoker(InvokerLocator locator, Map configuration) throws IOException
/*     */   {
/*  65 */     super(locator, configuration);
/*     */     try
/*     */     {
/*  68 */       setup();
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*  72 */       log.error("Error setting up ssl socket client invoker.", ex);
/*  73 */       throw new RuntimeException(ex.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected SocketFactory createSocketFactory(Map configuration)
/*     */   {
/*  79 */     SocketFactory sf = super.createSocketFactory(configuration);
/*     */ 
/*  81 */     if (isCompleteSocketFactory(sf))
/*     */     {
/*  83 */       return sf;
/*     */     }
/*     */ 
/*  86 */     SocketFactory wrapper = sf;
/*     */     try
/*     */     {
/*  90 */       SSLSocketBuilder server = new SSLSocketBuilder(configuration);
/*  91 */       sf = server.createSSLSocketFactory();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  95 */       log.error("Error creating SSL Socket Factory for client invoker.", e);
/*     */     }
/*     */ 
/*  98 */     if (wrapper != null)
/*     */     {
/* 100 */       ((SocketFactoryWrapper)wrapper).setSocketFactory(sf);
/* 101 */       this.socketFactory = wrapper;
/* 102 */       return wrapper;
/*     */     }
/*     */ 
/* 105 */     return sf;
/*     */   }
/*     */ 
/*     */   protected Socket createSocket(String address, int port, int timeout)
/*     */     throws IOException
/*     */   {
/* 111 */     SocketFactory sf = getSocketFactory();
/*     */ 
/* 113 */     if (sf == null) {
/* 114 */       sf = createSocketFactory(this.configuration);
/*     */     }
/* 116 */     Socket s = sf.createSocket();
/*     */ 
/* 118 */     s.setReuseAddress(getReuseAddress());
/* 119 */     InetSocketAddress inetAddr = new InetSocketAddress(address, port);
/*     */ 
/* 121 */     if (timeout < 0)
/*     */     {
/* 123 */       timeout = getTimeout();
/* 124 */       if (timeout < 0) {
/* 125 */         timeout = 0;
/*     */       }
/*     */     }
/* 128 */     s.connect(inetAddr, timeout);
/*     */ 
/* 130 */     if ((s instanceof SSLSocket))
/*     */     {
/* 133 */       Object obj = this.configuration.get("handshakeCompletedListener");
/* 134 */       if ((obj != null) && ((obj instanceof HandshakeCompletedListener)))
/*     */       {
/* 136 */         SSLSocket sslSocket = (SSLSocket)s;
/* 137 */         HandshakeCompletedListener listener = (HandshakeCompletedListener)obj;
/* 138 */         establishHandshake(sslSocket, listener);
/*     */       }
/*     */     }
/*     */ 
/* 142 */     return s;
/*     */   }
/*     */ 
/*     */   private void establishHandshake(SSLSocket sslSocket, HandshakeCompletedListener listener)
/*     */     throws IOException
/*     */   {
/* 148 */     HandshakeRepeater repeater = new HandshakeRepeater(listener);
/* 149 */     sslSocket.addHandshakeCompletedListener(repeater);
/* 150 */     sslSocket.getSession();
/* 151 */     repeater.waitForHandshake();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.sslsocket.SSLSocketClientInvoker
 * JD-Core Version:    0.6.0
 */