/*     */ package org.jboss.remoting.transport.web;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.marshal.MarshalFactory;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ 
/*     */ public abstract class WebServerInvoker extends ServerInvoker
/*     */ {
/*  47 */   public static String HEADER_SESSION_ID = "sessionId";
/*  48 */   public static String HEADER_SUBSYSTEM = "subsystem";
/*     */ 
/*     */   public WebServerInvoker(InvokerLocator locator)
/*     */   {
/*  53 */     super(locator);
/*     */   }
/*     */ 
/*     */   public WebServerInvoker(InvokerLocator locator, Map configuration)
/*     */   {
/*  58 */     super(locator, configuration);
/*     */   }
/*     */ 
/*     */   public boolean isTransportBiDirectional()
/*     */   {
/*  69 */     return false;
/*     */   }
/*     */ 
/*     */   protected String getDefaultDataType()
/*     */   {
/*  74 */     return "http";
/*     */   }
/*     */ 
/*     */   protected InvocationRequest getInvocationRequest(Map metadata, Object obj)
/*     */   {
/*  79 */     InvocationRequest request = null;
/*     */ 
/*  81 */     if ((obj instanceof InvocationRequest))
/*     */     {
/*  83 */       request = (InvocationRequest)obj;
/*  84 */       if (request.getRequestPayload() == null)
/*     */       {
/*  86 */         request.setRequestPayload(metadata);
/*     */       }
/*     */       else
/*     */       {
/*  90 */         request.getRequestPayload().putAll(metadata);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*  95 */       request = createNewInvocationRequest(metadata, obj);
/*     */     }
/*  97 */     return request;
/*     */   }
/*     */ 
/*     */   public UnMarshaller getUnMarshaller()
/*     */   {
/* 102 */     UnMarshaller unmarshaller = MarshalFactory.getUnMarshaller(getLocator(), getClass().getClassLoader());
/* 103 */     if (unmarshaller == null)
/*     */     {
/* 105 */       unmarshaller = MarshalFactory.getUnMarshaller(getDataType(), getSerializationType());
/*     */     }
/* 107 */     return unmarshaller;
/*     */   }
/*     */ 
/*     */   public Marshaller getMarshaller()
/*     */   {
/* 112 */     Marshaller marshaller = MarshalFactory.getMarshaller(getLocator(), getClass().getClassLoader());
/*     */ 
/* 114 */     if (marshaller == null)
/*     */     {
/* 116 */       marshaller = MarshalFactory.getMarshaller(getDataType(), getSerializationType());
/*     */     }
/* 118 */     return marshaller;
/*     */   }
/*     */ 
/*     */   protected InvocationRequest createNewInvocationRequest(Map metadata, Object payload)
/*     */   {
/* 125 */     String sessionId = getSessionId(metadata);
/* 126 */     String subSystem = (String)metadata.get(HEADER_SUBSYSTEM);
/*     */ 
/* 128 */     InvocationRequest request = null;
/* 129 */     Map responseMap = new HashMap();
/* 130 */     boolean isLeasQuery = checkForLeaseQuery(metadata);
/* 131 */     if (isLeasQuery)
/*     */     {
/* 133 */       addLeaseInfo(responseMap);
/* 134 */       request = new InvocationRequest(sessionId, subSystem, "$PING$", null, responseMap, null);
/*     */     }
/*     */     else
/*     */     {
/* 138 */       request = new InvocationRequest(sessionId, subSystem, payload, metadata, null, null);
/*     */     }
/* 140 */     request.setReturnPayload(responseMap);
/* 141 */     return request;
/*     */   }
/*     */ 
/*     */   private boolean checkForLeaseQuery(Map headers)
/*     */   {
/* 146 */     boolean isLeaseQuery = false;
/*     */ 
/* 148 */     if (headers != null)
/*     */     {
/* 150 */       Object val = headers.get("JBoss-Remoting-Lease-Query");
/* 151 */       if ((val != null) && ((val instanceof String)))
/*     */       {
/* 153 */         isLeaseQuery = Boolean.valueOf((String)val).booleanValue();
/*     */       }
/*     */       else
/*     */       {
/* 157 */         val = headers.get("jboss-remoting-lease-query");
/* 158 */         if ((val != null) && ((val instanceof String)))
/*     */         {
/* 160 */           isLeaseQuery = Boolean.valueOf((String)val).booleanValue();
/*     */         }
/*     */       }
/*     */     }
/* 164 */     return isLeaseQuery;
/*     */   }
/*     */ 
/*     */   private void addLeaseInfo(Map response)
/*     */   {
/* 169 */     boolean leaseManagement = isLeaseActivated();
/* 170 */     response.put("LEASING_ENABLED", new Boolean(leaseManagement));
/*     */ 
/* 172 */     if (leaseManagement)
/*     */     {
/* 174 */       long leasePeriod = getLeasePeriod();
/* 175 */       response.put("LEASE_PERIOD", new Long(leasePeriod));
/*     */     }
/*     */   }
/*     */ 
/*     */   protected String getSessionId(Map metadata)
/*     */   {
/* 183 */     String sessionId = (String)metadata.get(HEADER_SESSION_ID);
/*     */ 
/* 185 */     if ((sessionId == null) || (sessionId.length() == 0))
/*     */     {
/* 187 */       String userAgent = (String)metadata.get("User-Agent");
/* 188 */       String host = (String)metadata.get("Host");
/* 189 */       String idSeed = userAgent + ":" + host;
/* 190 */       sessionId = Integer.toString(idSeed.hashCode());
/*     */     }
/*     */ 
/* 193 */     return sessionId;
/*     */   }
/*     */ 
/*     */   protected int getContentLength(Object response)
/*     */     throws IOException
/*     */   {
/* 206 */     if (response != null)
/*     */     {
/* 215 */       if ((response instanceof String))
/*     */       {
/* 217 */         return ((String)response).length();
/*     */       }
/*     */ 
/* 221 */       ByteArrayOutputStream bos = new ByteArrayOutputStream();
/* 222 */       ObjectOutputStream oos = new ObjectOutputStream(bos);
/* 223 */       oos.writeObject(response);
/* 224 */       oos.flush();
/* 225 */       bos.flush();
/* 226 */       byte[] buffer = bos.toByteArray();
/* 227 */       return buffer.length;
/*     */     }
/*     */ 
/* 232 */     return 0;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.web.WebServerInvoker
 * JD-Core Version:    0.6.0
 */